/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerInfo {
    private static final Logger log = LoggerFactory.getLogger(WorkerInfo.class);
    private static final RuntimeMXBean RUNTIME = ManagementFactory.getRuntimeMXBean();
    private static final OperatingSystemMXBean OS = ManagementFactory.getOperatingSystemMXBean();
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();

    public WorkerInfo() {
        this.addRuntimeInfo();
        this.addSystemInfo();
    }

    public void logAll() {
        StringBuilder b2 = new StringBuilder();
        b2.append(this.getClass().getSimpleName());
        b2.append(" values: ");
        b2.append(Utils.NL);
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            b2.append('\t');
            b2.append(entry.getKey());
            b2.append(" = ");
            b2.append(WorkerInfo.format(entry.getValue()));
            b2.append(Utils.NL);
        }
        log.info(b2.toString());
    }

    private static Object format(Object value) {
        return value == null ? "NA" : value;
    }

    protected void addRuntimeInfo() {
        List<String> jvmArgs = RUNTIME.getInputArguments();
        this.values.put("jvm.args", Utils.join(jvmArgs, ", "));
        String[] jvmSpec = new String[]{RUNTIME.getVmVendor(), RUNTIME.getVmName(), RUNTIME.getSystemProperties().get("java.version"), RUNTIME.getVmVersion()};
        this.values.put("jvm.spec", Utils.join(jvmSpec, ", "));
        this.values.put("jvm.classpath", RUNTIME.getClassPath());
    }

    protected void addSystemInfo() {
        String[] osInfo = new String[]{OS.getName(), OS.getArch(), OS.getVersion()};
        this.values.put("os.spec", Utils.join(osInfo, ", "));
        this.values.put("os.vcpus", String.valueOf(OS.getAvailableProcessors()));
    }
}

