/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.AppInfoParser;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.Connector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.Task;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockConnector
extends Connector {
    public static final String MOCK_MODE_KEY = "mock_mode";
    public static final String DELAY_MS_KEY = "delay_ms";
    public static final String CONNECTOR_FAILURE = "connector-failure";
    public static final String TASK_FAILURE = "task-failure";
    public static final long DEFAULT_FAILURE_DELAY_MS = 15000L;
    private static final Logger log = LoggerFactory.getLogger(MockConnector.class);
    private Map<String, String> config;
    private ScheduledExecutorService executor;

    @Override
    public String version() {
        return AppInfoParser.getVersion();
    }

    @Override
    public void start(Map<String, String> config) {
        this.config = config;
        if (CONNECTOR_FAILURE.equals(config.get(MOCK_MODE_KEY))) {
            String delayMsString = config.get(DELAY_MS_KEY);
            long delayMs = 15000L;
            if (delayMsString != null) {
                delayMs = Long.parseLong(delayMsString);
            }
            log.debug("Started MockConnector with failure delay of {} ms", (Object)delayMs);
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    log.debug("Triggering connector failure");
                    MockConnector.this.context.raiseError(new RuntimeException());
                }
            }, delayMs, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Class<? extends Task> taskClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        log.debug("Creating single task for MockConnector");
        return Collections.singletonList(this.config);
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            try {
                if (!this.executor.awaitTermination(20L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("Failed timely termination of scheduler");
                }
            }
            catch (InterruptedException e2) {
                throw new RuntimeException("Task was interrupted during shutdown");
            }
        }
    }

    @Override
    public ConfigDef config() {
        return new ConfigDef();
    }
}

