/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkRecord;
import java.util.Map;

public class Requirements {
    public static void requireSchema(Schema schema, String purpose) {
        if (schema == null) {
            throw new DataException("Schema required for [" + purpose + "]");
        }
    }

    public static Map<String, Object> requireMap(Object value, String purpose) {
        if (!(value instanceof Map)) {
            throw new DataException("Only Map objects supported in absence of schema for [" + purpose + "], found: " + Requirements.nullSafeClassName(value));
        }
        return (Map)value;
    }

    public static Map<String, Object> requireMapOrNull(Object value, String purpose) {
        if (value == null) {
            return null;
        }
        return Requirements.requireMap(value, purpose);
    }

    public static Struct requireStruct(Object value, String purpose) {
        if (!(value instanceof Struct)) {
            throw new DataException("Only Struct objects supported for [" + purpose + "], found: " + Requirements.nullSafeClassName(value));
        }
        return (Struct)value;
    }

    public static Struct requireStructOrNull(Object value, String purpose) {
        if (value == null) {
            return null;
        }
        return Requirements.requireStruct(value, purpose);
    }

    public static SinkRecord requireSinkRecord(ConnectRecord<?> record, String purpose) {
        if (!(record instanceof SinkRecord)) {
            throw new DataException("Only SinkRecord supported for [" + purpose + "], found: " + Requirements.nullSafeClassName(record));
        }
        return (SinkRecord)record;
    }

    private static String nullSafeClassName(Object x2) {
        return x2 == null ? "null" : x2.getClass().getName();
    }
}

