/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.agent;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.LongNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Exit;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Scheduler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.agent.AgentRestResource;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.agent.WorkerManager;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.JsonUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Node;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Platform;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.AgentStatusResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.DestroyWorkerRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.JsonRestServer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.StopWorkerRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.UptimeResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskController;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskSpec;
import java.io.PrintStream;
import java.util.Set;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Agent {
    private static final Logger log = LoggerFactory.getLogger(Agent.class);
    public static final int DEFAULT_PORT = 8888;
    private static final long EXEC_WORKER_ID = 1L;
    private static final String EXEC_TASK_ID = "task0";
    private final Platform platform;
    private final long serverStartMs;
    private final WorkerManager workerManager;
    private final JsonRestServer restServer;
    private final Time time;

    public Agent(Platform platform, Scheduler scheduler, JsonRestServer restServer, AgentRestResource resource) {
        this.platform = platform;
        this.time = scheduler.time();
        this.serverStartMs = this.time.milliseconds();
        this.workerManager = new WorkerManager(platform, scheduler);
        this.restServer = restServer;
        resource.setAgent(this);
    }

    public int port() {
        return this.restServer.port();
    }

    public void beginShutdown() throws Exception {
        this.restServer.beginShutdown();
        this.workerManager.beginShutdown();
    }

    public void waitForShutdown() throws Exception {
        this.restServer.waitForShutdown();
        this.workerManager.waitForShutdown();
    }

    public AgentStatusResponse status() throws Exception {
        return new AgentStatusResponse(this.serverStartMs, this.workerManager.workerStates());
    }

    public UptimeResponse uptime() {
        return new UptimeResponse(this.serverStartMs, this.time.milliseconds());
    }

    public void createWorker(CreateWorkerRequest req) throws Throwable {
        this.workerManager.createWorker(req.workerId(), req.taskId(), req.spec());
    }

    public void stopWorker(StopWorkerRequest req) throws Throwable {
        this.workerManager.stopWorker(req.workerId(), false);
    }

    public void destroyWorker(DestroyWorkerRequest req) throws Throwable {
        this.workerManager.stopWorker(req.workerId(), true);
    }

    TaskSpec rebaseTaskSpecTime(TaskSpec spec) throws Exception {
        ObjectNode node = (ObjectNode)JsonUtil.JSON_SERDE.valueToTree(spec);
        node.set("startMs", new LongNode(Math.max(this.time.milliseconds(), spec.startMs())));
        return JsonUtil.JSON_SERDE.treeToValue(node, TaskSpec.class);
    }

    boolean exec(TaskSpec spec, PrintStream out) throws Exception {
        TaskController controller = null;
        try {
            controller = spec.newController(EXEC_TASK_ID);
        }
        catch (Exception e2) {
            out.println("Unable to create the task controller.");
            e2.printStackTrace(out);
            return false;
        }
        Set<String> nodes = controller.targetNodes(this.platform.topology());
        if (!nodes.contains(this.platform.curNode().name())) {
            out.println("This task is not configured to run on this node.  It runs on node(s): " + Utils.join(nodes, ", ") + ", whereas this node is " + this.platform.curNode().name());
            return false;
        }
        KafkaFuture<String> future = null;
        try {
            future = this.workerManager.createWorker(1L, EXEC_TASK_ID, spec);
        }
        catch (Throwable e3) {
            out.println("createWorker failed");
            e3.printStackTrace(out);
            return false;
        }
        out.println("Waiting for completion of task:" + JsonUtil.toPrettyJsonString(spec));
        String error = future.get();
        if (error == null || error.isEmpty()) {
            out.println("Task succeeded with status " + JsonUtil.toPrettyJsonString(this.workerManager.workerStates().get(1L).status()));
            return true;
        }
        out.println("Task failed with status " + JsonUtil.toPrettyJsonString(this.workerManager.workerStates().get(1L).status()) + " and error " + error);
        return false;
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-agent").defaultHelp(true).description("The Trogdor fault injection agent");
        parser.addArgument(new String[]{"--agent.config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("config").metavar(new String[]{"CONFIG"}).help("The configuration file to use.");
        parser.addArgument(new String[]{"--node-name", "-n"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("node_name").metavar(new String[]{"NODE_NAME"}).help("The name of this node.");
        parser.addArgument(new String[]{"--exec", "-e"}).action((ArgumentAction)Arguments.store()).type(String.class).dest("task_spec").metavar(new String[]{"TASK_SPEC"}).help("Execute a single task spec and then exit.  The argument is the task spec to load when starting up, or a path to it.");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e2) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit(0);
            }
            parser.handleError(e2);
            Exit.exit(1);
        }
        String configPath = res.getString("config");
        String nodeName = res.getString("node_name");
        String taskSpec = res.getString("task_spec");
        Platform platform = Platform.Config.parse(nodeName, configPath);
        JsonRestServer restServer = new JsonRestServer(Node.Util.getTrogdorAgentPort(platform.curNode()));
        AgentRestResource resource = new AgentRestResource();
        log.info("Starting agent process.");
        Agent agent = new Agent(platform, Scheduler.SYSTEM, restServer, resource);
        restServer.start(resource);
        Exit.addShutdownHook("agent-shutdown-hook", () -> {
            log.warn("Running agent shutdown hook.");
            try {
                agent.beginShutdown();
                agent.waitForShutdown();
            }
            catch (Exception e2) {
                log.error("Got exception while running agent shutdown hook.", (Throwable)e2);
            }
        });
        if (taskSpec != null) {
            TaskSpec spec = null;
            try {
                spec = JsonUtil.objectFromCommandLineArgument(taskSpec, TaskSpec.class);
            }
            catch (Exception e3) {
                System.out.println("Unable to parse the supplied task spec.");
                e3.printStackTrace();
                Exit.exit(1);
            }
            TaskSpec effectiveSpec = agent.rebaseTaskSpecTime(spec);
            Exit.exit(agent.exec(effectiveSpec, System.out) ? 0 : 1);
        }
        agent.waitForShutdown();
    }
}

