/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.coordinator;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Exit;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Scheduler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Node;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Platform;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.coordinator.CoordinatorRestResource;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.coordinator.TaskManager;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.CoordinatorStatusResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.CreateTaskRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.DestroyTaskRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.JsonRestServer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.StopTaskRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.TaskRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.TaskState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.TasksRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.TasksResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.UptimeResponse;
import java.util.concurrent.ThreadLocalRandom;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Coordinator {
    private static final Logger log = LoggerFactory.getLogger(Coordinator.class);
    public static final int DEFAULT_PORT = 8889;
    private final long startTimeMs;
    private final TaskManager taskManager;
    private final JsonRestServer restServer;
    private final Time time;

    public Coordinator(Platform platform, Scheduler scheduler, JsonRestServer restServer, CoordinatorRestResource resource, long firstWorkerId) {
        this.time = scheduler.time();
        this.startTimeMs = this.time.milliseconds();
        this.taskManager = new TaskManager(platform, scheduler, firstWorkerId);
        this.restServer = restServer;
        resource.setCoordinator(this);
    }

    public int port() {
        return this.restServer.port();
    }

    public CoordinatorStatusResponse status() throws Exception {
        return new CoordinatorStatusResponse(this.startTimeMs);
    }

    public UptimeResponse uptime() {
        return new UptimeResponse(this.startTimeMs, this.time.milliseconds());
    }

    public void createTask(CreateTaskRequest request) throws Throwable {
        this.taskManager.createTask(request.id(), request.spec());
    }

    public void stopTask(StopTaskRequest request) throws Throwable {
        this.taskManager.stopTask(request.id());
    }

    public void destroyTask(DestroyTaskRequest request) throws Throwable {
        this.taskManager.destroyTask(request.id());
    }

    public TasksResponse tasks(TasksRequest request) throws Exception {
        return this.taskManager.tasks(request);
    }

    public TaskState task(TaskRequest request) throws Exception {
        return this.taskManager.task(request);
    }

    public void beginShutdown(boolean stopAgents) throws Exception {
        this.restServer.beginShutdown();
        this.taskManager.beginShutdown(stopAgents);
    }

    public void waitForShutdown() throws Exception {
        this.restServer.waitForShutdown();
        this.taskManager.waitForShutdown();
    }

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"trogdor-coordinator").defaultHelp(true).description("The Trogdor fault injection coordinator");
        parser.addArgument(new String[]{"--coordinator.config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("config").metavar(new String[]{"CONFIG"}).help("The configuration file to use.");
        parser.addArgument(new String[]{"--node-name", "-n"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("node_name").metavar(new String[]{"NODE_NAME"}).help("The name of this node.");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e2) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit(0);
            }
            parser.handleError(e2);
            Exit.exit(1);
        }
        String configPath = res.getString("config");
        String nodeName = res.getString("node_name");
        Platform platform = Platform.Config.parse(nodeName, configPath);
        JsonRestServer restServer = new JsonRestServer(Node.Util.getTrogdorCoordinatorPort(platform.curNode()));
        CoordinatorRestResource resource = new CoordinatorRestResource();
        log.info("Starting coordinator process.");
        Coordinator coordinator = new Coordinator(platform, Scheduler.SYSTEM, restServer, resource, ThreadLocalRandom.current().nextLong(0L, 0x3FFFFFFFFFFFFFFFL));
        restServer.start(resource);
        Exit.addShutdownHook("coordinator-shutdown-hook", () -> {
            log.warn("Running coordinator shutdown hook.");
            try {
                coordinator.beginShutdown(false);
                coordinator.waitForShutdown();
            }
            catch (Exception e2) {
                log.error("Got exception while running coordinator shutdown hook.", (Throwable)e2);
            }
        });
        coordinator.waitForShutdown();
    }
}

