/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleChangeEventSourceFactory;
import io.debezium.connector.oracle.OracleChangeEventSourceMetricsFactory;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleErrorHandler;
import io.debezium.connector.oracle.OracleEventMetadataProvider;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.OracleTopicSelector;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnectorTask
extends BaseSourceTask<OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnectorTask.class);
    private static final String CONTEXT_NAME = "oracle-connector-task";
    private volatile OracleTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile OracleConnection jdbcConnection;
    private volatile ErrorHandler errorHandler;
    private volatile OracleDatabaseSchema schema;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public ChangeEventSourceCoordinator<OracleOffsetContext> start(Configuration config) {
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        TopicSelector<TableId> topicSelector = OracleTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        Configuration jdbcConfig = connectorConfig.getJdbcConfig();
        this.jdbcConnection = new OracleConnection(jdbcConfig, () -> this.getClass().getClassLoader());
        OracleValueConverters valueConverters = new OracleValueConverters(connectorConfig, this.jdbcConnection);
        StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity = connectorConfig.getAdapter().getTableNameCaseSensitivity(this.jdbcConnection);
        this.schema = new OracleDatabaseSchema(connectorConfig, valueConverters, schemaNameAdjuster, topicSelector, tableNameCaseSensitivity);
        this.schema.initializeStorage();
        OracleOffsetContext previousOffset = this.getPreviousOffset(connectorConfig.getAdapter().getOffsetContextLoader());
        if (previousOffset != null) {
            this.schema.recover(previousOffset);
        }
        this.taskContext = new OracleTaskContext(connectorConfig, this.schema);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new OracleErrorHandler(connectorConfig.getLogicalName(), this.queue);
        OracleEventMetadataProvider metadataProvider = new OracleEventMetadataProvider();
        EventDispatcher<TableId> dispatcher = new EventDispatcher<TableId>(connectorConfig, topicSelector, this.schema, this.queue, connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, metadataProvider, schemaNameAdjuster);
        OracleStreamingChangeEventSourceMetrics streamingMetrics = new OracleStreamingChangeEventSourceMetrics(this.taskContext, this.queue, metadataProvider, connectorConfig);
        ChangeEventSourceCoordinator<OracleOffsetContext> coordinator = new ChangeEventSourceCoordinator<OracleOffsetContext>(previousOffset, this.errorHandler, OracleConnector.class, connectorConfig, new OracleChangeEventSourceFactory(connectorConfig, this.jdbcConnection, this.errorHandler, dispatcher, clock, this.schema, jdbcConfig, this.taskContext, streamingMetrics), new OracleChangeEventSourceMetricsFactory(streamingMetrics), dispatcher, this.schema);
        coordinator.start(this.taskContext, this.queue, metadataProvider);
        return coordinator;
    }

    @Override
    public List<SourceRecord> doPoll() throws InterruptedException {
        List<DataChangeEvent> records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    @Override
    public void doStop() {
        try {
            if (this.jdbcConnection != null) {
                this.jdbcConnection.close();
            }
        }
        catch (SQLException e2) {
            LOGGER.error("Exception while closing JDBC connection", (Throwable)e2);
        }
        this.schema.close();
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return OracleConnectorConfig.ALL_FIELDS;
    }
}

