/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    private final OracleDdlParser ddlParser;
    private final OracleValueConverters valueConverters;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, OracleValueConverters valueConverters, SchemaNameAdjuster schemaNameAdjuster, TopicSelector<TableId> topicSelector, StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity) {
        super(connectorConfig, topicSelector, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder(valueConverters, schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getSanitizeFieldNames()), StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)tableNameCaseSensitivity), connectorConfig.getKeyMapper());
        this.ddlParser = new OracleDdlParser(valueConverters, connectorConfig.getTableFilters().dataCollectionFilter());
        this.valueConverters = valueConverters;
    }

    public Tables getTables() {
        return this.tables();
    }

    public OracleValueConverters getValueConverters() {
        return this.valueConverters;
    }

    @Override
    public OracleDdlParser getDdlParser() {
        return this.ddlParser;
    }

    @Override
    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
        switch (schemaChange.getType()) {
            case CREATE: 
            case ALTER: {
                schemaChange.getTableChanges().forEach(x2 -> {
                    this.buildAndRegisterSchema(x2.getTable());
                    this.tables().overwriteTable(x2.getTable());
                });
                break;
            }
            case DROP: {
                schemaChange.getTableChanges().forEach(x2 -> this.removeSchema(x2.getId()));
                break;
            }
        }
        if (schemaChange.getTables().stream().map(Table::id).anyMatch(this.getTableFilter()::isIncluded)) {
            LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)schemaChange.getDatabase(), (Object)schemaChange.getDdl());
            this.record(schemaChange, schemaChange.getTableChanges());
        }
    }
}

