/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.pipeline.ErrorHandler;
import java.io.IOException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.List;

public class OracleErrorHandler
extends ErrorHandler {
    private static final List<String> retryOracleErrors = new ArrayList<String>();
    private static final List<String> retryOracleMessageContainsTexts = new ArrayList<String>();

    public OracleErrorHandler(String logicalName, ChangeEventQueue<?> queue) {
        super(OracleConnector.class, logicalName, queue);
    }

    @Override
    protected boolean isRetriable(Throwable throwable) {
        while (throwable != null) {
            Throwable cause;
            if (throwable instanceof SQLRecoverableException) {
                return true;
            }
            String message = throwable.getMessage();
            if (message != null && message.length() > 0) {
                for (String errorCode : retryOracleErrors) {
                    if (!message.startsWith(errorCode)) continue;
                    return true;
                }
                for (String messageText : retryOracleMessageContainsTexts) {
                    if (!message.toUpperCase().contains(messageText.toUpperCase())) continue;
                    return true;
                }
            }
            if (throwable.getCause() != null && (cause = throwable.getCause()) instanceof IOException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    static {
        retryOracleErrors.add("ORA-03135");
        retryOracleErrors.add("ORA-12543");
        retryOracleErrors.add("ORA-00604");
        retryOracleErrors.add("ORA-01089");
        retryOracleErrors.add("ORA-01333");
        retryOracleErrors.add("ORA-01284");
        retryOracleErrors.add("ORA-26653");
        retryOracleErrors.add("ORA-01291");
        retryOracleErrors.add("ORA-01327");
        retryOracleErrors.add("ORA-04030");
        retryOracleMessageContainsTexts.add("No more data to read from socket");
    }
}

