/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.util.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class LogMinerQueryBuilder {
    private static final String LOGMNR_CONTENTS_VIEW = "V$LOGMNR_CONTENTS";

    public static String build(OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema, String userName) {
        String tablePredicate;
        String schemaPredicate;
        StringBuilder query = new StringBuilder(1024);
        query.append("SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, ");
        query.append("USERNAME, ROW_ID, ROLLBACK, RS_ID ");
        query.append("FROM ").append(LOGMNR_CONTENTS_VIEW).append(" ");
        query.append("WHERE SCN > ? AND SCN <= ? ");
        String pdbName = connectorConfig.getPdbName();
        if (!Strings.isNullOrEmpty(pdbName)) {
            query.append("AND ").append("SRC_CON_NAME = '").append(pdbName.toUpperCase()).append("' ");
        }
        query.append("AND (");
        query.append("(OPERATION_CODE IN (6,7,34,36)");
        if (!schema.storeOnlyCapturedTables()) {
            query.append(" OR ").append(LogMinerQueryBuilder.buildDdlPredicate(userName)).append(" ");
            if (connectorConfig.isLobEnabled()) {
                query.append(") OR (OPERATION_CODE IN (1,2,3,9,10,11,29) ");
            } else {
                query.append(") OR (OPERATION_CODE IN (1,2,3) ");
            }
        } else {
            if (connectorConfig.isLobEnabled()) {
                query.append(") OR ((OPERATION_CODE IN (1,2,3,9,10,11,29) ");
            } else {
                query.append(") OR ((OPERATION_CODE IN (1,2,3) ");
            }
            query.append("OR ").append(LogMinerQueryBuilder.buildDdlPredicate(userName)).append(") ");
        }
        query.append("AND TABLE_NAME != '").append("LOG_MINING_FLUSH").append("' ");
        if (!OracleConnectorConfig.EXCLUDED_SCHEMAS.isEmpty()) {
            query.append("AND SEG_OWNER NOT IN (");
            Iterator<String> i2 = OracleConnectorConfig.EXCLUDED_SCHEMAS.iterator();
            while (i2.hasNext()) {
                String excludedSchema = i2.next();
                query.append("'").append(excludedSchema.toUpperCase()).append("'");
                if (!i2.hasNext()) continue;
                query.append(",");
            }
            query.append(") ");
        }
        if (!Strings.isNullOrEmpty(schemaPredicate = LogMinerQueryBuilder.buildSchemaPredicate(connectorConfig))) {
            query.append("AND ").append(schemaPredicate).append(" ");
        }
        if (!Strings.isNullOrEmpty(tablePredicate = LogMinerQueryBuilder.buildTablePredicate(connectorConfig))) {
            query.append("AND ").append(tablePredicate).append(" ");
        }
        query.append("))");
        return query.toString();
    }

    private static String buildDdlPredicate(String userName) {
        StringBuilder predicate = new StringBuilder(256);
        predicate.append("(OPERATION_CODE = 5 ");
        predicate.append("AND USERNAME NOT IN ('SYS','SYSTEM','").append(userName.toUpperCase()).append("') ");
        predicate.append("AND INFO NOT LIKE 'INTERNAL DDL%' ");
        predicate.append("AND (TABLE_NAME IS NULL OR TABLE_NAME NOT LIKE 'ORA_TEMP_%'))");
        return predicate.toString();
    }

    private static String buildSchemaPredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        if (Strings.isNullOrEmpty(connectorConfig.schemaIncludeList())) {
            if (!Strings.isNullOrEmpty(connectorConfig.schemaExcludeList())) {
                List<Pattern> patterns = Strings.listOfRegex(connectorConfig.schemaExcludeList(), 0);
                predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER", true)).append(")");
            }
        } else {
            List<Pattern> patterns = Strings.listOfRegex(connectorConfig.schemaIncludeList(), 0);
            predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER", false)).append(")");
        }
        return predicate.toString();
    }

    private static String buildTablePredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        if (Strings.isNullOrEmpty(connectorConfig.tableIncludeList())) {
            if (!Strings.isNullOrEmpty(connectorConfig.tableExcludeList())) {
                List<Pattern> patterns = Strings.listOfRegex(connectorConfig.tableExcludeList(), 0);
                predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER || '.' || TABLE_NAME", true)).append(")");
            }
        } else {
            List<Pattern> patterns = Strings.listOfRegex(connectorConfig.tableIncludeList(), 0);
            predicate.append("(").append(LogMinerQueryBuilder.listOfPatternsToSql(patterns, "SEG_OWNER || '.' || TABLE_NAME", false)).append(")");
        }
        return predicate.toString();
    }

    private static String listOfPatternsToSql(List<Pattern> patterns, String columnName, boolean inclusion) {
        StringBuilder predicate = new StringBuilder();
        Iterator<Pattern> i2 = patterns.iterator();
        while (i2.hasNext()) {
            Pattern pattern = i2.next();
            if (inclusion) {
                predicate.append("NOT ");
            }
            String text = LogMinerQueryBuilder.resolveRegExpLikePattern(pattern);
            predicate.append("REGEXP_LIKE(").append(columnName).append(",'").append(text).append("','i')");
            if (!i2.hasNext()) continue;
            predicate.append(inclusion ? " AND " : " OR ");
        }
        return predicate.toString();
    }

    private static String resolveRegExpLikePattern(Pattern pattern) {
        String text = pattern.pattern();
        if (!text.startsWith("^")) {
            text = "^" + text;
        }
        if (!text.endsWith("$")) {
            text = text + "$";
        }
        return text;
    }
}

