/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.AbstractStreamingAdapter;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.XStreamOracleOffsetContextLoader;
import io.debezium.connector.oracle.xstream.XstreamStreamingChangeEventSource;
import io.debezium.document.Document;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Clock;

public class XStreamAdapter
extends AbstractStreamingAdapter {
    private static final String TYPE = "xstream";

    public XStreamAdapter(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            @Override
            public boolean isPositionAtOrBefore(Document recorded, Document desired) {
                Scn desiredScn;
                LcrPosition recordedPosition = LcrPosition.valueOf(recorded.getString("lcr_position"));
                LcrPosition desiredPosition = LcrPosition.valueOf(desired.getString("lcr_position"));
                Scn recordedScn = recordedPosition != null ? recordedPosition.getScn() : XStreamAdapter.this.resolveScn(recorded);
                Scn scn = desiredScn = desiredPosition != null ? desiredPosition.getScn() : XStreamAdapter.this.resolveScn(desired);
                if (recordedPosition != null && desiredPosition != null) {
                    return recordedPosition.compareTo(desiredPosition) < 1;
                }
                return recordedScn.compareTo(desiredScn) < 1;
            }
        };
    }

    @Override
    public OffsetContext.Loader<OracleOffsetContext> getOffsetContextLoader() {
        return new XStreamOracleOffsetContextLoader(this.connectorConfig);
    }

    @Override
    public StreamingChangeEventSource<OracleOffsetContext> getSource(OracleConnection connection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        return new XstreamStreamingChangeEventSource(this.connectorConfig, connection, dispatcher, errorHandler, clock, schema, streamingMetrics);
    }

    @Override
    public StreamingAdapter.TableNameCaseSensitivity getTableNameCaseSensitivity(OracleConnection connection) {
        if (connection.getOracleVersion().getMajor() == 11) {
            return StreamingAdapter.TableNameCaseSensitivity.SENSITIVE;
        }
        return super.getTableNameCaseSensitivity(connection);
    }
}

