/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.Immutable;
import io.debezium.function.Predicates;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Selectors;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Immutable
public class Key {
    private final Table table;
    private final KeyMapper keyMapper;

    private Key(Table table, KeyMapper keyMapper) {
        this.table = table;
        this.keyMapper = keyMapper;
    }

    public List<Column> keyColumns() {
        return this.keyMapper.getKeyKolumns(this.table);
    }

    public static class CustomKeyMapper {
        public static final Pattern MSG_KEY_COLUMNS_PATTERN = Pattern.compile("^\\s*([^\\s:]+):([^:\\s]+)\\s*$");
        public static final Pattern PATTERN_SPLIT = Pattern.compile(";");
        private static final Pattern TABLE_SPLIT = Pattern.compile(":");
        private static final Pattern COLUMN_SPLIT = Pattern.compile(",");

        public static KeyMapper getInstance(String fullyQualifiedColumnNames, Selectors.TableIdToStringMapper tableIdMapper) {
            if (fullyQualifiedColumnNames == null) {
                return null;
            }
            String regexes = Arrays.stream(PATTERN_SPLIT.split(fullyQualifiedColumnNames)).map(s2 -> TABLE_SPLIT.split((CharSequence)s2)).collect(ArrayList::new, (m2, p2) -> Arrays.asList(COLUMN_SPLIT.split(p2[1])).forEach(c2 -> m2.add(p2[0] + "." + c2)), ArrayList::addAll).stream().collect(Collectors.joining(","));
            Predicate<ColumnId> delegate = Predicates.includes(regexes, ColumnId::toString);
            return table -> {
                List candidates = table.columns().stream().filter(c2 -> {
                    TableId tableId = table.id();
                    if (tableIdMapper == null) {
                        return delegate.test(new ColumnId(tableId.catalog(), tableId.schema(), tableId.table(), c2.name()));
                    }
                    return delegate.test(new ColumnId(tableId.catalog(), tableId.schema(), tableId.table(), c2.name())) || delegate.test(new ColumnId(new TableId(tableId.catalog(), tableId.schema(), tableId.table(), tableIdMapper), c2.name()));
                }).collect(Collectors.toList());
                return candidates.isEmpty() ? table.primaryKeyColumns() : candidates;
            };
        }
    }

    private static class IdentityKeyMapper {
        private IdentityKeyMapper() {
        }

        public static KeyMapper getInstance() {
            return table -> table.primaryKeyColumns();
        }
    }

    @FunctionalInterface
    public static interface KeyMapper {
        public List<Column> getKeyKolumns(Table var1);
    }

    public static class Builder {
        private final Table table;
        private KeyMapper keyMapper = IdentityKeyMapper.getInstance();

        public Builder(Table table) {
            this.table = table;
        }

        public Builder customKeyMapper(KeyMapper customKeyMapper) {
            if (customKeyMapper != null) {
                this.keyMapper = customKeyMapper;
            }
            return this;
        }

        public Key build() {
            return new Key(this.table, this.keyMapper);
        }
    }
}

