/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.relational.Column;
import io.debezium.util.BoundedConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldNameSelector {
    public static FieldNamer<Column> defaultSelector(boolean sanitizeFieldNames) {
        return sanitizeFieldNames ? new FieldNameCache<Column>(new FieldNameSanitizer<Column>(Column::name)) : Column::name;
    }

    public static FieldNamer<String> defaultNonRelationalSelector(boolean sanitizeFieldNames) {
        return sanitizeFieldNames ? new FieldNameCache<String>(new FieldNameSanitizer<String>(x2 -> x2)) : x2 -> x2;
    }

    private static class FieldNameCache<T>
    implements FieldNamer<T> {
        private final BoundedConcurrentHashMap<T, String> fieldNames = new BoundedConcurrentHashMap(10000, 10, BoundedConcurrentHashMap.Eviction.LRU);
        private final FieldNamer<T> delegate;

        public FieldNameCache(FieldNamer<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String fieldNameFor(T column) {
            return this.fieldNames.computeIfAbsent(column, this.delegate::fieldNameFor);
        }
    }

    private static class FieldNameSanitizer<T>
    implements FieldNamer<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(FieldNameSanitizer.class);
        private static final String REPLACEMENT_CHAR = "_";
        private static final String NUMBER_PREFIX = "_";
        private final FieldNamer<T> delegate;

        public FieldNameSanitizer(FieldNamer<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String fieldNameFor(T column) {
            String fieldName = this.delegate.fieldNameFor(column);
            return this.sanitizeColumnName(fieldName);
        }

        private String sanitizeColumnName(String columnName) {
            boolean changed = false;
            StringBuilder sanitizedNameBuilder = new StringBuilder(columnName.length() + 1);
            for (int i2 = 0; i2 < columnName.length(); ++i2) {
                char c2 = columnName.charAt(i2);
                if (i2 == 0 && Character.isDigit(c2)) {
                    sanitizedNameBuilder.append("_");
                    sanitizedNameBuilder.append(c2);
                    changed = true;
                    continue;
                }
                if (!(c2 == '_' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9')) {
                    sanitizedNameBuilder.append("_");
                    changed = true;
                    continue;
                }
                sanitizedNameBuilder.append(c2);
            }
            String sanitizedName = sanitizedNameBuilder.toString();
            if (changed) {
                LOGGER.warn("Field '{}' name potentially not safe for serialization, replaced with '{}'", (Object)columnName, (Object)sanitizedName);
            }
            return sanitizedName;
        }
    }

    @FunctionalInterface
    public static interface FieldNamer<T> {
        public String fieldNameFor(T var1);
    }
}

