/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.BoundedConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicSelector<I extends DataCollectionId> {
    private final String prefix;
    private final String heartbeatPrefix;
    private final String delimiter;
    private final DataCollectionTopicNamer<I> dataCollectionTopicNamer;

    private TopicSelector(String prefix, String heartbeatPrefix, String delimiter, DataCollectionTopicNamer<I> dataCollectionTopicNamer) {
        this.prefix = prefix;
        this.heartbeatPrefix = heartbeatPrefix;
        this.delimiter = delimiter;
        this.dataCollectionTopicNamer = new TopicNameCache<I>(new TopicNameSanitizer<I>(dataCollectionTopicNamer));
    }

    public static <I extends DataCollectionId> TopicSelector<I> defaultSelector(String prefix, String heartbeatPrefix, String delimiter, DataCollectionTopicNamer<I> dataCollectionTopicNamer) {
        return new TopicSelector<I>(prefix, heartbeatPrefix, delimiter, dataCollectionTopicNamer);
    }

    public static <I extends DataCollectionId> TopicSelector<I> defaultSelector(CommonConnectorConfig connectorConfig, DataCollectionTopicNamer<I> dataCollectionTopicNamer) {
        String prefix = connectorConfig.getLogicalName();
        String heartbeatTopicsPrefix = connectorConfig.getHeartbeatTopicsPrefix();
        String delimiter = ".";
        return TopicSelector.defaultSelector(prefix, heartbeatTopicsPrefix, delimiter, dataCollectionTopicNamer);
    }

    public String topicNameFor(I id) {
        return this.dataCollectionTopicNamer.topicNameFor(id, this.prefix, this.delimiter);
    }

    public String getPrimaryTopic() {
        return this.prefix;
    }

    public String getHeartbeatTopic() {
        return String.join((CharSequence)this.delimiter, this.heartbeatPrefix, this.prefix);
    }

    @ThreadSafe
    private static class TopicNameCache<I extends DataCollectionId>
    implements DataCollectionTopicNamer<I> {
        private final BoundedConcurrentHashMap<I, String> topicNames = new BoundedConcurrentHashMap(10000, 10, BoundedConcurrentHashMap.Eviction.LRU);
        private final DataCollectionTopicNamer<I> delegate;

        public TopicNameCache(DataCollectionTopicNamer<I> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String topicNameFor(I id, String prefix, String delimiter) {
            return this.topicNames.computeIfAbsent(id, i2 -> this.delegate.topicNameFor((DataCollectionId)i2, prefix, delimiter));
        }
    }

    private static class TopicNameSanitizer<I extends DataCollectionId>
    implements DataCollectionTopicNamer<I> {
        private static final Logger LOGGER = LoggerFactory.getLogger(TopicNameSanitizer.class);
        private static final String REPLACEMENT_CHAR = "_";
        private final DataCollectionTopicNamer<I> delegate;

        public TopicNameSanitizer(DataCollectionTopicNamer<I> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String topicNameFor(I id, String prefix, String delimiter) {
            String topicName = this.delegate.topicNameFor(id, prefix, delimiter);
            StringBuilder sanitizedNameBuilder = new StringBuilder(topicName.length());
            boolean changed = false;
            for (int i2 = 0; i2 < topicName.length(); ++i2) {
                char c2 = topicName.charAt(i2);
                if (this.isValidTopicNameCharacter(c2)) {
                    sanitizedNameBuilder.append(c2);
                    continue;
                }
                sanitizedNameBuilder.append(REPLACEMENT_CHAR);
                changed = true;
            }
            if (changed) {
                String sanitizedName = sanitizedNameBuilder.toString();
                LOGGER.warn("Topic '{}' name isn't a valid topic name, replacing it with '{}'.", (Object)topicName, (Object)sanitizedName);
                return sanitizedName;
            }
            return topicName;
        }

        private boolean isValidTopicNameCharacter(char c2) {
            return c2 == '.' || c2 == '_' || c2 == '-' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9';
        }
    }

    @FunctionalInterface
    public static interface DataCollectionTopicNamer<I extends DataCollectionId> {
        public String topicNameFor(I var1, String var2, String var3);
    }
}

