/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.text;

import io.debezium.text.ParsingException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;

public class MultipleParsingExceptions
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Collection<ParsingException> errors;

    public MultipleParsingExceptions(Collection<ParsingException> errors) {
        this("Multiple parsing errors", errors);
    }

    public MultipleParsingExceptions(String message, Collection<ParsingException> errors) {
        super(message);
        this.errors = Collections.unmodifiableCollection(errors);
    }

    public Collection<ParsingException> getErrors() {
        return this.errors;
    }

    public void forEachError(Consumer<ParsingException> action) {
        this.errors.forEach(action);
    }

    @Override
    public void printStackTrace() {
        this.forEachError(Throwable::printStackTrace);
    }

    @Override
    public void printStackTrace(PrintStream s2) {
        this.forEachError(e2 -> e2.printStackTrace(s2));
    }

    @Override
    public void printStackTrace(PrintWriter s2) {
        this.forEachError(e2 -> e2.printStackTrace(s2));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getMessage());
        this.forEachError(e2 -> sb.append(System.lineSeparator()).append(e2.toString()));
        return sb.toString();
    }
}

