/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class ASN1BitString
implements ASN1TaggedObject {
    private ASN1Header a;
    private byte[] b;
    private int c;

    public ASN1BitString() {
        this(new byte[0], 0);
    }

    public ASN1BitString(byte[] byArray) {
        this.a(byArray, 0);
    }

    public ASN1BitString(byte[] byArray, int n2) {
        this.a(byArray, n2);
    }

    public ASN1BitString(int n2) {
        int n3 = n2 == 0 ? 0 : (n2 - 1) / 8 + 1;
        this.a(new byte[n3], 8 * n3 - n2);
    }

    public ASN1BitString(BigInteger bigInteger) {
        this(bigInteger.bitLength());
        int n2 = this.bitLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!bigInteger.testBit(i2)) continue;
            this.setBit(i2);
        }
    }

    public ASN1BitString(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void a(byte[] byArray, int n2) {
        if (byArray.length == 0) {
            n2 = 0;
        }
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException();
        }
        this.b = byArray;
        this.c = n2;
        this.a = new ASN1Header(3, 0, 0, byArray.length + 1);
    }

    @Override
    public ASN1Header getHeader() {
        return this.a;
    }

    public byte[] getValue() {
        return this.b;
    }

    public int intValue() {
        int n2;
        if (this.b.length == 0) {
            return 0;
        }
        int n3 = 0;
        for (n2 = 0; n2 < 3; ++n2) {
            if (n2 == this.b.length - 1) {
                n3 += (this.b[n2] & 0xFF & 255 << this.c) << 8 * (3 - n2);
                break;
            }
            n3 += (this.b[n2] & 0xFF) << 8 * (3 - n2);
        }
        n2 = 0;
        int n4 = this.bitLength();
        for (int i2 = 0; i2 < n4; ++i2) {
            n2 += (n3 & Integer.MIN_VALUE) != 0 ? 1 << i2 : 0;
            n3 <<= 1;
        }
        return n2;
    }

    public int getUnused() {
        return this.c;
    }

    public int bitLength() {
        return 8 * this.b.length - this.c;
    }

    public boolean testBit(int n2) {
        if (n2 < 0 || n2 >= 8 * this.b.length - this.c) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        return (this.b[n2 / 8] & 1 << 7 - n2 % 8) != 0;
    }

    public void setBit(int n2) {
        if (n2 < 0 || n2 >= 8 * this.b.length - this.c) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        int n3 = n2 / 8;
        this.b[n3] = (byte)(this.b[n3] | 1 << 7 - n2 % 8);
    }

    public void clearBit(int n2) {
        if (n2 < 0 || n2 >= 8 * this.b.length - this.c) {
            throw new ArithmeticException("Bit index out of bounds");
        }
        int n3 = n2 / 8;
        this.b[n3] = (byte)(this.b[n3] & ~(1 << 7 - n2 % 8));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BIT STRING ");
        stringBuffer.append(Utils.toHexString(this.b));
        if (this.c != 0) {
            stringBuffer.append("(" + this.c + " unused)");
        }
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(3);
        if (aSN1Header.getEncodingMethod() == 0) {
            if (aSN1Header.getBodyLength() == 0) {
                throw new ASN1FormatException("Body is empty.");
            }
            this.c = Utils.inputByte(inputStream) & 7;
            this.a(Utils.inputBytes(inputStream, aSN1Header.getBodyLength() - 1), this.c);
        } else {
            int n2 = 0;
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
            while (aSN1ConstructedInputStream.hasMoreData()) {
                ASN1BitString aSN1BitString = new ASN1BitString(aSN1ConstructedInputStream);
                if (n2 != 0) {
                    throw new ASN1FormatException("Illegal encoding of bit-string.");
                }
                unsyncByteArrayOutputStream.write(aSN1BitString.getValue());
                n2 = aSN1BitString.getUnused();
            }
            aSN1ConstructedInputStream.terminate();
            this.a(unsyncByteArrayOutputStream.toByteArray(), n2);
        }
    }

    public static byte[] inputValue(InputStream inputStream) throws IOException {
        return new ASN1BitString(inputStream).getValue();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        outputStream.write(this.c);
        if (this.c == 0) {
            outputStream.write(this.b);
        } else {
            outputStream.write(this.b, 0, this.b.length - 1);
            outputStream.write(this.b[this.b.length - 1] & 255 << this.c & 0xFF);
        }
    }

    @Override
    public int length() {
        return this.a.totalLength();
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray) throws IOException {
        ASN1BitString.a(outputStream, byArray, 3, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n2) throws IOException {
        ASN1BitString.a(outputStream, byArray, n2, 128);
    }

    private static void a(OutputStream outputStream, byte[] byArray, int n2, int n3) throws IOException {
        outputStream.write(n3 + n2);
        ASN1Utils.outputLengthBytes(outputStream, byArray.length + 1);
        outputStream.write(0);
        outputStream.write(byArray);
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

