/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class ASN1Header
implements ASN1,
Streamable {
    private int a;
    private int b;
    private int c;
    private int d;

    public ASN1Header() {
    }

    public ASN1Header(int n2, int n3) {
        this(n2, n3, 2, -1);
    }

    public ASN1Header(int n2, int n3, int n4, int n5) {
        this.a = n2;
        this.b = n3;
        this.c = n4;
        this.d = n5;
    }

    public ASN1Header(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public int getTag() {
        return this.a;
    }

    public int getTagClass() {
        return this.b;
    }

    public int getEncodingMethod() {
        return this.c;
    }

    public int getBodyLength() {
        return this.d;
    }

    @Override
    public int length() {
        return this.a() + this.b();
    }

    int a() {
        return 1 + (this.a < 31 ? 0 : ASN1Utils.lengthBase128(this.a));
    }

    int b() {
        return 1 + (this.d < 128 ? 0 : ASN1Utils.lengthBase256(this.d));
    }

    public int totalLength() {
        return this.length() + this.d;
    }

    public String toString() {
        return this.tagClassToString(this.b) + " " + (this.b == 0 ? this.tagToString(this.a) : Integer.toString(this.a)) + " " + this.encodingMethodToString(this.c) + " length=" + (this.c == 2 ? "unknown" : Integer.toString(this.d));
    }

    public String tagClassToString(int n2) {
        String[] stringArray = new String[]{"universal", "application", "context-specific", "private"};
        return stringArray[n2 >> 6];
    }

    public String tagToString(int n2) {
        String[] stringArray = new String[]{"END OF CONTENTS", "BOOLEAN", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "ObjectDescriptor", "EXTERNAL", "REAL", "ENUMERATED", "11", "12", "13", "14", "15", "SEQUENCE", "SET", "NumericString", "PrintableString", "T61String", "VideotexString", "IA5String", "UTCTime", "GeneralizedTime", "GraphicString", "VisibleString", "GeneralString", "UniversalString", "29", "BMPString"};
        return n2 < stringArray.length ? stringArray[n2] : Integer.toString(n2);
    }

    public String encodingMethodToString(int n2) {
        String[] stringArray = new String[]{"primitive", "constructed", "constructed"};
        return stringArray[n2];
    }

    public void checkTagClass(int n2) throws ASN1FormatException {
        if (this.b != n2) {
            throw new ASN1FormatException("Got tag class " + this.tagClassToString(this.b) + " instead of " + this.tagClassToString(n2) + ".");
        }
    }

    public void checkTag(int n2) throws ASN1FormatException {
        if (this.a != n2) {
            throw new ASN1FormatException("Got tag " + this.a + " instead of " + n2 + ".");
        }
    }

    public void checkEncodingMethod(int n2) throws ASN1FormatException {
        if (this.c != n2) {
            throw new ASN1FormatException("Got encoding method " + this.encodingMethodToString(this.c) + " instead of " + this.encodingMethodToString(n2) + ".");
        }
    }

    void a(OutputStream outputStream) throws IOException {
        int n2 = this.a < 31 ? this.a : 31;
        int n3 = this.b | n2;
        if (this.c != 0) {
            n3 |= 0x20;
        }
        outputStream.write(n3);
        if (this.a >= 31) {
            ASN1Utils.outputBase128(this.a, outputStream);
        }
    }

    void b(OutputStream outputStream) throws IOException {
        if (this.c == 2) {
            outputStream.write(128);
        } else {
            ASN1Utils.outputLengthBytes(outputStream, this.d);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a(outputStream);
        this.b(outputStream);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(inputStream);
        this.b(inputStream);
    }

    void a(InputStream inputStream) throws IOException {
        int n2 = Utils.inputByte(inputStream) & 0xFF;
        this.b = n2 & 0xC0;
        this.c = (n2 & 0x20) == 0 ? 0 : 1;
        this.a = n2 & 0x1F;
        if (this.a == 31) {
            this.a = ASN1Utils.inputBase128(inputStream);
        }
    }

    void b(InputStream inputStream) throws IOException {
        int n2 = Utils.inputByte(inputStream) & 0xFF;
        if (n2 < 128) {
            this.d = n2;
        } else if (n2 == 128) {
            this.c = 2;
            this.d = -1;
        } else {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new ASN1FormatException("Length is too big: takes " + n3 + " bytes");
            }
            this.d = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.d <<= 8;
                this.d |= Utils.inputByte(inputStream) & 0xFF;
            }
        }
    }

    public void skipBody(InputStream inputStream) throws IOException {
        if (this.c != 2) {
            for (int i2 = 0; i2 < this.d; ++i2) {
                Utils.inputByte(inputStream);
            }
        } else {
            while (true) {
                ASN1Header aSN1Header = new ASN1Header();
                aSN1Header.input(inputStream);
                if (aSN1Header.b == 0 && aSN1Header.a == 0 && aSN1Header.d == 0) break;
                aSN1Header.skipBody(inputStream);
            }
        }
    }

    public byte[] readBody(InputStream inputStream) throws IOException {
        if (this.c != 2) {
            byte[] byArray = new byte[this.d];
            Utils.inputByteArray(byArray, inputStream);
            return byArray;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        while (true) {
            ASN1Header aSN1Header = new ASN1Header();
            aSN1Header.input(inputStream);
            if (aSN1Header.b == 0 && aSN1Header.a == 0 && aSN1Header.d == 0) break;
            aSN1Header.output(unsyncByteArrayOutputStream);
            unsyncByteArrayOutputStream.write(aSN1Header.readBody(inputStream));
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public byte[] headerAndBody(InputStream inputStream) throws IOException {
        byte[] byArray = this.readBody(inputStream);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length() + byArray.length);
        this.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(byArray);
        return fixedByteArrayOutputStream.toByteArray();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

