/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class RevokedCertificate
extends X509CRLEntry
implements ASN1Object,
Externalizable {
    private BigInteger serialNo;
    private Date revocationDate;
    private X509ExtensionSet extensions = null;
    private ASN1Sequence seq = null;

    public RevokedCertificate() {
    }

    public RevokedCertificate(BigInteger sn, Date rd) {
        this.serialNo = sn;
        this.revocationDate = rd;
    }

    public RevokedCertificate(BigInteger sn, Date rd, X509ExtensionSet exts) {
        this(sn, rd);
        if (exts != null && exts.size() > 0) {
            this.extensions = exts;
        }
    }

    public RevokedCertificate(BigInteger sn, Date rd, Vector<X509Extension> exts) {
        this(sn, rd, (List<X509Extension>)exts);
    }

    public RevokedCertificate(BigInteger sn, Date rd, List<X509Extension> exts) {
        this(sn, rd);
        if (exts != null && exts.size() > 0) {
            this.extensions = new X509ExtensionSet(exts);
        }
    }

    public RevokedCertificate(InputStream is) throws IOException {
        this.input(is);
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    @Override
    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void addExtension(X509Extension ext) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public Vector<X509Extension> getExtensions() {
        return this.extensions != null ? this.extensions.getExtensions() : null;
    }

    public ArrayList<X509Extension> getExtensionsAsList() {
        return this.extensions != null ? this.extensions.getExtensionsAsList() : null;
    }

    public Map<ASN1ObjectID, X509Extension> getExtensionsAsMap() {
        return this.extensions != null ? this.extensions.getExtensionsAsMap() : null;
    }

    public Enumeration<ASN1ObjectID> extensionTypes() {
        return this.extensions != null ? this.extensions.types() : null;
    }

    public X509Extension getExtension(ASN1ObjectID type) {
        return this.extensions != null ? this.extensions.getExtension(type) : null;
    }

    @Override
    public X500Principal getCertificateIssuer() {
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return Utils.toBytes(this);
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.getSerialNo();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.extensions.getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.extensions.getExtensionValue(oid);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    @Override
    public String toString() {
        String s2 = "serialNo = " + this.serialNo + ", revocationDate = " + this.revocationDate;
        if (this.extensions != null && this.extensions.size() > 0) {
            s2 = s2 + ", extensions = " + this.extensions;
        }
        return s2;
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.reset();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.serialNo = new ASN1Integer(sis).getValue();
        this.revocationDate = new ASN1Date(sis).getValue();
        this.extensions = sis.hasMoreData() ? new X509ExtensionSet(sis) : null;
        sis.terminate();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            s2.addElement(new ASN1Integer(this.getSerialNo()));
            s2.addElement(new ASN1Date(this.getRevocationDate()));
            if (this.extensions != null && this.extensions.size() > 0) {
                s2.addElement(this.extensions);
            }
            this.seq = s2;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

