/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.Entity;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500RDN;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class X500Name
extends Entity
implements ASN1Object {
    private ArrayList<X500RDN> rdnSequence = new ArrayList();
    private String countryName = null;
    private String stateName = null;
    private String localityName = null;
    private String organizationName = null;
    private String orgUnitName = null;
    private String email = null;
    private String serialNumber = null;
    private ASN1Sequence contents;
    private String stringContents;
    private int hash = -1;

    public X500Name() {
    }

    public X500Name(String str) {
        this.input(str);
    }

    public X500Name(InputStream is) throws IOException {
        this.input(is);
    }

    public static X500Name toX500Name(X500Principal p2) {
        try {
            return new X500Name(new UnsyncByteArrayInputStream(p2.getEncoded()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    X500Name(ASN1Sequence s2) throws IOException {
        this.input(s2);
    }

    public void addComponent(X500RDN rdn) {
        this.rdnSequence.add(rdn);
        for (ASN1ObjectID type : rdn.getValues().keySet()) {
            ASN1Object o2 = rdn.getValue(type);
            if (!(o2 instanceof ASN1String)) continue;
            ASN1String value = (ASN1String)o2;
            if (type.equals(PKIX.id_at_commonName)) {
                this.setName(value.getValue());
                continue;
            }
            if (type.equals(PKIX.id_at_countryName)) {
                this.countryName = value.getValue();
                continue;
            }
            if (type.equals(PKIX.id_at_localityName)) {
                this.localityName = value.getValue();
                continue;
            }
            if (type.equals(PKIX.id_at_stateOrProvinceName)) {
                this.stateName = value.getValue();
                continue;
            }
            if (type.equals(PKIX.id_at_organizationName)) {
                this.organizationName = value.getValue();
                continue;
            }
            if (type.equals(PKIX.id_at_organizationalUnitName)) {
                this.orgUnitName = value.getValue();
                continue;
            }
            if (type.equals(PKIX.emailAddress)) {
                this.email = value.getValue();
                continue;
            }
            if (!type.equals(PKIX.id_at_serialNumber)) continue;
            this.serialNumber = value.getValue();
        }
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    public void addComponent(ASN1ObjectID type, ASN1String value) {
        this.addComponent(new X500RDN(type, value));
    }

    public void addComponent(ASN1ObjectID type, String value) {
        this.addComponent(new X500RDN(type, value));
    }

    public void addComponent(String name, String value) {
        this.addComponent(X500RDN.getTypeID(name), value);
    }

    public ASN1Object getAttributeValue(String name) {
        return this.getAttributeValue(X500RDN.getTypeID(name));
    }

    public ASN1Object getAttributeValue(ASN1ObjectID type) {
        X500RDN rdn = this.getAttribute(type);
        return rdn != null ? rdn.getValue(type) : null;
    }

    public X500RDN getAttribute(String name) {
        ASN1ObjectID type = X500RDN.getTypeID(name);
        return type != null ? this.getAttribute(type) : null;
    }

    public X500RDN getAttribute(ASN1ObjectID type) {
        for (X500RDN rdn : this.getComponentsAsList()) {
            if (rdn == null || rdn.getValue(type) == null) continue;
            return rdn;
        }
        return null;
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.reset();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        while (sis.hasMoreData()) {
            this.addComponent(new X500RDN(sis));
        }
        sis.terminate();
    }

    void input(ASN1Sequence s2) throws IOException {
        this.input(Utils.toStream(s2));
    }

    public void input(String s2) throws InvalidFormatException {
        this.reset();
        boolean allWhitespace = true;
        int size = s2.length();
        for (int j2 = 0; j2 < size; ++j2) {
            if (X500RDN.isWhitespace(s2.charAt(j2))) continue;
            allWhitespace = false;
            break;
        }
        if (allWhitespace) {
            return;
        }
        StringBuffer r2 = new StringBuffer();
        boolean quoting = false;
        boolean foundRDN = false;
        int i2 = 0;
        ArrayList<X500RDN> comps = new ArrayList<X500RDN>();
        while (i2 < s2.length()) {
            try {
                char c2 = s2.charAt(i2);
                if (c2 == '\"') {
                    quoting = !quoting;
                    r2.append(c2);
                } else if (c2 == ',' || c2 == ';') {
                    if (quoting) {
                        r2.append(c2);
                    } else {
                        foundRDN = true;
                    }
                } else if (c2 == '\\') {
                    r2.append(c2);
                    c2 = s2.charAt(++i2);
                    r2.append(c2);
                } else {
                    r2.append(c2);
                }
                if (!foundRDN && ++i2 != s2.length()) continue;
                comps.add(new X500RDN(r2.toString()));
                r2 = new StringBuffer();
                quoting = false;
                foundRDN = false;
            }
            catch (IndexOutOfBoundsException e2) {
                throw new InvalidFormatException("Malformed DN string");
            }
        }
        X500RDN[] arrayComps = comps.toArray(new X500RDN[comps.size()]);
        for (int k2 = arrayComps.length - 1; k2 >= 0; --k2) {
            this.addComponent(arrayComps[k2]);
        }
    }

    private void reset() {
        this.rdnSequence.clear();
        this.countryName = null;
        this.stateName = null;
        this.localityName = null;
        this.organizationName = null;
        this.orgUnitName = null;
        this.email = null;
        this.serialNumber = null;
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            int size = this.size();
            for (int i2 = 0; i2 < size; ++i2) {
                s2.addElement(this.rdnSequence.get(i2));
            }
            this.contents = s2;
        }
        return this.contents;
    }

    public String toString() {
        if (this.stringContents == null) {
            StringBuffer s2 = new StringBuffer();
            for (int i2 = this.size() - 1; i2 >= 0; --i2) {
                X500RDN rdn = this.componentAt(i2);
                s2.append(rdn.toString());
                s2.append(',');
            }
            if (s2.length() > 0) {
                s2.setLength(s2.length() - 1);
            }
            this.stringContents = s2.toString();
        }
        return this.stringContents;
    }

    public Vector<X500RDN> getComponents() {
        ArrayList<X500RDN> l2 = this.getComponentsAsList();
        return l2 == null ? null : new VectorOverArrayList<X500RDN>(l2);
    }

    public ArrayList<X500RDN> getComponentsAsList() {
        if (this.rdnSequence == null) {
            this.rdnSequence = new ArrayList();
            if (this.countryName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_countryName, this.countryName));
            }
            if (this.stateName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_stateOrProvinceName, this.stateName));
            }
            if (this.localityName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_localityName, this.localityName));
            }
            if (this.organizationName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_organizationName, this.organizationName));
            }
            if (this.orgUnitName != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_organizationalUnitName, this.orgUnitName));
            }
            if (this.getName() != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_commonName, this.getName()));
            }
            if (this.email != null) {
                this.rdnSequence.add(new X500RDN(PKIX.emailAddress, this.email));
            }
            if (this.serialNumber != null) {
                this.rdnSequence.add(new X500RDN(PKIX.id_at_serialNumber, this.serialNumber));
            }
        }
        return this.rdnSequence;
    }

    public Enumeration<X500RDN> components() {
        return this.getComponents().elements();
    }

    public int size() {
        return this.getComponents().size();
    }

    public X500RDN componentAt(int i2) {
        return this.getComponents().elementAt(i2);
    }

    private void clearNewAPI() {
        this.rdnSequence = null;
        this.contents = null;
        this.stringContents = null;
        this.hash = -1;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String s2) {
        this.countryName = s2;
        this.clearNewAPI();
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String s2) {
        this.stateName = s2;
        this.clearNewAPI();
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String s2) {
        this.localityName = s2;
        this.clearNewAPI();
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String s2) {
        this.organizationName = s2;
        this.clearNewAPI();
    }

    public String getOrgUnitName() {
        return this.orgUnitName;
    }

    public void setOrgUnitName(String s2) {
        this.orgUnitName = s2;
        this.clearNewAPI();
    }

    public String getCommonName() {
        return this.getName();
    }

    public void setCommonName(String s2) {
        this.setName(s2);
        this.clearNewAPI();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String s2) {
        this.email = s2;
        this.clearNewAPI();
    }

    public void setAttr(String name, String value) {
        if (name.equalsIgnoreCase("C")) {
            this.setCountryName(value);
        } else if (name.equalsIgnoreCase("ST")) {
            this.setStateName(value);
        } else if (name.equalsIgnoreCase("L")) {
            this.setLocalityName(value);
        } else if (name.equalsIgnoreCase("O")) {
            this.setOrganizationName(value);
        } else if (name.equalsIgnoreCase("OU")) {
            this.setOrgUnitName(value);
        } else if (name.equalsIgnoreCase("CN")) {
            this.setName(value);
        } else if (name.equalsIgnoreCase("Email")) {
            this.setEmail(value);
        } else if (name.equalsIgnoreCase("EmailAddress")) {
            this.setEmail(value);
        } else {
            throw new IllegalArgumentException("Attribute '" + name + "' cannot be set using setAttr(String, String), only {C, ST, L, O, OU, CN, EMAIL (or EMAILADDRESS)} are allowed.");
        }
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof X500Principal) {
            return this.toX500Principal().equals(o2);
        }
        if (o2 instanceof X500Name) {
            X500Name x2 = (X500Name)o2;
            if (x2.size() != this.size()) {
                return false;
            }
            int size = this.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.componentAt(i2).equals(x2.componentAt(i2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    public X500Principal toX500Principal() {
        return new X500Principal(Utils.toBytes(this.outputASN1()));
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data = (byte[])is.readObject();
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

