/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.OIDRegistrar;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class X500RDN
implements ASN1Object,
Externalizable {
    private LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue> attrSet = new LinkedHashMap();
    private ASN1Set contents = null;

    public X500RDN() {
    }

    public X500RDN(ASN1ObjectID type, ASN1Object value) {
        this.attrSet.put(type, new AttributeTypeAndValue(type, value));
    }

    public X500RDN(ASN1ObjectID type, String value) {
        this.addAttribute(type, value);
    }

    public X500RDN(InputStream is) throws IOException {
        this.input(is);
    }

    X500RDN(String s2) {
        this.input(s2);
    }

    public void addAttribute(ASN1ObjectID type, ASN1Object value) {
        this.contents = null;
        this.attrSet.put(type, new AttributeTypeAndValue(type, value));
    }

    public void addAttribute(ASN1ObjectID type, String value) {
        int stringType = type.equals(PKIX.emailAddress) || type.equals(PKIX.id_domainComponent) ? 22 : 19;
        char[] c2 = value.toCharArray();
        int len = c2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (c2[i2] <= '\u007f' && (stringType != 19 || X500RDN.isASN1Printable(c2[i2]))) continue;
            stringType = 12;
            break;
        }
        this.addAttribute(type, new ASN1String(value, stringType));
    }

    private void addAttribute(AttributeTypeAndValue tv) {
        this.contents = null;
        this.attrSet.put(tv.getType(), tv);
    }

    public Enumeration<ASN1ObjectID> types() {
        return this.attrSet == null ? null : new Vector<ASN1ObjectID>(this.attrSet.keySet()).elements();
    }

    public Map<ASN1ObjectID, AttributeTypeAndValue> getValues() {
        return this.attrSet;
    }

    public ASN1Object getValue(ASN1ObjectID type) {
        AttributeTypeAndValue tv = this.attrSet.get(type);
        return tv != null ? tv.getValue() : null;
    }

    public int hashCode() {
        return Utils.hashBytes(this.toASN1Set());
    }

    private static String fixWhitespace(String s2) {
        String t2 = s2.trim();
        if (t2.length() == 0) {
            return t2;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(t2.charAt(0));
        int len = t2.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = t2.charAt(i2);
            if (Character.isWhitespace(c2)) {
                if (Character.isWhitespace(t2.charAt(i2 - 1))) continue;
                buf.append(' ');
                continue;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        X500RDN x2 = (X500RDN)o2;
        if (this.attrSet.size() != x2.attrSet.size()) {
            return false;
        }
        Iterator<AttributeTypeAndValue> e2 = this.attrSet.values().iterator();
        Iterator<AttributeTypeAndValue> f2 = x2.attrSet.values().iterator();
        while (e2.hasNext() && f2.hasNext()) {
            AttributeTypeAndValue a2 = e2.next();
            AttributeTypeAndValue b2 = f2.next();
            if (!a2.getType().equals(b2.getType())) {
                return false;
            }
            if (a2.getValue().getClass() != b2.getValue().getClass()) {
                return false;
            }
            if (a2.getValue() instanceof ASN1String) {
                ASN1String s2 = (ASN1String)a2.getValue();
                ASN1String t2 = (ASN1String)b2.getValue();
                if (!(s2.getTag() == 19 && t2.getTag() == 19 ? !X500RDN.fixWhitespace(s2.getValue()).equalsIgnoreCase(X500RDN.fixWhitespace(t2.getValue())) : !s2.getValue().equals(t2.getValue()))) continue;
                return false;
            }
            if (Utils.areEqual(Utils.toBytes(a2.getValue()), Utils.toBytes(b2.getValue()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean escapeUnicode) {
        StringBuffer s2 = new StringBuffer();
        for (AttributeTypeAndValue tv : this.attrSet.values()) {
            String name = X500RDN.getTypeName(tv.getType());
            s2.append(name != null ? name : tv.getType().toStringCompact());
            s2.append('=');
            ASN1Object value = tv.getValue();
            if (value instanceof ASN1String) {
                s2.append(X500RDN.escapeValue(((ASN1String)value).getValue(), escapeUnicode));
            } else {
                s2.append('#');
                s2.append(Utils.toHexString(Utils.toBytes(value)));
            }
            s2.append('+');
        }
        if (s2.length() > 0) {
            s2.setLength(s2.length() - 1);
        }
        return s2.toString();
    }

    public String toASCII() {
        return this.toString(true);
    }

    static String escapeValue(String s2, boolean escapeUnicode) {
        StringBuffer t2 = new StringBuffer(s2.length());
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (escapeUnicode && c2 >= '\u0080') {
                StringBuffer u2 = new StringBuffer();
                while (true) {
                    u2.append(c2);
                    if (i2 == s2.length() || s2.charAt(i2 + 1) < '\u0080') break;
                    c2 = s2.charAt(++i2);
                }
                String hex = Utils.toHexString(Utils.toUTF8(u2.toString()));
                int size = hex.length();
                for (int j2 = 0; j2 < size; j2 += 2) {
                    t2.append('\\');
                    t2.append(hex.charAt(j2));
                    t2.append(hex.charAt(j2 + 1));
                }
                continue;
            }
            if (c2 < ' ' || c2 == '\u007f' || i2 == 0 && c2 == ' ' || i2 == s2.length() - 1 && c2 == ' ') {
                String hex = Integer.toString(c2, 16);
                t2.append('\\');
                if (c2 < '\u0010') {
                    t2.append('0');
                }
                t2.append(hex);
                continue;
            }
            if (X500RDN.isSpecial(c2) || c2 == '\\' || c2 == '\"') {
                t2.append('\\');
            }
            t2.append(c2);
        }
        return t2.toString();
    }

    static String unescapeValue(String s2) {
        StringBuffer t2 = new StringBuffer(s2.length());
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (s2.charAt(i2) == '\\' && i2 < s2.length() - 1) {
                t2.append(s2.charAt(++i2));
                continue;
            }
            t2.append(s2.charAt(i2));
        }
        return t2.toString();
    }

    static ASN1ObjectID getTypeID(String name) {
        return OIDManager.getOIDManager().getAttributeType(name);
    }

    private static String getTypeName(ASN1ObjectID oid) {
        return OIDManager.getOIDManager().getAttributeName(oid);
    }

    private static boolean isAlpha(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isHexChar(char c2) {
        return X500RDN.isDigit(c2) || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean isSpecial(char c2) {
        return c2 == ',' || c2 == '+' || c2 == '=' || c2 == '<' || c2 == '>' || c2 == ';' || c2 == '#';
    }

    static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    static boolean isASN1Printable(char c2) {
        return X500RDN.isAlpha(c2) || X500RDN.isDigit(c2) || c2 == ' ' || c2 == '\'' || c2 == '(' || c2 == ')' || c2 == '+' || c2 == ',' || c2 == '-' || c2 == '.' || c2 == '/' || c2 == ':' || c2 == '=' || c2 == '?';
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.contents = null;
        this.attrSet = new LinkedHashMap();
        ASN1SetInputStream setIS = new ASN1SetInputStream(is);
        while (setIS.hasMoreData()) {
            AttributeTypeAndValue tv = new AttributeTypeAndValue(setIS);
            if (tv == null) continue;
            this.attrSet.put(tv.getType(), tv);
        }
        setIS.terminate();
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1Set().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Set().length();
    }

    private ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set s2 = new ASN1Set();
            Iterator<AttributeTypeAndValue> e2 = this.attrSet.values().iterator();
            while (e2.hasNext()) {
                s2.addElement(e2.next());
            }
            this.contents = s2;
        }
        return this.contents;
    }

    private void input(String s2) {
        this.contents = null;
        this.attrSet = new LinkedHashMap();
        StringBuffer a2 = new StringBuffer();
        boolean quoting = false;
        boolean foundAttr = false;
        int i2 = 0;
        while (i2 < s2.length()) {
            char c2 = s2.charAt(i2);
            if (c2 == '+' && !quoting && i2 > 0 && s2.charAt(i2 - 1) != '\\') {
                foundAttr = true;
            } else if (c2 == '\"') {
                quoting = !quoting;
                a2.append(c2);
            } else {
                a2.append(c2);
            }
            if (!foundAttr && ++i2 != s2.length()) continue;
            this.parseAttribute(a2.toString());
            a2 = new StringBuffer();
            quoting = false;
            foundAttr = false;
        }
    }

    private void parseAttribute(String s2) {
        String vs;
        int j0;
        int i2 = 0;
        i2 = s2.indexOf("=");
        if (i2 == -1) {
            throw new InvalidFormatException("'=' missing in attribute");
        }
        for (j0 = 0; j0 < i2 && X500RDN.isWhitespace(s2.charAt(j0)); ++j0) {
        }
        if (j0 == i2) {
            throw new InvalidFormatException("Attribute type missing");
        }
        int j1 = i2 - 1;
        while (j1 >= 0 & X500RDN.isWhitespace(s2.charAt(j1))) {
            --j1;
        }
        String ts = s2.substring(j0, j1 + 1);
        ASN1ObjectID type = X500RDN.isDigit(ts.charAt(0)) ? new ASN1ObjectID(ts) : (ts.toUpperCase().startsWith("OID.") ? new ASN1ObjectID(ts.substring(4)) : X500RDN.getTypeID(ts));
        if (type == null) {
            throw new InvalidFormatException("Malformed attribute type");
        }
        ++i2;
        while (i2 < s2.length() && X500RDN.isWhitespace(s2.charAt(i2))) {
            ++i2;
        }
        int j2 = s2.length() - 1;
        while (X500RDN.isWhitespace(s2.charAt(j2))) {
            --j2;
        }
        String string = vs = j2 >= i2 ? s2.substring(i2, j2 + 1) : "";
        if (vs.startsWith("#") && vs.length() > 1) {
            try {
                this.addAttribute(type, ASN1Utils.inputASN1Object(Utils.fromHexString(vs.substring(1))));
                return;
            }
            catch (IOException ex) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
            catch (NumberFormatException ex) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
        }
        boolean quoted = false;
        if (vs.startsWith("\"")) {
            if (vs.length() == 1 || !vs.endsWith("\"")) {
                throw new InvalidFormatException("Missing final '\"'");
            }
            vs = vs.substring(1, vs.length() - 1);
            quoted = true;
        }
        StringBuffer v2 = new StringBuffer(vs.length());
        int len = vs.length();
        for (i2 = 0; i2 < len; ++i2) {
            char c2 = vs.charAt(i2);
            if (c2 == '\\') {
                try {
                    if (X500RDN.isHexChar(vs.charAt(i2 + 1))) {
                        UnsyncByteArrayOutputStream b2 = new UnsyncByteArrayOutputStream();
                        while (true) {
                            b2.write(Integer.parseInt(vs.substring(i2 + 1, i2 + 3), 16));
                            if ((i2 += 2) >= vs.length() - 1 || vs.charAt(i2 + 1) != '\\' || !X500RDN.isHexChar(vs.charAt(i2 + 2))) break;
                            ++i2;
                        }
                        v2.append(Utils.fromUTF8(b2.toByteArray()));
                        continue;
                    }
                    if (X500RDN.isSpecial(c2 = vs.charAt(++i2)) || c2 == '\\' || c2 == '\"') {
                        v2.append(c2);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex.toString());
                }
            }
            if (!quoted && (X500RDN.isSpecial(c2) || c2 == '\\' || c2 == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            if (quoted && (c2 == '\\' || c2 == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            v2.append(c2);
        }
        this.addAttribute(type, v2.toString());
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }

    static {
        OIDRegistrar.mapAttributeTypeNames();
    }
}

