/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class NameConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_nameConstraints;
    private ArrayList<GeneralName> permitted;
    private ArrayList<GeneralName> excluded;

    public NameConstraintsExtension() {
        super(TYPE);
    }

    public NameConstraintsExtension(Vector<GeneralName> permitted, Vector<GeneralName> excluded) {
        this((List<GeneralName>)permitted, (List<GeneralName>)excluded);
    }

    public NameConstraintsExtension(List<GeneralName> permitted, List<GeneralName> excluded) {
        this(permitted, excluded, true);
    }

    public NameConstraintsExtension(Vector<GeneralName> permitted, Vector<GeneralName> excluded, boolean critical) {
        this((List<GeneralName>)permitted, (List<GeneralName>)excluded, critical);
    }

    public NameConstraintsExtension(List<GeneralName> permitted, List<GeneralName> excluded, boolean critical) {
        super(TYPE, critical);
        ArrayList<Object> arrayList = permitted == null ? null : (this.permitted = permitted instanceof ArrayList ? (ArrayList<Object>)permitted : new ArrayList<GeneralName>(permitted));
        this.excluded = excluded == null ? null : (excluded instanceof ArrayList ? (ArrayList<Object>)excluded : new ArrayList<GeneralName>(excluded));
        this.setValue(this.toByteArray());
    }

    public NameConstraintsExtension(InputStream is) throws IOException {
        super(is);
    }

    public Vector<GeneralName> getPermittedSubtrees() {
        ArrayList<GeneralName> l2 = this.getPermittedSubtreesAsList();
        return l2 == null ? null : new VectorOverArrayList<GeneralName>(l2);
    }

    public ArrayList<GeneralName> getPermittedSubtreesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.permitted;
    }

    public Vector<GeneralName> getExcludedSubtrees() {
        ArrayList<GeneralName> l2 = this.getExcludedSubtreesAsList();
        return l2 == null ? null : new VectorOverArrayList<GeneralName>(l2);
    }

    public ArrayList<GeneralName> getExcludedSubtreesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.excluded;
    }

    public void addPermittedSubtree(GeneralName name) {
        if (this.permitted == null) {
            this.permitted = new ArrayList();
        }
        this.permitted.add(name);
        this.setValue(this.toByteArray());
    }

    public void addExcludedSubtree(GeneralName name) {
        if (this.excluded == null) {
            this.excluded = new ArrayList();
        }
        this.excluded.add(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        ASN1Sequence s2;
        int i2;
        int len;
        ASN1Sequence nameCons = new ASN1Sequence();
        if (this.permitted != null && this.permitted.size() > 0) {
            ASN1GenericConstructed perm = new ASN1GenericConstructed(0);
            len = this.permitted.size();
            for (i2 = 0; i2 < len; ++i2) {
                s2 = new ASN1Sequence();
                s2.addElement(this.permitted.get(i2));
                perm.addElement(s2);
            }
            nameCons.addElement(perm);
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            ASN1GenericConstructed excl = new ASN1GenericConstructed(1);
            len = this.excluded.size();
            for (i2 = 0; i2 < len; ++i2) {
                s2 = new ASN1Sequence();
                s2.addElement(this.excluded.get(i2));
                excl.addElement(s2);
            }
            nameCons.addElement(excl);
        }
        byte[] b2 = Utils.toBytes(nameCons);
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            ASN1Sequence s2;
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
            if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream permis = new ASN1SequenceInputStream(sis);
                this.permitted = new ArrayList();
                while (permis.hasMoreData()) {
                    s2 = new ASN1Sequence(permis);
                    this.permitted.add(new GeneralName(Utils.toStream(s2.elementAt(0))));
                }
                permis.terminate();
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream exclis = new ASN1SequenceInputStream(sis);
                this.excluded = new ArrayList();
                while (exclis.hasMoreData()) {
                    s2 = new ASN1Sequence(exclis);
                    this.excluded.add(new GeneralName(Utils.toStream(s2.elementAt(0))));
                }
                exclis.terminate();
            }
            sis.terminate();
            if (this.permitted == null && this.excluded == null) {
                throw new ASN1FormatException("No name constraints defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        int i2;
        int size;
        boolean mid;
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("nameConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getPermittedSubtreesAsList() != null) {
            s2.append("permitted = {");
            mid = false;
            size = this.getPermittedSubtreesAsList().size();
            for (i2 = 0; i2 < size; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                s2.append(this.getPermittedSubtreesAsList().get(i2).toString());
                mid = true;
            }
            s2.append("}");
            began = true;
        }
        if (this.getExcludedSubtreesAsList() != null) {
            if (began) {
                s2.append(", ");
            }
            s2.append("excluded = {");
            mid = false;
            size = this.getExcludedSubtreesAsList().size();
            for (i2 = 0; i2 < size; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                s2.append(this.getExcludedSubtreesAsList().get(i2).toString());
                mid = true;
            }
            s2.append("}");
        }
        s2.append("]}");
        return s2.toString();
    }
}

