/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DESKey;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.OIDManager;

public class SymmetricKeyGenerator {
    protected static final int a = 16;
    protected static final int b = 24;
    protected static final int c = 32;
    protected static final int d = 56;
    protected static final int e = 8;
    protected static final int f = 24;
    protected static final int g = 16;
    protected static final int h = 16;
    protected AlgorithmIdentifier i;
    private int j;

    public static SymmetricKeyGenerator getInstance(AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        SymmetricKeyGenerator symmetricKeyGenerator;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "symmetricKeyGenerator");
        if (clazz == null) {
            throw new IllegalArgumentException("Can not find a symmetric key generator for this algorithm ID.");
        }
        try {
            symmetricKeyGenerator = (SymmetricKeyGenerator)clazz.newInstance();
            symmetricKeyGenerator.setAlgID(algorithmIdentifier);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unable to access " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalArgumentException(algorithmIdentifierException.toString());
        }
        return symmetricKeyGenerator;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
            int n2 = 0;
            if (algorithmIdentifier instanceof RC2AlgorithmIdentifier) {
                n2 = ((RC2AlgorithmIdentifier)algorithmIdentifier).getEffectiveKeyLength() / 8;
            }
            this.j = n2 > 0 ? n2 : 16;
        } else if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
            this.j = 8;
        } else if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.j = 24;
        } else if (aSN1ObjectID.equals(AlgID.blowfishECB.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID())) {
            this.j = 56;
        } else if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
            this.j = 16;
        } else if (aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes128_CBC.getOID())) {
            this.j = 16;
        } else if (aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID())) {
            this.j = 24;
        } else if (aSN1ObjectID.equals(AlgID.aes256_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID())) {
            this.j = 32;
        } else {
            throw new AlgorithmIdentifierException("unknown symmetric key algorithm");
        }
        this.i = algorithmIdentifier;
    }

    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.i;
    }

    public SymmetricKey generateKey(RandomBitsSource randomBitsSource, int n2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        byte[] byArray = new byte[n2];
        ASN1ObjectID aSN1ObjectID = this.i.getOID();
        if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            DESKey dESKey;
            do {
                randomBitsSource.randomBytes(byArray);
                dESKey = new DESKey(byArray, this.i);
                dESKey.b(1);
            } while (dESKey.a() || dESKey.b());
            return dESKey;
        }
        randomBitsSource.randomBytes(byArray);
        return new SymmetricKey(byArray, this.i);
    }

    public SymmetricKey generateKey(RandomBitsSource randomBitsSource) {
        return this.generateKey(randomBitsSource, this.j);
    }

    public SymmetricKey generateKey(int n2) {
        return this.generateKey(RandomBitsSource.getDefault(), n2);
    }

    public SymmetricKey generateKey() {
        return this.generateKey(RandomBitsSource.getDefault());
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

