/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ResourceBundle;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.OIDManager;
import oracle.security.pki.textui.OracleCRLTextUI;
import oracle.security.pki.textui.OracleCertTextUI;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.textui.OracleWalletTextUI;

public class OraclePKITextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "Syntax : \n[-option [value]]     : mandatory, for example [-wallet [wallet]] \n[-option <value>]     : optional, but when option is used its value is mandatory. \n<option>              : optional, for example <-summary>, <-complete> \n[option1] | [option2] : option1 'or' option2\n";

    public static void main(String[] stringArray) {
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(new int[]{2, 5, 4, 9});
        ASN1ObjectID aSN1ObjectID2 = new ASN1ObjectID(new int[]{2, 5, 4, 12});
        ASN1ObjectID aSN1ObjectID3 = new ASN1ObjectID(new int[]{2, 5, 4, 5});
        int n2 = 0;
        boolean bl = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals("-nologo") && !stringArray[i2].equals("-use_jce") && !stringArray[i2].equals("-jsafe") && !stringArray[i2].equals("-use_jce_only") && !stringArray[i2].equals("-fips140_mode")) continue;
            if (stringArray[i2].equals("-nologo")) {
                bl = true;
            } else if (stringArray[i2].equals("-use_jce")) {
                TransitionMode.enableJCEUse();
            } else if (stringArray[i2].equals("-jsafe")) {
                TransitionMode.enableJCEUse();
                try {
                    JCEUtil.registerJsafeJCE();
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    System.out.println("Unable to register Crypto-J JsafeJCE provider");
                    n2 = 1;
                    System.exit(n2);
                }
            } else if (stringArray[i2].equals("-use_jce_only")) {
                TransitionMode.disableOSDTCrypto();
            } else if (stringArray[i2].equals("-fips140_mode")) {
                TransitionMode.enableFIPS140Mode();
            }
            int n3 = stringArray.length - (i2 + 1);
            String[] stringArray2 = new String[stringArray.length - 1];
            if (stringArray.length > 1) {
                System.arraycopy(stringArray, 0, stringArray2, 0, i2);
                System.arraycopy(stringArray, i2 + 1, stringArray2, i2, n3);
            }
            stringArray = stringArray2;
            --i2;
        }
        if (!bl) {
            System.out.println(OraclePKIGenFunc.copyrightVersionBanner("Oracle PKI Tool"));
            System.out.println();
        }
        if (stringArray.length == 0) {
            System.out.println("orapki [crl|wallet|cert|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode>");
            n2 = 1;
            System.exit(n2);
        }
        if (TransitionMode.isFIPS140ModeEnabled()) {
            try {
                JCEUtil.getJCEProvider();
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println("Unable to get FIPS 140 cryptographic module: " + generalSecurityException.getMessage());
                n2 = 1;
                System.exit(n2);
            }
            try {
                if (!JCEUtil.isUnlimitedStrengthCryptoEnabled()) {
                    System.out.println("Unlimited Strength policy files are not installed; they are required in FIPS 140 mode");
                    n2 = 1;
                    System.exit(n2);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("Unable to perform crypto operations " + noSuchAlgorithmException.getMessage());
                n2 = 1;
                System.exit(n2);
            }
        }
        OIDManager.getOIDManager().setAttributeTypeName("STREET_ADDR", aSN1ObjectID);
        OIDManager.getOIDManager().setAttributeTypeName("TITLE", aSN1ObjectID2);
        OIDManager.getOIDManager().setAttributeTypeName("SERIAL_NUM", aSN1ObjectID3);
        if (stringArray[0].equals("help")) {
            System.out.println("orapki [crl|wallet|cert|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode>");
            System.out.println(b);
        } else if (stringArray[0].equals("crl")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            n2 = OracleCRLTextUI.command(stringArray3);
        } else if (stringArray[0].equals("wallet")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            n2 = OracleWalletTextUI.command(stringArray4);
        } else if (stringArray[0].equals("cert")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            n2 = OracleCertTextUI.command(stringArray5);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println("orapki [crl|wallet|cert|help] <-nologo> <-jsafe> <-use_jce> <-use_jce_only> <-fips140_mode>");
            n2 = -1;
        }
        System.exit(n2);
    }
}

