/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLSchemaAnnotator;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class BinXMLSchemaAnnotationBuilder
implements XSDConstantValues,
BinXMLConstants {
    URL url;
    XMLSchema schemaobj;
    XMLDocument doc;
    int propertyid = 100;
    int typeid = 1000;
    HashMap properties;
    boolean debug = false;

    BinXMLSchemaAnnotationBuilder(URL uRL, XMLSchema xMLSchema) {
        this.url = uRL;
        this.schemaobj = xMLSchema;
    }

    void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    boolean getDebugMode() {
        return this.debug;
    }

    XMLSchemaNode[] build() throws IOException, SAXException, XMLParseException, XSDException, BinXMLException {
        XMLSchemaNode[] xMLSchemaNodeArray = this.getSchemaNodes(this.url, this.schemaobj);
        XMLSchemaNode[] xMLSchemaNodeArray2 = this.build(this.doc, xMLSchemaNodeArray);
        if (this.debug) {
            this.showProperties();
        }
        if (this.debug) {
            this.doc.print(System.out);
        }
        return xMLSchemaNodeArray2;
    }

    private void showProperties() {
        Set set = this.properties.keySet();
        int n2 = set.size();
        Object[] objectArray = set.toArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSDNode xSDNode = (XSDNode)objectArray[i2];
            System.out.println("name: " + xSDNode.getQName().getLocalPart());
            BXProperty bXProperty = (BXProperty)this.properties.get(xSDNode);
            System.out.println("PID: " + bXProperty.getPID());
            System.out.println("TID: " + bXProperty.getTID());
        }
    }

    private XMLSchemaNode[] build(XMLDocument xMLDocument, XMLSchemaNode[] xMLSchemaNodeArray) {
        Vector vector = new Vector();
        for (int i2 = 0; i2 < xMLSchemaNodeArray.length; ++i2) {
            XSDNode[] xSDNodeArray = xMLSchemaNodeArray[i2].getAttributeDeclarations();
            xMLDocument = this.add2Pool(xMLDocument, vector, xSDNodeArray);
            xSDNodeArray = xMLSchemaNodeArray[i2].getSimpleTypeSet();
            xMLDocument = this.add2Pool(xMLDocument, vector, xSDNodeArray);
            xSDNodeArray = xMLSchemaNodeArray[i2].getComplexTypeSet();
            xMLDocument = this.add2Pool(xMLDocument, vector, xSDNodeArray);
            xSDNodeArray = xMLSchemaNodeArray[i2].getGroupSet();
            xMLDocument = this.add2Pool(xMLDocument, vector, xSDNodeArray);
            xSDNodeArray = xMLSchemaNodeArray[i2].getElementSet();
            xMLDocument = this.add2Pool(xMLDocument, vector, xSDNodeArray);
        }
        return this.createAnnotation(xMLDocument, vector, xMLSchemaNodeArray);
    }

    private XMLSchemaNode[] createAnnotation(XMLDocument xMLDocument, Vector vector, XMLSchemaNode[] xMLSchemaNodeArray) {
        int n2 = vector.size();
        this.properties = new HashMap(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.createAnnotation(xMLDocument, (XSDNode)vector.get(i2));
        }
        this.doc = xMLDocument;
        return xMLSchemaNodeArray;
    }

    private XMLElement createAnnotation(XMLDocument xMLDocument, XSDNode xSDNode) {
        if (xSDNode instanceof XSDComplexType) {
            BXProperty bXProperty = this.getBXProperty(xMLDocument, xSDNode);
            XMLElement xMLElement = this.generateKidList(xMLDocument, (XSDComplexType)xSDNode);
            return xMLElement;
        }
        if (xSDNode instanceof XSDElement) {
            BXProperty bXProperty = this.getBXProperty(xMLDocument, xSDNode);
            XMLElement xMLElement = this.generateKidList(xMLDocument, (XSDElement)xSDNode);
            return xMLElement;
        }
        if (xSDNode instanceof XSDSimpleType) {
            this.getBXProperty(xMLDocument, xSDNode);
            return ((XSDSimpleType)xSDNode).getDomNode();
        }
        if (xSDNode instanceof XSDAttribute) {
            this.getBXProperty(xMLDocument, xSDNode);
            return ((XSDAttribute)xSDNode).getDomNode();
        }
        if (xSDNode instanceof XSDGroup) {
            this.getBXProperty(xMLDocument, xSDNode);
            return ((XSDGroup)xSDNode).getDomNode();
        }
        return null;
    }

    private XMLElement generateKidList(XMLDocument xMLDocument, XSDElement xSDElement) {
        XSDNode xSDNode = xSDElement.getType();
        if (xSDNode instanceof XSDSimpleType) {
            return xSDElement.getDomNode();
        }
        if (xSDNode instanceof XSDAny) {
            return xSDElement.getDomNode();
        }
        XMLElement xMLElement = this.generateKidList(xMLDocument, (XSDComplexType)xSDNode);
        return xMLElement;
    }

    private XMLElement generateKidList(XMLDocument xMLDocument, XSDComplexType xSDComplexType) {
        int n2 = xSDComplexType.getContent();
        switch (n2) {
            case 10: 
            case 11: {
                return xSDComplexType.getDomNode();
            }
            case 12: 
            case 13: {
                boolean bl = BinXMLUtil.canBeInSeqMode(xSDComplexType);
                this.createAnnotation(xMLDocument, xSDComplexType, bl);
            }
        }
        return null;
    }

    private boolean canBeInSeqMode(XSDComplexType xSDComplexType) {
        XSDGroup xSDGroup = xSDComplexType.getTypeGroup();
        if (xSDGroup == null) {
            return false;
        }
        if (xSDGroup.getMaxOccurs() > 1) {
            return false;
        }
        return xSDGroup.getOrder() != 2;
    }

    private void createAnnotation(XMLDocument xMLDocument, XSDComplexType xSDComplexType, boolean bl) {
        XMLElement xMLElement;
        Object object;
        short s2;
        XSDAnnotation xSDAnnotation;
        XMLDocument xMLDocument2 = this.getRootNode(xSDComplexType);
        if (xMLDocument2 != xMLDocument && xMLDocument2 != null) {
            xMLDocument = xMLDocument2;
            this.doc = xMLDocument2;
        }
        if ((xSDAnnotation = xSDComplexType.getAnnotation()) == null) {
            xSDAnnotation = new XSDAnnotation();
        }
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://xmlns.oracle.com/2004/CSX", "csx:kidList");
        String string = "true";
        if (!bl) {
            string = "false";
        }
        xMLElement2.setAttribute("sequential", string);
        XSDNode[] xSDNodeArray = xSDComplexType.getChildElements();
        if (xSDNodeArray == null) {
            return;
        }
        if (xSDNodeArray.length == 1 && xSDNodeArray[0] instanceof XSDAny) {
            return;
        }
        int n2 = 0;
        for (s2 = 0; s2 < xSDNodeArray.length; ++s2) {
            if (!(xSDNodeArray[s2] instanceof XSDAny)) continue;
            ++n2;
        }
        if (n2 == xSDNodeArray.length) {
            return;
        }
        s2 = 1;
        for (int i2 = 0; i2 < xSDNodeArray.length; ++i2) {
            if (xSDNodeArray[i2] instanceof XSDAny) continue;
            BXProperty bXProperty = this.getBXProperty(xMLDocument, xSDNodeArray[i2]);
            int n3 = bXProperty.getPID();
            object = "csx:propertyID";
            if (n3 == -1) {
                n3 = bXProperty.getTID();
                object = "csx:typeID";
            }
            xMLElement = (XMLElement)xMLDocument.createElementNS("http://xmlns.oracle.com/2004/CSX", "csx:kid");
            xMLElement.setAttributeNS("http://xmlns.oracle.com/2004/CSX", (String)object, new Integer(n3).toString());
            xMLElement.setAttribute("kidNum", Short.toString(s2));
            xMLElement2.appendChild(xMLElement);
            s2 = (short)(s2 + 1);
            BXProperty bXProperty2 = this.getBXProperty(xMLDocument, xSDNodeArray[i2]);
            if (bXProperty2.getProcessedKids()) continue;
            bXProperty2.setProcessedKids(true);
            this.createAnnotation(xMLDocument, xSDNodeArray[i2]);
        }
        XSDAttribute[] xSDAttributeArray = xSDComplexType.getAttributeDeclarations();
        for (int i3 = 0; i3 < xSDAttributeArray.length; ++i3) {
            BXProperty bXProperty = this.getBXProperty(xMLDocument, xSDAttributeArray[i3]);
            object = (XMLElement)xMLDocument.createElementNS("http://xmlns.oracle.com/2004/CSX", "csx:kid");
            ((XMLElement)object).setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:propertyID", new Integer(bXProperty.getPID()).toString());
            ((XMLElement)object).setAttribute("kidNum", Short.toString(s2));
            xMLElement2.appendChild((Node)object);
            s2 = (short)(s2 + 1);
        }
        XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:appInfo");
        xMLElement3.appendChild(xMLElement2);
        xSDAnnotation.addAppInfo(xMLElement3);
        xSDComplexType.setAnnotation(xSDAnnotation);
        XMLElement xMLElement4 = xSDComplexType.getDomNode();
        if (!this.isWithKidList(xMLElement4)) {
            object = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:annotation");
            ((XMLNSNode)object).appendChild(xMLElement3);
            xMLElement = this.getFirstElementChild(xMLElement4);
            try {
                object = (XMLElement)xMLDocument.adoptNode((Node)object);
            }
            catch (XMLDOMException xMLDOMException) {
                // empty catch block
            }
            xMLElement4.insertBefore((Node)object, xMLElement);
        }
    }

    private XMLElement getFirstElementChild(XMLNode xMLNode) {
        XMLNode xMLNode2;
        for (xMLNode2 = (XMLNode)xMLNode.getFirstChild(); !(xMLNode2 instanceof XMLElement) && xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
        }
        return (XMLElement)xMLNode2;
    }

    private boolean isWithKidList(XMLElement xMLElement) {
        XMLElement xMLElement2 = this.getFirstElementChild(xMLElement);
        if (xMLElement2 == null || xMLElement2.getLocalName() == null || !xMLElement2.getLocalName().equals("annotation")) {
            return false;
        }
        XMLElement xMLElement3 = this.getFirstElementChild(xMLElement2);
        if (xMLElement3 == null || xMLElement3.getLocalName() == null || !xMLElement3.getLocalName().equals("appInfo")) {
            return false;
        }
        XMLElement xMLElement4 = this.getFirstElementChild(xMLElement3);
        return xMLElement4 != null && xMLElement4.getLocalName() != null && xMLElement4.getLocalName().equals("kidList") && xMLElement4.getNamespaceURI() != null && xMLElement4.getNamespaceURI().equals("http://xmlns.oracle.com/2004/CSX");
    }

    private BXProperty getBXProperty(XMLDocument xMLDocument, XSDNode xSDNode) {
        BXProperty bXProperty = (BXProperty)this.properties.get(xSDNode);
        if (bXProperty != null) {
            return bXProperty;
        }
        bXProperty = new BXProperty();
        if (xSDNode instanceof XSDElement || xSDNode instanceof XSDAttribute) {
            bXProperty.setPID(++this.propertyid);
            xSDNode.getDomNode().setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:propertyID", new Integer(this.propertyid).toString());
        } else if (xSDNode instanceof XSDComplexType || xSDNode instanceof XSDSimpleType) {
            bXProperty.setTID(++this.typeid);
            xSDNode.getDomNode().setAttributeNS("http://xmlns.oracle.com/2004/CSX", "csx:typeID", new Integer(this.typeid).toString());
        } else if (xSDNode instanceof XSDAny) {
            bXProperty.setPID(++this.propertyid);
            bXProperty.setTID(++this.typeid);
        }
        this.properties.put(xSDNode, bXProperty);
        return bXProperty;
    }

    private XMLDocument add2Pool(XMLDocument xMLDocument, Vector vector, XSDNode[] xSDNodeArray) {
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return xMLDocument;
        }
        for (int i2 = 0; i2 < xSDNodeArray.length; ++i2) {
            if (xSDNodeArray[i2] instanceof XSDSimpleType && BinXMLSchemaAnnotator.isBuiltinSimpleType((XSDSimpleType)xSDNodeArray[i2])) continue;
            vector.add(xSDNodeArray[i2]);
            if (xMLDocument != null) continue;
            xMLDocument = this.getRootNode(xSDNodeArray[i2]);
        }
        return xMLDocument;
    }

    private XMLDocument getRootNode(XSDNode xSDNode) {
        XMLElement xMLElement = xSDNode.getDomNode();
        if (xMLElement == null) {
            return this.doc;
        }
        XMLDocument xMLDocument = (XMLDocument)xMLElement.getOwnerDocument();
        return xMLDocument;
    }

    private XMLSchemaNode[] getSchemaNodes(URL uRL, XMLSchema xMLSchema) throws XSDException, IOException, SAXException, XMLParseException, BinXMLException {
        XSDBuilder xSDBuilder = new XSDBuilder();
        String[] stringArray = xMLSchema.getAllTargetNS();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n2 = stringArray.length;
        XMLSchemaNode[] xMLSchemaNodeArray = new XMLSchemaNode[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLSchemaNodeArray[i2] = xMLSchema.getSchemaByTargetNS(stringArray[i2]);
        }
        return xMLSchemaNodeArray;
    }

    class BXProperty {
        int pid = -1;
        int tid = -1;
        boolean processedKids = false;

        BXProperty() {
        }

        void setProcessedKids(boolean bl) {
            this.processedKids = bl;
        }

        boolean getProcessedKids() {
            return this.processedKids;
        }

        void setPID(int n2) {
            this.pid = n2;
        }

        int getPID() {
            return this.pid;
        }

        void setTID(int n2) {
            this.tid = n2;
        }

        int getTID() {
            return this.tid;
        }
    }
}

