/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.util.HashSet;

public abstract class DecimalFormatProperties<E extends Exception> {
    private static final String DECIMAL_SEPARATOR_PROPERTY_NAME = "decimal-separator";
    private static final int DECIMAL_SEPARATOR_DEFAULT_VALUE = 46;
    private static final String GROUPING_SEPARATOR_PROPERTY_NAME = "grouping-separator";
    private static final int GROUPING_SEPARATOR_DEFAULT_VALUE = 44;
    private static final String INFINITY_PROPERTY_NAME = "infinity";
    private static final String INFINITY_DEFAULT_VALUE = "Infinity";
    private static final String MINUS_SIGN_PROPERTY_NAME = "minus-sign";
    private static final int MINUS_SIGN_DEFAULT_VALUE = 45;
    private static final String NAN_PROPERTY_NAME = "NaN";
    private static final String NAN_DEFAULT_VALUE = "NaN";
    private static final String PERCENT_PROPERTY_NAME = "percent";
    private static final int PERCENT_DEFAULT_VALUE = 37;
    private static final String PER_MILLE_PROPERTY_NAME = "per-mille";
    private static final int PER_MILLE_DEFAULT_VALUE = 8240;
    private static final String ZERO_DIGIT_PROPERTY_NAME = "zero-digit";
    private static final int ZERO_DIGIT_DEFAULT_VALUE = 48;
    private static final String DIGIT_PROPERTY_NAME = "digit";
    private static final int DIGIT_DEFAULT_VALUE = 35;
    private static final String PATTERN_SEPARATOR_PROPERTY_NAME = "pattern-separator";
    private static final int PATTERN_SEPARATOR_DEFAULT_VALUE = 59;
    private boolean hasSetDecimalSep = false;
    private boolean hasSetGroupingSep = false;
    private boolean hasSetMinusSign = false;
    private boolean hasSetPercent = false;
    private boolean hasSetPerMille = false;
    private boolean hasSetZeroDigit = false;
    private boolean hasSetDigit = false;
    private boolean hasSetPatternSep = false;
    private boolean hasSetInfinity = false;
    private boolean hasSetNan = false;
    protected int decimalSep = 46;
    protected int groupingSep = 44;
    protected int minusSign = 45;
    protected int percent = 37;
    protected int perMille = 8240;
    protected int zeroDigit = 48;
    protected int digit = 35;
    protected int patternSep = 59;
    protected String infinity = "Infinity";
    protected String nan = "NaN";

    public DecimalFormatProperties() {
    }

    public DecimalFormatProperties(DecimalFormatProperties<E> decimalFormatProperties) {
        this.decimalSep = decimalFormatProperties.getDecimalSeparator();
        this.groupingSep = decimalFormatProperties.getGroupingSeparator();
        this.minusSign = decimalFormatProperties.getMinusSign();
        this.percent = decimalFormatProperties.getPercent();
        this.perMille = decimalFormatProperties.getPerMille();
        this.zeroDigit = decimalFormatProperties.getZeroDigit();
        this.digit = decimalFormatProperties.getDigit();
        this.patternSep = decimalFormatProperties.getPatternSeparator();
        this.infinity = decimalFormatProperties.getInfinity();
        this.nan = decimalFormatProperties.getNan();
    }

    protected abstract E createInvalidValueForPropertyException(String var1, String var2);

    protected abstract E createDuplicateValuesException(String var1);

    protected abstract E createPropertyAlreadyDefinedException(String var1);

    public int getDecimalSeparator() {
        return this.decimalSep;
    }

    public void setDecimalSeparator(int n2) {
        this.decimalSep = n2;
        this.hasSetDecimalSep = true;
    }

    public int getGroupingSeparator() {
        return this.groupingSep;
    }

    public void setGroupingSeparator(int n2) {
        this.groupingSep = n2;
        this.hasSetGroupingSep = true;
    }

    public int getMinusSign() {
        return this.minusSign;
    }

    public void setMinusSign(int n2) throws E {
        if (Character.charCount(n2) > 1) {
            throw this.getInvalidValueException(n2, MINUS_SIGN_PROPERTY_NAME);
        }
        this.minusSign = n2;
        this.hasSetMinusSign = true;
    }

    public int getPercent() {
        return this.percent;
    }

    public void setPercent(int n2) {
        this.percent = n2;
        this.hasSetPercent = true;
    }

    public int getPerMille() {
        return this.perMille;
    }

    public void setPerMille(int n2) {
        this.perMille = n2;
        this.hasSetPerMille = true;
    }

    public int getZeroDigit() {
        return this.zeroDigit;
    }

    public int getNineDigit() {
        return this.getZeroDigit() + 9;
    }

    public void setZeroDigit(int n2) throws E {
        if (!Character.isDigit(n2)) {
            throw this.getInvalidValueException(n2, ZERO_DIGIT_PROPERTY_NAME);
        }
        if (Character.getNumericValue(n2) != 0) {
            throw this.getInvalidValueException(n2, ZERO_DIGIT_PROPERTY_NAME);
        }
        this.zeroDigit = n2;
        this.hasSetZeroDigit = true;
    }

    public int getDigit() {
        return this.digit;
    }

    public void setDigit(int n2) {
        this.digit = n2;
        this.hasSetDigit = true;
    }

    public int getPatternSeparator() {
        return this.patternSep;
    }

    public void setPatternSeparator(int n2) {
        this.patternSep = n2;
        this.hasSetPatternSep = true;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public void setInfinity(String string) {
        this.infinity = string;
        this.hasSetInfinity = true;
    }

    public String getNan() {
        return this.nan;
    }

    public void setNan(String string) {
        this.nan = string;
        this.hasSetNan = true;
    }

    public void setProperty(String string, String string2) throws E {
        boolean bl = false;
        if (string.equals(DECIMAL_SEPARATOR_PROPERTY_NAME)) {
            if (this.hasSetDecimalSep) {
                bl = true;
            } else {
                this.checkValidLength(string2, DECIMAL_SEPARATOR_PROPERTY_NAME);
                this.setDecimalSeparator(string2.codePointAt(0));
            }
        } else if (string.equals(GROUPING_SEPARATOR_PROPERTY_NAME)) {
            if (this.hasSetGroupingSep) {
                bl = true;
            } else {
                this.checkValidLength(string2, GROUPING_SEPARATOR_PROPERTY_NAME);
                this.setGroupingSeparator(string2.codePointAt(0));
            }
        } else if (string.equals(INFINITY_PROPERTY_NAME)) {
            if (this.hasSetInfinity) {
                bl = true;
            } else {
                this.setInfinity(string2);
            }
        } else if (string.equals(MINUS_SIGN_PROPERTY_NAME)) {
            if (this.hasSetMinusSign) {
                bl = true;
            } else {
                this.checkValidLength(string2, MINUS_SIGN_PROPERTY_NAME);
                this.setMinusSign(string2.codePointAt(0));
            }
        } else if (string.equals("NaN")) {
            if (this.hasSetNan) {
                bl = true;
            } else {
                this.setNan(string2);
            }
        } else if (string.equals(PERCENT_PROPERTY_NAME)) {
            if (this.hasSetPercent) {
                bl = true;
            } else {
                this.checkValidLength(string2, PERCENT_PROPERTY_NAME);
                this.setPercent(string2.codePointAt(0));
            }
        } else if (string.equals(PER_MILLE_PROPERTY_NAME)) {
            if (this.hasSetPerMille) {
                bl = true;
            } else {
                this.checkValidLength(string2, PER_MILLE_PROPERTY_NAME);
                this.setPerMille(string2.codePointAt(0));
            }
        } else if (string.equals(ZERO_DIGIT_PROPERTY_NAME)) {
            if (this.hasSetZeroDigit) {
                bl = true;
            } else {
                this.checkValidLength(string2, ZERO_DIGIT_PROPERTY_NAME);
                this.setZeroDigit(string2.codePointAt(0));
            }
        } else if (string.equals(DIGIT_PROPERTY_NAME)) {
            if (this.hasSetDigit) {
                bl = true;
            } else {
                this.checkValidLength(string2, DIGIT_PROPERTY_NAME);
                this.setDigit(string2.codePointAt(0));
            }
        } else if (string.equals(PATTERN_SEPARATOR_PROPERTY_NAME)) {
            if (this.hasSetPatternSep) {
                bl = true;
            } else {
                this.checkValidLength(string2, PATTERN_SEPARATOR_PROPERTY_NAME);
                this.setPatternSeparator(string2.codePointAt(0));
            }
        }
        if (bl) {
            throw this.createPropertyAlreadyDefinedException(string);
        }
    }

    public void checkDistinctValues() throws E {
        HashSet<Integer> hashSet = new HashSet<Integer>(8);
        int n2 = -1;
        if (!hashSet.add(this.getDecimalSeparator()) || this.isMemberOfDecimalDigitFamily(this.getDecimalSeparator())) {
            n2 = this.decimalSep;
        } else if (!hashSet.add(this.getGroupingSeparator()) || this.isMemberOfDecimalDigitFamily(this.getGroupingSeparator())) {
            n2 = this.groupingSep;
        } else if (!hashSet.add(this.getPercent()) || this.isMemberOfDecimalDigitFamily(this.getPercent())) {
            n2 = this.percent;
        } else if (!hashSet.add(this.getPerMille()) || this.isMemberOfDecimalDigitFamily(this.getPerMille())) {
            n2 = this.perMille;
        } else if (!hashSet.add(this.getZeroDigit())) {
            n2 = this.zeroDigit;
        } else if (!hashSet.add(this.getDigit()) || this.isMemberOfDecimalDigitFamily(this.getDigit())) {
            n2 = this.digit;
        } else if (!hashSet.add(this.getPatternSeparator()) || this.isMemberOfDecimalDigitFamily(this.getPatternSeparator())) {
            n2 = this.patternSep;
        }
        if (n2 != -1) {
            String string = String.valueOf(Character.toChars(n2));
            throw this.createDuplicateValuesException(string);
        }
    }

    private boolean isMemberOfDecimalDigitFamily(int n2) {
        return n2 >= this.getZeroDigit() && n2 <= this.getNineDigit();
    }

    private E getInvalidValueException(int n2, String string) {
        String string2 = String.valueOf(Character.toChars(n2));
        return this.createInvalidValueForPropertyException(string2, string);
    }

    private void checkValidLength(String string, String string2) throws E {
        if (string.isEmpty() || string.codePointCount(0, string.length()) > 1) {
            throw this.createInvalidValueForPropertyException(string, string2);
        }
    }
}

