/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.jdwp.Field;
import oracle.xml.jdwp.VariableTable;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPNode;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPString;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.NSName;
import oracle.xml.util.FastVector;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLVariable;

public class XSLJDWPReferenceType
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    private Hashtable id2Name;
    XSLTContext context;

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.cmd.cmd) {
            case 1: {
                xSLJDWPPacket2 = this.signatureCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.classLoaderCmd();
                break;
            }
            case 4: {
                xSLJDWPPacket2 = this.fieldsCmd();
                break;
            }
            case 5: {
                xSLJDWPPacket2 = this.methodsCmd();
                break;
            }
            case 6: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 7: {
                xSLJDWPPacket2 = this.sourceFileCmd();
                break;
            }
            case 9: {
                xSLJDWPPacket2 = this.statusCmd();
                break;
            }
            case 10: {
                xSLJDWPPacket2 = this.interfacesCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    public void setXSLTContext(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    XSLJDWPPacket signatureCmd() {
        int n2 = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            String string = this.signatureCmdData(n2);
            xSLJDWPPacketStream.writeString(string);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket classLoaderCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeClassLoaderID(0);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket fieldsCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            int n2 = this.cmdStrm.readReferenceType();
            Field[] fieldArray = this.getFieldsCmdData(n2);
            if (fieldArray == null) {
                xSLJDWPPacketStream.writeInt(0);
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            xSLJDWPPacketStream.writeInt(fieldArray.length);
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                xSLJDWPPacketStream.writeFieldID(fieldArray[i2].getFieldID());
                xSLJDWPPacketStream.writeString(fieldArray[i2].getName());
                xSLJDWPPacketStream.writeString(fieldArray[i2].getSignature());
                xSLJDWPPacketStream.writeInt(fieldArray[i2].getModBits());
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    Hashtable getFieldID2Name(int n2) throws XSLJDWPException {
        this.getFieldsCmdData(n2);
        return this.id2Name;
    }

    Field[] getFieldsCmdData(int n2) throws XSLJDWPException {
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]") == n2 || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]") == n2) {
            return null;
        }
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode") == n2) {
            return XSLJDWPNode.getFields();
        }
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString") == n2) {
            return XSLJDWPString.getFields();
        }
        FastVector fastVector = this.jdwpvm.xsl.getFields();
        int n3 = fastVector.size();
        Field[] fieldArray = new Field[n3];
        this.id2Name = new Hashtable(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            block13: {
                fieldArray[i2] = new Field();
                fieldArray[i2].setFieldID(i2 + 1);
                XSLVariable xSLVariable = (XSLVariable)fastVector.elementAt(i2);
                NSName nSName = xSLVariable.getName();
                String string = nSName.getExpandedName();
                fieldArray[i2].setName(string);
                this.id2Name.put(new Integer(i2 + 1), string);
                if (this.context != null) {
                    try {
                        String string2 = XSLJDWPUtil.getTypeString(this.context.getVariable(nSName, -2));
                        if (string2.compareTo("string") == 0) {
                            fieldArray[i2].setSignature("L$oracle/xml/xslt/XMLString;");
                            break block13;
                        }
                        if (string2.compareTo("boolean") == 0) {
                            fieldArray[i2].setSignature("Z");
                            break block13;
                        }
                        if (string2.compareTo("number") == 0) {
                            fieldArray[i2].setSignature("D");
                            break block13;
                        }
                        if (string2.compareTo("node-set") == 0) {
                            fieldArray[i2].setSignature("[L$oracle/xml/xslt/XMLNode;");
                            break block13;
                        }
                        fieldArray[i2].setSignature("L$oracle/xml/xslt/XMLNode;");
                    }
                    catch (NullPointerException nullPointerException) {
                        fieldArray[i2].setSignature("L$oracle/xml/xslt/XMLString;");
                    }
                    catch (XQException xQException) {
                        fieldArray[i2].setSignature("L$oracle/xml/xslt/XMLString;");
                    }
                } else {
                    fieldArray[i2].setSignature("L$oracle/xml/xslt/XMLString;");
                }
            }
            fieldArray[i2].setModBits(9);
        }
        return fieldArray;
    }

    XSLJDWPPacket methodsCmd() {
        int n2 = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        if (this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode") == n2 || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]") == n2 || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString") == n2 || this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]") == n2) {
            xSLJDWPPacketStream.writeInt(0);
            xSLJDWPPacketStream.close();
            return xSLJDWPPacketStream.packet();
        }
        Hashtable[] hashtableArray = this.jdwpvm.xsl.getClassID2methodID();
        if (n2 > hashtableArray.length) {
            return this.cmd.createErrorReply((short)21);
        }
        Hashtable hashtable = hashtableArray[n2 - 1];
        int n3 = 0;
        if (hashtable == null) {
            xSLJDWPPacketStream.writeInt(n3);
            xSLJDWPPacketStream.close();
            return xSLJDWPPacketStream.packet();
        }
        n3 = hashtable.size();
        xSLJDWPPacketStream.writeInt(n3);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            VariableTable variableTable;
            Integer n4 = (Integer)enumeration.nextElement();
            String string = (String)hashtable.get(n4);
            string = XSLJDWPUtil.convertMethodName(string);
            int n5 = n4;
            xSLJDWPPacketStream.writeMethodID(n5);
            try {
                xSLJDWPPacketStream.writeString(string);
            }
            catch (XSLJDWPException xSLJDWPException) {
                return this.cmd.createErrorReply(xSLJDWPException.errorCode());
            }
            StringBuffer stringBuffer = new StringBuffer("(");
            Hashtable hashtable2 = this.jdwpvm.xsl.getClassMethodParams();
            long l2 = ((long)n2 << 32) + (long)n5;
            Long l3 = new Long(l2);
            Integer n6 = (Integer)hashtable2.get(l3);
            int n7 = 4;
            if (n6 != null) {
                n7 += n6.intValue();
            }
            if ((variableTable = this.jdwpvm.xsl.getJDWPMethod().getVariableTable(n2, n5)) != null) {
                String[] stringArray = variableTable.getSignature();
                for (int i2 = 0; i2 < n7; ++i2) {
                    stringBuffer.append(stringArray[i2]);
                }
            }
            stringBuffer.append(")V");
            try {
                xSLJDWPPacketStream.writeString(stringBuffer.toString());
            }
            catch (XSLJDWPException xSLJDWPException) {
                return this.cmd.createErrorReply(xSLJDWPException.errorCode());
            }
            xSLJDWPPacketStream.writeInt(10);
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket getValuesCmd() {
        int n2 = this.cmdStrm.readReferenceType();
        int n3 = this.cmdStrm.readInt();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.cmdStrm.readFieldID();
        }
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = null;
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            xSLJDWPPacketValueArray = this.generateValuesData(n2, n3, nArray);
            int n4 = xSLJDWPPacketValueArray.length;
            xSLJDWPPacketStream.writeInt(n4);
            if (n4 == 0) {
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            XSLJDWPObjectReference xSLJDWPObjectReference = this.jdwpvm.xsl.getJDWPObjectReference();
            xSLJDWPObjectReference.generateIDs(xSLJDWPPacketValueArray);
            for (int i3 = 0; i3 < n4; ++i3) {
                xSLJDWPPacketStream.writeValue(xSLJDWPPacketValueArray[i3]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacketValue[] generateValuesData(int n2, int n3, int[] nArray) throws XSLJDWPException {
        if (this.context == null) {
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                xSLJDWPPacketValueArray[i2] = new XSLJDWPPacketValue(76, new Integer(0));
            }
            return xSLJDWPPacketValueArray;
        }
        int n4 = n3;
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n4];
        Hashtable hashtable = this.context.getGlobalVariables();
        Hashtable hashtable2 = this.getFieldID2Name(n2);
        for (int i3 = 0; i3 < n4; ++i3) {
            XSLJDWPPacketValue xSLJDWPPacketValue;
            int n5 = nArray[i3];
            String string = (String)hashtable2.get(new Integer(n5));
            OXMLSequence oXMLSequence = (OXMLSequence)hashtable.get(string);
            xSLJDWPPacketValueArray[i3] = xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue(oXMLSequence);
        }
        return xSLJDWPPacketValueArray;
    }

    XSLJDWPPacket sourceFileCmd() {
        int n2 = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            String string = this.getSourceFileCmdData(n2);
            if (string == null) {
                throw new XSLJDWPException(101);
            }
            xSLJDWPPacketStream.writeString(string);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket statusCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(this.jdwpvm.xsl.getClassStatus());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    private String signatureCmdData(int n2) {
        if (n2 >> 24 == 0) {
            int n3 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode");
            if (n2 == n3) {
                return "L$oracle/xml/xslt/XMLNode;";
            }
            n3 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]");
            if (n2 == n3) {
                return "[L$oracle/xml/xslt/XMLNode;";
            }
            n3 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString");
            if (n2 == n3) {
                return "L$oracle/xml/xslt/XMLString;";
            }
            this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]");
            if (n2 == n3) {
                return "[C";
            }
            return "L$oracle/xml/xslt/Object;";
        }
        if (n2 >> 24 == 3) {
            return "[L$oracle/xml/xslt/XMLNode;";
        }
        if (n2 >> 24 == 2) {
            return "L$oracle/xml/xslt/XMLString;";
        }
        return "L$oracle/xml/xslt/Object;";
    }

    private int getStatusCmdData(int n2) {
        return this.jdwpvm.xsl.getClassStatus();
    }

    private String getSourceFileCmdData(int n2) {
        int n3 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode");
        int n4 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLNode[]");
        int n5 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("XMLString");
        int n6 = this.jdwpvm.xsl.getJDWPVirtualMachine().getRefType("char[]");
        if (n3 == n2 || n5 == n2 || n4 == n2 || n6 == n2) {
            return null;
        }
        Hashtable hashtable = this.jdwpvm.xsl.getJDWPVirtualMachine().getAllClassesByID();
        String string = (String)hashtable.get(new Integer(n2));
        File file = new File(string);
        return file.getName();
    }

    XSLJDWPPacket interfacesCmd() {
        int n2 = this.cmdStrm.readReferenceType();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(0);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }
}

