/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.LinkedList;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

public class XSLJDWPStackFrame
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    XSLTContext context;

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.setValuesCmd();
                break;
            }
            case 4: {
                xSLJDWPPacket2 = this.popFramesCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    synchronized XSLJDWPPacket setValuesCmd() {
        int n2 = this.cmdStrm.readThreadID();
        int n3 = this.cmdStrm.readFrameID();
        int n4 = this.cmdStrm.readInt();
        try {
            this.setValuesData(n2, n3, n4);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        return this.cmd.createReply();
    }

    XSLJDWPPacket popFramesCmd() {
        int n2 = this.cmdStrm.readThreadID();
        int n3 = this.cmdStrm.readFrameID();
        XSLJDWPUtil.printTrace(this.jdwpvm.xsl.getXSLDebugProp(), "PopFrames command");
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket getValuesCmd() {
        int n2 = this.cmdStrm.readThreadID();
        int n3 = this.cmdStrm.readFrameID();
        int n4 = this.cmdStrm.readInt();
        int[] nArray = new int[n4];
        byte[] byArray = new byte[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = this.cmdStrm.readInt();
            byArray[i2] = this.cmdStrm.readByte();
        }
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            int n5 = this.jdwpvm.xsl.getFrameValues().size();
            if (n3 > n5 || n3 <= 0) {
                throw new XSLJDWPException(30);
            }
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = this.generateGetValuesData(n2, n3, n4, nArray, byArray);
            int n6 = xSLJDWPPacketValueArray.length;
            xSLJDWPPacketStream.writeInt(n6);
            if (n6 == 0) {
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            XSLJDWPObjectReference xSLJDWPObjectReference = this.jdwpvm.xsl.getJDWPObjectReference();
            xSLJDWPObjectReference.generateIDs(xSLJDWPPacketValueArray);
            for (int i3 = 0; i3 < n6; ++i3) {
                xSLJDWPPacketStream.writeValue(xSLJDWPPacketValueArray[i3]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    public void setXSLTContext(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    private Integer getContextPosData() throws XSLException {
        Integer n2 = null;
        n2 = this.context == null ? new Integer(-1) : new Integer(this.context.getContextPosition());
        return n2;
    }

    private void setContextPosData(int n2) {
        this.context.setContextPosition(n2);
    }

    private Integer getContextSizeData() throws XSLException {
        Integer n2 = null;
        n2 = this.context == null ? new Integer(-1) : new Integer(this.context.getContextSize());
        return n2;
    }

    private void setContextSizeData(int n2) {
        this.context.setContextSize(n2);
    }

    private XMLNode getContextNodeData() throws XSLException {
        if (this.context == null) {
            return null;
        }
        return this.context.getJDWPContextNode();
    }

    private void setValuesData(int n2, int n3, int n4) throws XSLJDWPException {
        LinkedList linkedList = this.jdwpvm.xsl.getFrameValues();
        LinkedList linkedList2 = (LinkedList)linkedList.get(n3 - 1);
        int n5 = -1;
        block4: for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = this.cmdStrm.readInt();
            if (n6 == 0) {
                n5 = this.cmdStrm.readByte();
                int n7 = this.cmdStrm.readInt();
                this.setContextPosData(n7);
                continue;
            }
            if (n6 == 1) {
                n5 = this.cmdStrm.readByte();
                int n8 = this.cmdStrm.readInt();
                this.setContextSizeData(n8);
                continue;
            }
            if (n6 == 2 || n6 == 3) continue;
            OXMLSequence oXMLSequence = (OXMLSequence)linkedList2.get(n6 - 3);
            n5 = this.cmdStrm.readByte();
            switch (n5) {
                case 90: {
                    boolean bl = this.cmdStrm.readBoolean();
                    XPathSequence.setBooleanValue(oXMLSequence, bl);
                    continue block4;
                }
                case 68: {
                    double d2 = this.cmdStrm.readDouble();
                    XPathSequence.setNumberValue(oXMLSequence, d2);
                }
            }
        }
    }

    private XSLJDWPPacketValue[] generateGetValuesData(int n2, int n3, int n4, int[] nArray, byte[] byArray) throws XSLJDWPException {
        LinkedList linkedList = this.jdwpvm.xsl.getFrameValues();
        LinkedList linkedList2 = (LinkedList)linkedList.get(n3 - 1);
        int n5 = 3;
        int n6 = linkedList2.size() + n5;
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n4];
        XSLJDWPPacketValue xSLJDWPPacketValue = null;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (i2 >= n6) {
                xSLJDWPPacketValueArray[i2] = xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue(null);
                continue;
            }
            int n7 = nArray[i2] - n5;
            int n8 = nArray[i2];
            try {
                Object object;
                if (n8 == n5 - 3) {
                    xSLJDWPPacketValue = new XSLJDWPPacketValue(73, this.getContextPosData());
                } else if (n8 == n5 - 2) {
                    xSLJDWPPacketValue = new XSLJDWPPacketValue(73, this.getContextSizeData());
                } else if (n8 == n5 - 1) {
                    object = this.jdwpvm.xsl.getJDWPObjectReference();
                    Integer n9 = ((XSLJDWPObjectReference)object).generateUniqueNodeID(this.getContextNodeData());
                    xSLJDWPPacketValue = n9 == 0 ? new XSLJDWPPacketValue(86, null) : new XSLJDWPPacketValue(76, n9);
                } else if (n7 >= linkedList2.size()) {
                    xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue(null);
                } else if (n7 >= 0) {
                    object = (OXMLSequence)linkedList2.get(n7);
                    xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue((OXMLSequence)object);
                    xSLJDWPPacketValue.setData((OXMLSequence)object);
                }
                xSLJDWPPacketValueArray[i2] = xSLJDWPPacketValue;
                continue;
            }
            catch (XSLException xSLException) {
                throw new XSLJDWPException(xSLException, 20);
            }
        }
        return xSLJDWPPacketValueArray;
    }
}

