/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;

public class XSDAttribute
extends XSDNode
implements XSDTypeConstants {
    int qualified;
    XSDSimpleType simpleType;
    String refNamespace;
    String refLocalname;
    int refState;
    XSDAnnotation refAnnotation;
    String defaultVal;
    String fixedVal;
    int minOccurs;
    int maxOccurs;

    XSDAttribute() {
        this.init();
    }

    XSDAttribute(String string, String string2) {
        super(string, string2);
        this.init();
    }

    void setRef(String string, String string2) throws XSDException {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        super.setName(string2);
        this.refState = 1;
    }

    void setTypeRef(String string, String string2) {
        this.refLocalname = string2.intern();
        this.refNamespace = string.intern();
        this.refState = 3;
    }

    public int getRefState() {
        return this.refState;
    }

    @Override
    public XSDAnnotation getRefAnnotation() {
        if (this.refState == 1) {
            return this.annotation;
        }
        if (this.refState == 0) {
            return this.refAnnotation;
        }
        return null;
    }

    void setMinOccurs(int n2) {
        this.minOccurs = n2;
    }

    void setMaxOccurs(int n2) {
        this.maxOccurs = n2;
    }

    void setForm(String string) throws XSDException {
        if (string.equals("qualified")) {
            this.qualified = 1;
        } else if (string.equals("unqualified")) {
            this.qualified = 0;
        } else {
            throw new XSDException(24526, "invalid form attribute");
        }
    }

    void setDefault(String string) {
        this.defaultVal = string;
    }

    public String getDefaultVal() {
        return this.defaultVal;
    }

    public String getFixedVal() {
        return this.fixedVal;
    }

    @Override
    public String getName() {
        if (this.refState == 0 && this.refLocalname != null) {
            return this.refLocalname;
        }
        return this.name;
    }

    public String getRefNamespace() {
        return this.refNamespace;
    }

    @Override
    public String getRefLocalname() {
        return this.refLocalname;
    }

    @Override
    public String getTargetNS() {
        if (this.refState == 0 && this.refNamespace != null) {
            return this.refNamespace;
        }
        if (this.qualified == 1) {
            return this.parent.getTargetNS();
        }
        return "";
    }

    public boolean isRequired() {
        return this.minOccurs == 1;
    }

    boolean validateValue(String string) throws XSDException {
        if (this.simpleType == null) {
            throw new XSDException();
        }
        try {
            this.simpleType.validateValue(this.simpleType.processWS(string));
        }
        catch (Exception exception) {
            return false;
        }
        return this.fixedVal == null || this.simpleType.compareValues(string, this.fixedVal) == 0;
    }

    void checkConstraints() throws XSDException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        XSDBuilder xSDBuilder = this.getOwnerSchema().getBuilder();
        String string = null;
        if (this.defaultVal != null) {
            if (this.fixedVal != null || this.maxOccurs == 0 || this.minOccurs == 1) {
                xSDBuilder.error(this.domNode, 24543, this.getName(), false);
            }
            if ((string = this.simpleType.getCanonicalForm(this.defaultVal)) == null) {
                xSDBuilder.error(this.domNode, 24543, this.getName(), false);
            } else {
                this.defaultVal = string;
            }
        } else if (this.fixedVal != null) {
            if (this.maxOccurs == 0) {
                xSDBuilder.error(this.domNode, 24543, this.getName(), false);
            }
            if ((string = this.simpleType.getCanonicalForm(this.fixedVal)) == null) {
                xSDBuilder.error(this.domNode, 24543, this.getName(), false);
            } else {
                this.fixedVal = string;
            }
        }
        if (this.name == null || this.name == "xmlns") {
            xSDBuilder.error(this.domNode, 24543, this.getName(), false);
        }
    }

    void setFixed(String string) {
        this.fixedVal = string;
    }

    public XSDNode getType() {
        return this.simpleType;
    }

    void setType(XSDNode xSDNode) {
        this.setSimpleType((XSDSimpleType)xSDNode);
    }

    void setSimpleType(XSDSimpleType xSDSimpleType) {
        this.simpleType = xSDSimpleType;
        this.refState = 2;
    }

    void resolveTypeReference(XMLSchema xMLSchema) throws XSDException {
        XSDNode xSDNode = xMLSchema.getType(this.refNamespace, this.refLocalname, 2);
        if (xSDNode != null) {
            this.setSimpleType((XSDSimpleType)xSDNode);
        }
    }

    void resolveReference(XMLSchema xMLSchema) throws XSDException {
        XSDAttribute xSDAttribute = (XSDAttribute)xMLSchema.getComponent(this.refNamespace, this.refLocalname, this.nodeType);
        if (xSDAttribute != null) {
            if (xSDAttribute.refState == 3) {
                xSDAttribute.resolveTypeReference(xMLSchema);
            }
            if (xSDAttribute.refState == 3) {
                return;
            }
            this.setType(xSDAttribute.getType());
            this.name = xSDAttribute.name;
            this.refAnnotation = this.annotation;
            this.annotation = xSDAttribute.annotation;
            if (this.defaultVal == null && this.fixedVal == null) {
                this.defaultVal = xSDAttribute.defaultVal;
                this.fixedVal = xSDAttribute.fixedVal;
            } else if (!(xSDAttribute.fixedVal == null || this.defaultVal == null && xSDAttribute.fixedVal.equals(this.fixedVal))) {
                xMLSchema.getBuilder().error(this.domNode, 24543, this.name, false);
            }
            this.refState = 0;
        }
    }

    private void init() {
        this.nodeType = 4;
        this.minOccurs = 0;
        this.maxOccurs = 1;
        this.defaultVal = null;
        this.fixedVal = null;
        this.simpleType = XSDSimpleType.urType;
        this.qualified = 1;
        this.refState = 2;
    }

    @Override
    void print(int n2) {
        boolean bl = false;
        this.printSTag(n2);
        super.printAnnotation();
        if (this.defaultVal != null) {
            System.out.println(XSDAttribute.indent(n2) + "default =" + this.defaultVal);
        }
        if (this.fixedVal != null) {
            System.out.println(XSDAttribute.indent(n2) + "fixed = " + this.fixedVal);
        }
        switch (this.qualified) {
            case 0: {
                System.out.println(XSDAttribute.indent(n2) + "form = " + "unqualified");
                break;
            }
            case 1: {
                System.out.println(XSDAttribute.indent(n2) + "form = " + "qualified");
                break;
            }
        }
        System.out.println(XSDAttribute.indent(n2) + "minOccurs = " + this.minOccurs);
        System.out.println(XSDAttribute.indent(n2) + "maxOccurs = " + this.maxOccurs);
        switch (this.refState) {
            case 2: 
            case 3: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(XSDAttribute.indent(n2) + "type = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
            case 0: 
            case 1: {
                if (this.refLocalname == null) break;
                bl = true;
                System.out.print(XSDAttribute.indent(n2) + "ref = " + this.refNamespace);
                System.out.println(":" + this.refLocalname);
                break;
            }
        }
        this.printSTagEnd(n2);
        if (!bl) {
            this.simpleType.print(n2 + 3);
        }
        this.printETag(n2);
    }
}

