/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.util.XMLUtil;

public class XSDDataValue
implements XSDTypeConstants,
XSDConstantValues {
    protected boolean booleanValue;
    protected double doubleValue;
    protected int intValue;
    protected Object objValue;
    protected String lexicalValue;
    protected int basicType;
    static final String _true = "true";
    static final String _false = "false";
    static final int[] mDays = new int[]{31, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final int[] minMonthDay = new int[]{0, 28, 59, 89, 120, 150, 181, 212, 242, 273, 303, 334, 365};
    static final int[] maxMonthDay = new int[]{0, 31, 62, 92, 123, 153, 184, 215, 245, 276, 306, 337, 366};
    static final double FLOATMAX = Math.pow(2.0, 24.0) * Math.pow(2.0, 104.0);
    static final double DOUBLEMAX = Math.pow(2.0, 53.0) * Math.pow(2.0, 970.0);
    public static final SimpleTimeZone UTC = new SimpleTimeZone(0, "UTC");

    public XSDDataValue() {
        this.basicType = 2;
        this.booleanValue = false;
    }

    public XSDDataValue(int n2, String string) throws XSDException {
        this.setValue(n2, string);
    }

    protected void reset() {
        this.basicType = 2;
        this.booleanValue = false;
        this.objValue = null;
        this.lexicalValue = null;
    }

    public void setValue(int n2, String string) throws XSDException {
        this.lexicalValue = string.intern();
        this.basicType = n2;
        this.booleanValue = false;
        this.doubleValue = 0.0;
        this.intValue = 0;
        String string2 = sTypes[this.basicType];
        try {
            switch (this.basicType) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    String string3 = this.lexicalValue;
                    if (string3 == _true || string3.equals("1")) {
                        this.booleanValue = true;
                        break;
                    }
                    if (string3 == _false || string3.equals("0")) {
                        this.booleanValue = false;
                        break;
                    }
                    throw new XSDException(24507, string, string2);
                }
                case 3: 
                case 4: {
                    if (string.equals("-INF")) {
                        this.doubleValue = Double.NEGATIVE_INFINITY;
                        break;
                    }
                    if (string.equals("INF")) {
                        this.doubleValue = Double.POSITIVE_INFINITY;
                        break;
                    }
                    if (string.equals("NaN")) {
                        this.doubleValue = Double.NaN;
                        break;
                    }
                    if (this.basicType == 3) {
                        float f2 = Float.valueOf(string).floatValue();
                        if (f2 == Float.POSITIVE_INFINITY) {
                            this.doubleValue = Double.POSITIVE_INFINITY;
                            break;
                        }
                        if (f2 == Float.NEGATIVE_INFINITY) {
                            this.doubleValue = Double.NEGATIVE_INFINITY;
                            break;
                        }
                        this.doubleValue = f2;
                        break;
                    }
                    this.doubleValue = Double.valueOf(string);
                    break;
                }
                case 5: {
                    this.booleanValue = false;
                    if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                        throw new XSDException(24507, string, string2);
                    }
                    int n3 = string.length();
                    if (string.charAt(0) == '+') {
                        this.lexicalValue = this.lexicalValue.substring(1, n3--).intern();
                    }
                    try {
                        this.intValue = Integer.parseInt(this.lexicalValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.lexicalValue.charAt(n3 - 1) == '.') {
                            this.lexicalValue = this.lexicalValue.substring(0, n3).intern();
                        }
                        this.objValue = new BigDecimal(this.lexicalValue);
                        this.booleanValue = true;
                    }
                    break;
                }
                case 6: {
                    this.parseTimeDuration(string);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    this.parseTimeInstant(string);
                    break;
                }
                case 15: {
                    this.lexicalValue = this.parseHexBinary(string).intern();
                    break;
                }
                case 16: {
                    this.lexicalValue = this.parseBase64Binary(string).intern();
                    break;
                }
                case 17: {
                    if (!XSDSimpleType.isURI(string)) {
                        throw new XSDException(24507, string, string2);
                    }
                    break;
                }
                case 18: 
                case 19: {
                    if (string == "") {
                        throw new XSDException(24507, string, string2);
                    }
                    XMLUtil.validateQualifiedName(string);
                    this.objValue = null;
                    break;
                }
                default: {
                    throw new XSDException(24507, string, string2);
                }
            }
        }
        catch (Exception exception) {
            throw new XSDException(24507, string, string2);
        }
    }

    public void setQNameValue(String string, String string2, String string3) {
        this.lexicalValue = string;
        this.objValue = new QName(string2, string3);
    }

    protected void copyDataValue(XSDDataValue xSDDataValue) {
        this.basicType = xSDDataValue.basicType;
        this.booleanValue = xSDDataValue.booleanValue;
        this.doubleValue = xSDDataValue.doubleValue;
        this.intValue = xSDDataValue.intValue;
        this.lexicalValue = xSDDataValue.lexicalValue;
        this.objValue = xSDDataValue.objValue != null ? (xSDDataValue.objValue instanceof GregorianCalendar ? ((GregorianCalendar)xSDDataValue.objValue).clone() : xSDDataValue.objValue) : null;
    }

    private String parseHexBinary(String string) throws XSDException {
        int n2 = string.length();
        if ((n2 & 1) != 0) {
            throw new XSDException();
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') continue;
            if (c2 >= 'a' && c2 <= 'f') {
                cArray[i2] = Character.toUpperCase(c2);
                continue;
            }
            throw new XSDException();
        }
        return new String(cArray);
    }

    private String parseBase64Binary(String string) throws XSDException {
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        this.intValue = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isSpace(c2)) continue;
            if (n3 == 0 && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'z' || c2 == '/' || c2 == '+')) {
                cArray[n4] = c2;
                ++n4;
                ++this.intValue;
                continue;
            }
            if (n3 < 2 && c2 == '=') {
                cArray[n4] = c2;
                ++n4;
                ++this.intValue;
                ++n3;
                continue;
            }
            throw new XSDException();
        }
        if (this.intValue % 4 != 0) {
            throw new XSDException();
        }
        this.intValue = this.intValue * 3 / 4 - n3;
        return new String(cArray, 0, n4);
    }

    int getBasicType() {
        return this.basicType;
    }

    public int getLength() throws XSDException {
        switch (this.basicType) {
            case 1: 
            case 18: {
                return this.lexicalValue.length();
            }
            case 15: {
                return this.lexicalValue.length() / 2;
            }
            case 16: {
                return this.intValue;
            }
            case 17: 
            case 19: {
                return this.lexicalValue.length();
            }
        }
        throw new XSDException(24507, "");
    }

    public int getPrecision() throws XSDException {
        int n2;
        if (this.basicType != 5) {
            throw new XSDException(24000, "");
        }
        int n3 = this.lexicalValue.length() - 1;
        int n4 = this.lexicalValue.indexOf(46);
        if (n4 >= 0) {
            while (this.lexicalValue.charAt(n3) == '0') {
                --n3;
            }
        }
        if (this.lexicalValue.charAt(n2 = 0) == '-') {
            ++n2;
        }
        while (n2 < n3 && this.lexicalValue.charAt(n2) == '0') {
            ++n2;
        }
        if (n2 >= n3) {
            return 1;
        }
        if (n4 > 0) {
            return n3 - n2;
        }
        return n3 + 1 - n2;
    }

    public int getScale() throws XSDException {
        if (this.basicType != 5) {
            throw new XSDException(24000, "");
        }
        int n2 = this.lexicalValue.length();
        int n3 = this.lexicalValue.indexOf(46);
        if (n3 >= 0) {
            for (int i2 = n2 - 1; i2 > n3; --i2) {
                if (this.lexicalValue.charAt(i2) == '0') continue;
                return i2 - n3;
            }
        }
        return 0;
    }

    public String getEncoding() {
        return "";
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    String getCanonicalValue() {
        switch (this.basicType) {
            case 0: 
            case 1: {
                return this.lexicalValue;
            }
            case 2: {
                if (this.booleanValue) {
                    return _true;
                }
                return _false;
            }
            case 3: {
                return Float.toString((float)this.doubleValue);
            }
            case 4: {
                return Double.toString(this.doubleValue);
            }
            case 5: {
                if (this.booleanValue) {
                    int n2;
                    String string = this.objValue.toString();
                    int n3 = string.indexOf(46);
                    if (n3 < 0) {
                        return string;
                    }
                    for (n2 = string.length() - 1; n2 > n3 && string.charAt(n2) == '0'; --n2) {
                    }
                    if (n2 == n3) {
                        --n2;
                    }
                    if (n2 == string.length() - 1) {
                        return string;
                    }
                    return string.substring(0, n2 + 1);
                }
                return Integer.toString(this.intValue);
            }
        }
        return this.lexicalValue;
    }

    public int compareVal(XSDDataValue xSDDataValue, int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                int n3 = this.lexicalValue.compareTo(xSDDataValue.lexicalValue);
                return n3 > 0 ? 1 : (n3 == 0 ? 0 : -1);
            }
            case 2: {
                if (this.booleanValue == xSDDataValue.booleanValue) {
                    return 0;
                }
                if (!this.booleanValue && xSDDataValue.booleanValue) {
                    return -1;
                }
                return 1;
            }
            case 3: 
            case 4: {
                if (this.doubleValue > xSDDataValue.doubleValue) {
                    return 1;
                }
                if (this.doubleValue < xSDDataValue.doubleValue) {
                    return -1;
                }
                if (this.doubleValue == xSDDataValue.doubleValue) {
                    return 0;
                }
                return 2;
            }
            case 5: {
                if (!this.booleanValue) {
                    if (!xSDDataValue.booleanValue) {
                        if (this.intValue == xSDDataValue.intValue) {
                            return 0;
                        }
                        if (this.intValue > xSDDataValue.intValue) {
                            return 1;
                        }
                        return -1;
                    }
                    return new BigDecimal(this.intValue).compareTo((BigDecimal)xSDDataValue.objValue);
                }
                if (xSDDataValue.booleanValue) {
                    return ((BigDecimal)this.objValue).compareTo((BigDecimal)xSDDataValue.objValue);
                }
                return ((BigDecimal)this.objValue).compareTo(new BigDecimal(xSDDataValue.intValue));
            }
            case 6: {
                if (this.intValue > xSDDataValue.intValue) {
                    if (this.doubleValue >= xSDDataValue.doubleValue) {
                        return 1;
                    }
                    return this.compareDuration(this.intValue - xSDDataValue.intValue, xSDDataValue.doubleValue - this.doubleValue);
                }
                if (this.intValue == xSDDataValue.intValue) {
                    if (this.doubleValue > xSDDataValue.doubleValue) {
                        return 1;
                    }
                    if (this.doubleValue == xSDDataValue.doubleValue) {
                        return 0;
                    }
                    return -1;
                }
                if (this.doubleValue <= xSDDataValue.doubleValue) {
                    return -1;
                }
                return -1 * this.compareDuration(xSDDataValue.intValue - this.intValue, this.doubleValue - xSDDataValue.doubleValue);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                GregorianCalendar gregorianCalendar2 = (GregorianCalendar)xSDDataValue.objValue;
                if (this.booleanValue != xSDDataValue.booleanValue) {
                    long l2 = gregorianCalendar.getTimeInMillis();
                    long l3 = gregorianCalendar2.getTimeInMillis();
                    if (this.booleanValue) {
                        if (l2 < l3 - 50400000L) {
                            return -1;
                        }
                        if (l2 > l3 + 50400000L) {
                            return 1;
                        }
                        return 2;
                    }
                    if (l2 + 50400000L < l3) {
                        return -1;
                    }
                    if (l2 - 50400000L > l3) {
                        return 1;
                    }
                    return 2;
                }
                if (gregorianCalendar.after(gregorianCalendar2)) {
                    return 1;
                }
                if (gregorianCalendar2.after(gregorianCalendar)) {
                    return -1;
                }
                return 0;
            }
            case 15: 
            case 16: 
            case 17: {
                if (this.lexicalValue == xSDDataValue.lexicalValue) {
                    return 0;
                }
                return 1;
            }
            case 18: 
            case 19: {
                if (this.objValue == null || xSDDataValue.objValue == null) {
                    return 2;
                }
                if (((QName)this.objValue).equals((QName)xSDDataValue.objValue)) {
                    return 0;
                }
                return -1;
            }
        }
        return 2;
    }

    public int compareTo(XSDDataValue xSDDataValue) throws XSDException {
        if (this.basicType != xSDDataValue.basicType) {
            throw new XSDException(24507, "01");
        }
        switch (this.basicType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return this.compareVal(xSDDataValue, this.basicType);
            }
        }
        throw new XSDException(24000, "01");
    }

    /*
     * Unable to fully structure code
     */
    private void parseTimeInstant(String var1_1) throws XSDException {
        block43: {
            block45: {
                block44: {
                    var2_2 = 0;
                    var3_3 = var1_1.length();
                    var5_4 = 0;
                    var7_5 = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
                    this.objValue = var7_5;
                    var7_5.setLenient(false);
                    var8_6 = XSDDataValue.sTypes[this.basicType];
                    var9_7 = false;
                    if (this.basicType == 8) break block43;
                    if (this.basicType != 9 && this.basicType != 7 && this.basicType != 11 && this.basicType != 10) break block44;
                    var5_4 = var1_1.indexOf(45);
                    if (var5_4 == 0) {
                        var7_5.set(0, 0);
                        var2_2 = 1;
                    } else {
                        var7_5.set(0, 1);
                    }
                    var5_4 = var1_1.indexOf(45, var2_2);
                    if (var5_4 < 0) {
                        var5_4 = var1_1.indexOf(84);
                    }
                    if (var5_4 < 0) {
                        var5_4 = var1_1.indexOf(90);
                    }
                    if (var5_4 < 0) {
                        var5_4 = var1_1.indexOf(43);
                    }
                    if (var5_4 < 0) {
                        var5_4 = var3_3;
                    }
                    if ((var4_8 = Integer.parseInt(var1_1.substring(var2_2, var5_4))) == 0 || var5_4 - var2_2 < 4 || var4_8 < 10000 && var5_4 - var2_2 != 4) {
                        throw new XSDException(24507, var1_1, var8_6);
                    }
                    var7_5.set(1, var4_8);
                    var2_2 = var5_4 + 1;
                    if (this.basicType != 11) break block45;
                    break block43;
                }
                if (var1_1.charAt(0) != '-' || var1_1.charAt(1) != '-') {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var2_2 = this.basicType != 14 ? 2 : 3;
            }
            if (this.basicType != 14) {
                var5_4 = var2_2 + 2;
                var4_8 = Integer.parseInt(var1_1.substring(var2_2, var5_4));
                if (var4_8 <= 0 || var4_8 > 12) {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var7_5.set(2, var4_8 - 1);
                var2_2 = var5_4 + 1;
                if (this.basicType == 12) {
                    if (var5_4 < var3_3 && var1_1.charAt(var5_4) == '-' && var1_1.charAt(var2_2++) == '-') {
                        var5_4 = var2_2;
                    }
                } else if (this.basicType != 10) {
                    if (var1_1.charAt(var5_4) != '-') {
                        throw new XSDException(24507, var1_1, var8_6);
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 3 sources

            {
                if ((var4_8 = Integer.parseInt(var1_1.substring(var2_2, var5_4 = var2_2 + 2))) < 1 || var4_8 > var7_5.getActualMaximum(5)) {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var7_5.set(5, var4_8);
                var2_2 = var5_4 + 1;
            }
        }
        if (this.basicType == 8 || this.basicType == 7) {
            if (this.basicType != 8 && var1_1.charAt(var5_4) != 'T') {
                throw new XSDException(24507, var1_1, var8_6);
            }
            var5_4 = var2_2 + 2;
            var4_8 = Integer.parseInt(var1_1.substring(var2_2, var5_4));
            if (var4_8 < 0 || var4_8 > 24) {
                throw new XSDException(24507, var1_1, var8_6);
            }
            if (var4_8 == 24) {
                var4_8 = 0;
                var9_7 = true;
            }
            var7_5.set(11, var4_8);
            if (var4_8 >= 12) {
                var7_5.set(10, var4_8 - 12);
                var7_5.set(9, 1);
            } else {
                var7_5.set(10, var4_8);
                var7_5.set(9, 0);
            }
            var2_2 = var5_4 + 1;
            var5_4 = var1_1.indexOf(58, var2_2);
            var4_8 = Integer.parseInt(var1_1.substring(var2_2, var5_4));
            if (var5_4 - var2_2 != 2 || var4_8 < 0 || var4_8 > 59 || var9_7 && var4_8 != 0) {
                throw new XSDException(24507, var1_1, var8_6);
            }
            var7_5.set(12, var4_8);
            var2_2 = var5_4 + 1;
            var5_4 = var2_2 + 2;
            var4_8 = Integer.parseInt(var1_1.substring(var2_2, var5_4));
            if (var5_4 < var3_3 && (var10_9 = var1_1.charAt(var5_4)) != '.' && var10_9 != 'Z' && var10_9 != '+' && var10_9 != '-') {
                throw new XSDException(24507, var1_1, var8_6);
            }
            var5_4 = var1_1.indexOf(90, var2_2);
            if (var5_4 < 0) {
                var5_4 = var1_1.indexOf(45, var2_2);
            }
            if (var5_4 < 0) {
                var5_4 = var1_1.indexOf(43, var2_2);
            }
            if (var5_4 < 0) {
                var5_4 = var3_3;
            }
            if (var1_1.charAt(var3_3 - 1) == '.') {
                throw new XSDException(24507, var1_1, var8_6);
            }
            var10_10 = new BigDecimal(var1_1.substring(var2_2, var5_4));
            var7_5.set(13, var10_10.intValue());
            var11_12 = var10_10.movePointRight(3).intValue();
            if (var11_12 < 0 || var11_12 > 60000 || var9_7 && var11_12 != 0) {
                throw new XSDException(24507, var1_1, var8_6);
            }
            var7_5.set(14, var11_12 % 1000);
        }
        if (var5_4 < var3_3) {
            var10_11 = var1_1.charAt(var5_4);
            ++var5_4;
            this.booleanValue = true;
            if (var10_11 != 'Z') {
                var11_12 = 0;
                if (var10_11 == '+') {
                    var11_12 = 1;
                } else if (var10_11 != '-') {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var2_2 = var5_4;
                var5_4 = var2_2 + 2;
                var12_13 = Integer.parseInt(var1_1.substring(var2_2, var5_4));
                if (var1_1.charAt(var5_4) != ':') {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var2_2 = var5_4 + 1;
                var5_4 = var2_2 + 2;
                var13_14 = Integer.parseInt(var1_1.substring(var2_2, var5_4));
                if (var5_4 < var3_3) {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                if ((double)var12_13 + (double)var13_14 / 60.0 > 14.0 || (double)var12_13 - (double)var13_14 / 60.0 < -14.0) {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                if (var13_14 < 0 || var13_14 > 59) {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var14_15 = var11_12 != 0 ? new SimpleTimeZone(var13_14 * 60000, "") : new SimpleTimeZone((var13_14 += var12_13 * 60) * -60000, "");
                var7_5.setTimeZone(var14_15);
            } else {
                if (var5_4 < var3_3) {
                    throw new XSDException(24507, var1_1, var8_6);
                }
                var7_5.setTimeZone(XSDDataValue.UTC);
            }
        } else {
            var7_5.setTimeZone(XSDDataValue.UTC);
        }
        if (var9_7 && this.basicType == 7) {
            var7_5.add(5, 1);
        }
        var7_5.getTime();
    }

    private void parseTimeDuration(String string) throws XSDException {
        char c2;
        int n2 = 0;
        float f2 = 0.0f;
        int n3 = 1;
        String string2 = sTypes[this.basicType];
        if (string.charAt(n2) == '-') {
            n3 = -1;
        }
        int n4 = ++n2;
        ++n2;
        if (string.charAt(n4) != 'P') {
            throw new XSDException(24507, string, string2);
        }
        if (n2 == string.length()) {
            throw new XSDException(24507, string, string2);
        }
        int n5 = string.indexOf(89, n2);
        if (n5 >= 0) {
            c2 = string.charAt(n2);
            if (c2 < '0' || c2 > '9') {
                throw new XSDException(24507, string, string2);
            }
            this.intValue = Integer.parseInt(string.substring(n2, n5)) * 12;
            n2 = n5 + 1;
        }
        n5 = string.indexOf(77, n2);
        int n6 = string.indexOf(84, n2);
        if (n6 > 0 && n5 > n6) {
            n5 = -1;
        }
        n6 = string.length();
        if (n5 >= 0 && f2 == 0.0f) {
            this.intValue += Integer.parseInt(string.substring(n2, n5));
            c2 = string.charAt(n2);
            if (c2 < '0' || c2 > '9') {
                throw new XSDException(24507, string, string2);
            }
            n2 = n5 + 1;
        }
        if ((n5 = string.indexOf(68, n2)) >= 0 && f2 == 0.0f) {
            c2 = string.charAt(n2);
            if (c2 < '0' || c2 > '9') {
                throw new XSDException(24507, string, string2);
            }
            this.doubleValue = (double)(Integer.parseInt(string.substring(n2, n5)) * 24) * 3600.0;
            n2 = n5 + 1;
        }
        if (n2 < n6 && string.charAt(n2) == 'T' && f2 == 0.0f) {
            if (++n2 == string.length()) {
                throw new XSDException(24507, string, string2);
            }
            n5 = string.indexOf(72, n2);
            if (n5 >= 0) {
                c2 = string.charAt(n2);
                if (c2 < '0' || c2 > '9') {
                    throw new XSDException(24507, string, string2);
                }
                this.doubleValue += (double)(Integer.parseInt(string.substring(n2, n5)) * 3600);
                n2 = n5 + 1;
            }
            if ((n5 = string.indexOf(77, n2)) > 0) {
                c2 = string.charAt(n2);
                if (c2 < '0' || c2 > '9') {
                    throw new XSDException(24507, string, string2);
                }
                this.doubleValue += (double)(Integer.parseInt(string.substring(n2, n5)) * 60);
                n2 = n5 + 1;
            }
            if ((n5 = string.indexOf(83, n2)) > 0 && f2 == 0.0f) {
                c2 = string.charAt(n2);
                if (c2 < '0' || c2 > '9') {
                    throw new XSDException(24507, string, string2);
                }
                c2 = string.charAt(n5 - 1);
                if (c2 < '0' || c2 > '9') {
                    throw new XSDException(24507, string, string2);
                }
                this.doubleValue += Double.parseDouble(string.substring(n2, n5));
                n2 = n5 + 1;
            }
        }
        if (n2 != n6) {
            throw new XSDException(24507, string, string2);
        }
        this.doubleValue *= (double)n3;
        this.intValue *= n3;
    }

    private int compareDuration(int n2, double d2) {
        int n3 = n2 / 12;
        int n4 = n3 * 365;
        int n5 = n3 * 366;
        if ((double)((n4 += minMonthDay[n2 % 12]) * 24 * 3600) > d2) {
            return 1;
        }
        if ((double)((n5 += maxMonthDay[n2 % 12]) * 24 * 3600) < d2) {
            return -1;
        }
        if (n4 == n5) {
            return 0;
        }
        return 2;
    }

    public Calendar getGregorianCalendar() {
        Calendar calendar = (Calendar)((Calendar)this.objValue).clone();
        return calendar;
    }

    public static GregorianCalendar normalizeCalendar(GregorianCalendar gregorianCalendar, int n2) {
        TimeZone timeZone = gregorianCalendar.getTimeZone();
        int n3 = timeZone.getRawOffset();
        switch (n2) {
            case 9: {
                if (n3 > 43200000 || n3 < -432000) {
                    GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), 0, 0, 0);
                    gregorianCalendar2.set(0, gregorianCalendar.get(0));
                    gregorianCalendar2.setTimeZone(timeZone);
                    return gregorianCalendar2;
                }
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                break;
            }
            case 8: {
                if (n3 > 43200000 || n3 < -432000) {
                    GregorianCalendar gregorianCalendar3 = new GregorianCalendar(2000, 0, 1, gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
                    gregorianCalendar3.setTimeZone(timeZone);
                    return gregorianCalendar3;
                }
                gregorianCalendar.set(0, 1);
                gregorianCalendar.set(1, 2000);
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(5, 1);
            }
        }
        return gregorianCalendar;
    }
}

