/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import oracle.xml.parser.v2.XMLByteReader;
import oracle.xml.parser.v2.XMLConstants;

class XMLCharReader
extends XMLByteReader {
    Reader reader;
    boolean fixedCoords;
    XMLByteReader prevReader;
    boolean lastCharNewLine;
    static final int[] CP037ToUTF8 = new int[]{-1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1, -1, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46, 60, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 45, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 95, 62, 63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 58, -1, -1, 34, 61, 34, -1, 97, 98, 99, 100, 101, 102, 103, 104, 105, -1, -1, -1, -1, -1, -1, -1, 106, 107, 108, 109, 110, 111, 112, 113, 114, -1, -1, -1, -1, -1, -1, -1, -1, 115, 116, 117, 118, 119, 120, 121, 122, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 73, -1, -1, -1, -1, -1, -1, -1, 74, 75, 76, 77, 78, 79, 80, 81, 82, -1, -1, -1, -1, -1, -1, -1, -1, 83, 84, 85, 86, 87, 88, 89, 90, -1, -1, -1, -1, -1, -1, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -1, -1, -1, -1, -1};

    XMLCharReader(Reader reader, String string, String string2) {
        this.reader = reader;
        this.sysId = string;
        this.pubId = string2;
    }

    XMLCharReader(String string, String string2, String string3) {
        super(string.length());
        this.sysId = string2;
        this.pubId = string3;
        this.charPos = 0;
        this.eofPos = this.endPos = string.length();
        string.getChars(0, this.endPos, this.charBuffer, 0);
        this.fixedCoords = true;
    }

    @Override
    void reset() {
        if (this.fixedCoords) {
            this.charPos = 0;
            this.eofPos = this.endPos;
        } else {
            super.reset();
        }
        this.lastCharNewLine = false;
    }

    void reset(String string) {
        this.reset();
        this.charPos = 0;
        this.eofPos = this.endPos = string.length();
        string.getChars(0, this.endPos, this.charBuffer, 0);
    }

    void setPrevReader(XMLByteReader xMLByteReader) {
        this.prevReader = xMLByteReader;
    }

    @Override
    int getLineNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getLineNumber();
        }
        return super.getLineNumber();
    }

    @Override
    int getColumnNumber() {
        if (this.fixedCoords) {
            return this.prevReader.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    @Override
    void close() throws IOException {
        if (this.reader != null && this.closeInput) {
            this.reader.close();
        }
        super.close();
    }

    @Override
    void fillByteBuffer() throws IOException {
    }

    @Override
    void fillBuffer() throws IOException {
        if (this.fixedCoords) {
            return;
        }
        int n2 = 0;
        int n3 = this.BUFSIZE - this.endPos;
        int n4 = 0;
        while (n3 > 0 && n2 != -1) {
            char c2;
            n2 = this.reader.read(this.charBuffer, this.endPos, n3);
            if (n2 == -1) continue;
            int n5 = this.endPos + n2 - 1;
            n4 = 0;
            int n6 = this.endPos;
            if (this.lastCharNewLine) {
                if (this.charBuffer[this.endPos] == '\n') {
                    ++n4;
                    ++n6;
                }
                this.lastCharNewLine = false;
            }
            if (n4 == 0) {
                while (n6 < n5) {
                    c2 = this.charBuffer[n6];
                    if (c2 == '\n' || c2 == '\r') {
                        this.setLineNumber(n6);
                        if (c2 == '\r' && this.charBuffer[n6 + 1] == '\n') {
                            this.charBuffer[n6] = 10;
                            ++n4;
                            n6 += 2;
                            break;
                        }
                        this.charBuffer[n6] = 10;
                    }
                    ++n6;
                }
            }
            while (n6 < n5) {
                c2 = this.charBuffer[n6];
                if (c2 == '\n' || c2 == '\r') {
                    this.setLineNumber(n6 - n4);
                    if (c2 == '\r' && this.charBuffer[n6 + 1] == '\n') {
                        this.charBuffer[n6 - n4] = 10;
                        ++n4;
                        ++n6;
                    } else {
                        this.charBuffer[n6 - n4] = 10;
                    }
                } else {
                    this.charBuffer[n6 - n4] = this.charBuffer[n6];
                }
                ++n6;
            }
            if (n6 == n5) {
                if (this.charBuffer[n6] == '\r') {
                    this.lastCharNewLine = true;
                    this.charBuffer[n6 - n4] = 10;
                } else {
                    this.charBuffer[n6 - n4] = this.charBuffer[n6];
                }
            }
            this.endPos += (n2 -= n4);
            n3 -= n2;
            this.charsRead += (long)n2;
        }
        if (n2 == -1) {
            this.setEOF(this.endPos);
        }
    }

    int fillXMLDecl(InputStream inputStream) throws IOException {
        this.in = inputStream;
        char[] cArray = XMLConstants.cPIEND;
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2 && (n4 = inputStream.read()) != -1) {
            n4 = CP037ToUTF8[n4];
            this.charBuffer[n5++] = (char)n4;
            if (n4 == cArray[n3]) {
                ++n3;
                continue;
            }
            n3 = 0;
        }
        if (n3 != n2) {
            return -1;
        }
        System.arraycopy(this.charBuffer, 0, this.charBuffer, this.BUFSIZE - n5, n5);
        this.charPos = this.BUFSIZE - n5;
        this.endPos = this.BUFSIZE;
        return this.charPos;
    }

    void setEncoding(String string) throws IOException {
        this.reader = new InputStreamReader(this.in, string);
    }
}

