/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNSNode;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNodeList
implements NodeList,
Serializable,
Cloneable {
    XMLNode parent;
    XMLNode[] nodeArray;
    int nodeCount;
    int flags;
    long cstate = 0L;
    static XMLNodeList EMPTY_NODELIST = new XMLNodeList();
    static final int LIVE_NODELIST = 65536;

    private native int xdbGetLength(long var1, long var3);

    private native long xdbGetChild(long var1, long var3, long var5);

    public XMLNodeList() {
        this.flags |= 1;
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[4];
    }

    public XMLNodeList(int n2) {
        this.flags |= 1;
        this.nodeCount = 0;
        this.nodeArray = new XMLNode[n2];
    }

    public XMLNodeList(XMLNSNode xMLNSNode) {
        this.parent = xMLNSNode;
        this.nodeArray = new XMLNode[4];
        switch (xMLNSNode.flags & 7) {
            case 1: 
            case 4: {
                this.flags |= 1;
                Node node = this.parent.getFirstChild();
                if (node instanceof XMLDeclPI) {
                    node = node.getNextSibling();
                }
                while (node != null) {
                    this.addNode(node);
                    node = node.getNextSibling();
                }
                break;
            }
            case 2: {
                this.flags |= 2;
            }
        }
        this.flags |= 0x10000;
    }

    void reset_cache() {
        if (this.parent == null) {
            return;
        }
        this.nodeCount = 0;
        Node node = this.parent.getFirstChild();
        if (node instanceof XMLDeclPI) {
            node = node.getNextSibling();
        }
        while (node != null) {
            this.addNode(node);
            node = node.getNextSibling();
        }
    }

    XMLNodeList(XMLDocument xMLDocument, long l2) {
        this.flags |= 2;
        this.cstate = l2;
        this.parent = xMLDocument;
    }

    public XMLNodeList(NodeList nodeList) {
        this.flags |= 1;
        this.nodeCount = nodeList.getLength();
        this.nodeArray = new XMLNode[this.nodeCount];
        for (int i2 = 0; i2 < this.nodeCount; ++i2) {
            this.nodeArray[i2] = (XMLNode)nodeList.item(i2);
        }
    }

    public void setDebugFlag() {
        this.flags |= 1;
    }

    @Override
    public int getLength() {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                return this.nodeCount;
            }
            case 2: {
                if ((this.flags & 0x10000) == 65536) {
                    this.cstate = this.parent.xdbGetChildNodes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                }
                if (this.cstate == 0L) break;
                return this.xdbGetLength(this.parent.xdbGetCtx(), this.cstate);
            }
        }
        return 0;
    }

    @Override
    public Node item(int n2) {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                if (n2 >= 0 && n2 < this.nodeCount) {
                    return this.nodeArray[n2];
                }
                return null;
            }
            case 2: {
                long l2;
                if ((this.flags & 0x10000) == 65536) {
                    this.cstate = this.parent.xdbGetChildNodes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                }
                if (this.cstate == 0L || (l2 = this.xdbGetChild(this.parent.xdbGetCtx(), this.cstate, n2)) == 0L) break;
                return this.parent.xdbGetNodeFromId(l2);
            }
        }
        return null;
    }

    void ensureCapacity() {
        if (this.nodeCount >= this.nodeArray.length) {
            XMLNode[] xMLNodeArray = this.nodeArray;
            this.nodeArray = new XMLNode[this.nodeArray.length * 2];
            System.arraycopy(xMLNodeArray, 0, this.nodeArray, 0, xMLNodeArray.length);
        }
    }

    public void addNode(Node node) {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                this.ensureCapacity();
                this.nodeArray[this.nodeCount] = (XMLNode)node;
                ++this.nodeCount;
                break;
            }
        }
    }
}

