/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.scalable.BinaryNav;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.IntArrayIndex;
import oracle.xml.scalable.LongArrayIndex;
import oracle.xml.scalable.ShortArrayIndex;

public abstract class BinaryIndex {
    BinaryStream stream;
    static final long SMALL = 32767L;
    static final long MEDIUM = Integer.MAX_VALUE;
    static final int MAX_LEVEL = 64;

    public BinaryNav getNavigator() {
        return new BinaryNav(this);
    }

    public static BinaryIndex buildIndex(InfosetReader infosetReader, long l2) throws Exception {
        BinaryIndex binaryIndex = null;
        binaryIndex = l2 < 32767L ? new ShortArrayIndex() : (l2 < Integer.MAX_VALUE ? new IntArrayIndex() : new LongArrayIndex());
        binaryIndex.setStream(infosetReader.getStream());
        binaryIndex.buildIndex(infosetReader);
        return binaryIndex;
    }

    public static BinaryIndex createIndex(int n2) {
        BinaryIndex binaryIndex = null;
        binaryIndex = (long)n2 < 32767L ? new ShortArrayIndex() : ((long)n2 < Integer.MAX_VALUE ? new IntArrayIndex() : new LongArrayIndex());
        return binaryIndex;
    }

    BinaryStream getStream() {
        return this.stream;
    }

    public void setStream(BinaryStream binaryStream) {
        this.stream = binaryStream;
    }

    void buildIndex(InfosetReader infosetReader) throws Exception {
    }

    public BinaryIndex enlargeIndex() {
        return this;
    }

    long getLocator(int n2, int n3) {
        return 0L;
    }

    int getChildStart(int n2, int n3) {
        return 0;
    }

    int getChildEnd(int n2, int n3) {
        return 0;
    }

    int getIndexDepth() {
        return 0;
    }

    public boolean startElement(long l2) {
        return false;
    }

    public void endElement() {
    }
}

