/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.comp.CXMLReader;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;

class LongArrayIndex
extends BinaryIndex {
    long[][] index = new long[64][];
    int[][] children = new int[64][];
    int[] length = new int[64];
    boolean[] child = new boolean[64];
    int depth = 0;
    int level = 0;
    static final int EMPTY_FLAG = Integer.MIN_VALUE;

    LongArrayIndex() {
    }

    @Override
    public final void buildIndex(InfosetReader infosetReader) throws Exception {
        int n2 = 0;
        ((CXMLReader)infosetReader).init();
        this.index[0] = new long[1];
        this.children[0] = new int[1];
        while (infosetReader.hasNext()) {
            infosetReader.next();
            int n3 = infosetReader.getEventType();
            switch (n3) {
                case 1: {
                    int n4;
                    this.write(infosetReader.offsetToLong(), n2);
                    this.child[n2] = false;
                    if (n2 > 0 && !this.child[n2 - 1]) {
                        n4 = this.length[n2];
                        this.writeChild(n4, n2 - 1);
                        this.child[n2 - 1] = true;
                    }
                    int n5 = n2++;
                    this.length[n5] = this.length[n5] + 1;
                    break;
                }
                case 2: {
                    int n4 = this.length[n2] | Integer.MIN_VALUE;
                    if (n4 == 0) {
                        n4 = -1;
                    }
                    if (--n2 < 0 || this.child[n2]) break;
                    this.writeChild(n4, n2);
                    this.child[n2] = true;
                    break;
                }
            }
        }
        long l2 = 0L;
        for (int i2 = 1; i2 < 64; ++i2) {
            Object[] objectArray;
            long[] lArray = this.index[i2];
            if (lArray == null) {
                this.depth = i2;
                break;
            }
            int n6 = this.length[i2];
            l2 += (long)this.length[i2];
            if (lArray.length - n6 > 1024) {
                objectArray = new long[n6];
                System.arraycopy(lArray, 0, objectArray, 0, n6);
                this.index[i2] = objectArray;
            }
            if ((objectArray = (Object[])this.children[i2]) == null || objectArray.length - n6 <= 1024) continue;
            int[] nArray = new int[n6];
            System.arraycopy(objectArray, 0, nArray, 0, n6);
            this.children[i2] = nArray;
        }
    }

    private void write(long l2, int n2) {
        int n3;
        long[] lArray = this.index[n2];
        if (lArray == null) {
            lArray = new long[1024];
            this.index[n2] = lArray;
        }
        if ((n3 = this.length[n2]) >= lArray.length) {
            long[] lArray2 = lArray;
            lArray = new long[n3 * 2];
            System.arraycopy(lArray2, 0, lArray, 0, lArray2.length);
            this.index[n2] = lArray;
        }
        lArray[n3] = l2;
    }

    private void writeChild(int n2, int n3) {
        int[] nArray = this.children[n3];
        if (nArray == null) {
            nArray = new int[1024];
            this.children[n3] = nArray;
        }
        int n4 = this.length[n3];
        if (--n4 >= nArray.length) {
            int[] nArray2 = nArray;
            nArray = new int[n4 * 2];
            System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
            this.children[n3] = nArray;
        }
        nArray[n4] = n2;
    }

    @Override
    long getLocator(int n2, int n3) {
        return this.index[n2][n3];
    }

    @Override
    int getChildStart(int n2, int n3) {
        int n4 = this.children[n2][n3];
        if (n4 < 0) {
            return -1;
        }
        return n4 & 0xFFFFFFFF;
    }

    @Override
    int getChildEnd(int n2, int n3) {
        if (++n3 >= this.length[n2]) {
            return this.length[n2 + 1];
        }
        int n4 = this.children[n2][n3] & Integer.MAX_VALUE;
        return n4;
    }

    @Override
    int getIndexDepth() {
        return this.depth;
    }
}

