/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

public class OraURIUtil {
    private static final int IPV4LENGTH = 4;
    private static final int IPV6LENGTH = 16;
    private static final int IPV6V4LENGTH = 12;

    public static byte[] parseIPv4ToBytes(String string) {
        char c2;
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (n2 == 4) {
                return null;
            }
            c2 = cArray[i2];
            if (c2 != '.' && (c2 < '0' || c2 > '9')) {
                return null;
            }
            if (Character.isDigit(c2)) {
                if ((n3 = (n3 & 0xFF) * 10 + (Character.digit(c2, 10) & 0xFF)) > 255) {
                    return null;
                }
            } else if (c2 == '.') {
                byArray[n2++] = (byte)(n3 & 0xFF);
                n3 = 0;
            }
            if (i2 != cArray.length - 1) continue;
            byArray[n2] = (byte)(n3 & 0xFF);
        }
        if (n2 == 3) {
            return byArray;
        }
        byte[] byArray2 = new byte[4];
        c2 = '\u0003';
        for (int i3 = n2; i3 >= 0; --i3) {
            byArray2[c2--] = byArray[i3];
        }
        return byArray2;
    }

    public static byte[] parseIPv6ToBytes(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        byte[] byArray = new byte[16];
        char[] cArray = new char[8];
        char[] cArray2 = string.toCharArray();
        int n2 = cArray2.length;
        if (n2 == 2 && cArray2[0] == ':' && cArray2[1] == ':') {
            return byArray;
        }
        if (n2 >= 2 && cArray2[0] == ':' && cArray2[1] != ':') {
            return null;
        }
        if (n2 >= 3 && string.indexOf("::") != string.lastIndexOf("::")) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray2[i2];
            if (!(c2 == '.' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 == ':')) {
                return null;
            }
            int n6 = Character.digit(c2, 16);
            if (n6 != -1) {
                n4 <<= 4;
                if ((n4 |= n6) > 65535) {
                    return null;
                }
            } else if (c2 == ':') {
                if (i2 == 0 || i2 == 1) {
                    n5 = 0;
                } else if (cArray2[i2 - 1] == ':') {
                    n5 = n3;
                } else {
                    cArray[n3++] = (char)(n4 & 0xFFFF);
                    n4 = 0;
                }
            } else if (c2 == '.') {
                int n7 = string.lastIndexOf(58);
                if (i2 < n7) {
                    return null;
                }
                String string2 = string.substring(n7 + 1);
                if (OraURIUtil.countcharnum(string2, '.') != 3) {
                    return null;
                }
                byte[] byArray2 = OraURIUtil.parseIPv4ToBytes(string2);
                if (byArray2 == null) {
                    return null;
                }
                if (n5 != -1) {
                    cArray = OraURIUtil.replacedotdot(cArray, 6, n5, n3);
                }
                byArray = OraURIUtil.chars2bytes(cArray);
                byArray = OraURIUtil.addIPv4ToIPv6(byArray, 12, byArray2);
                return byArray;
            }
            if (i2 != n2 - 1) continue;
            if (n5 == -1 && n3 != 7) {
                return null;
            }
            if (c2 != ':') {
                cArray[n3] = (char)(n4 & 0xFFFF);
                ++n3;
            }
            if (n5 == -1) continue;
            cArray = OraURIUtil.replacedotdot(cArray, 8, n5, n3);
        }
        byArray = OraURIUtil.chars2bytes(cArray);
        return byArray;
    }

    private static char[] replacedotdot(char[] cArray, int n2, int n3, int n4) {
        int n5;
        char[] cArray2 = new char[n2];
        int n6 = n2 - n4;
        for (n5 = 0; n5 < n3; ++n5) {
            cArray2[n5] = cArray[n5];
        }
        for (n5 = n3; n5 < n3 + n6; ++n5) {
            cArray2[n5] = '\u0000';
        }
        for (n5 = n3 + n6; n5 < n2; ++n5) {
            cArray2[n5] = cArray[n5 - n6];
        }
        return cArray2;
    }

    private static byte[] chars2bytes(char[] cArray) {
        int n2 = cArray.length;
        byte[] byArray = new byte[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2 * 2] = (byte)(cArray[i2] >> 8 & 0xFF);
            byArray[i2 * 2 + 1] = (byte)(cArray[i2] & 0xFF);
        }
        return byArray;
    }

    private static int countcharnum(String string, char c2) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != c2) continue;
            ++n2;
        }
        return n2;
    }

    private static byte[] addIPv4ToIPv6(byte[] byArray, int n2, byte[] byArray2) {
        int n3;
        int n4 = byArray2.length;
        byte[] byArray3 = new byte[n2 + n4];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray3[n3] = byArray[n3];
        }
        for (n3 = n2; n3 < n2 + n4; ++n3) {
            byArray3[n3] = byArray2[n3 - n2];
        }
        return byArray3;
    }
}

