/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.util.XMLUtil;
import org.xml.sax.Locator;

public class XMLError
implements XMLConstants {
    private ResourceBundle messages;
    protected int[] line;
    protected int[] col;
    protected int[] types;
    protected int[] errid;
    protected int[] handle;
    protected String[] mesg;
    protected String[] sysId;
    protected String[] pubId;
    protected Exception[] exp;
    protected String[] type;
    protected Object[] relatedData;
    protected boolean strictErrorChecking = true;
    int nerrors = 0;
    private int nfatals = 0;
    private int firsterr = -1;
    private int lasterr = -1;
    private int nexceptions = 0;
    private boolean warning = false;
    private boolean nerrors_stackfull = false;
    private boolean flushed = false;
    private Locator locator;
    protected Exception lastExp;
    private Writer out;
    protected Object lastData;
    protected String lastType;
    private char[] errID = new char[]{'X', 'D', 'K', '-', '0', '0', '0', '0', '0'};
    private static final int ERRIDLEN = 9;
    private static final String eFilename = "oracle.xml.mesg.XMLResourceBundle";
    private static final int FATAL_ERROR_ID = 20000;
    private static final int ERROR_ID = 20001;
    private static final int WARNING_ID = 20002;
    private static final HashMap xpathfo_err_mesg_ids = new HashMap(43);

    public void reset() {
        this.lastExp = null;
        this.nerrors = 0;
        this.nfatals = 0;
        this.firsterr = -1;
        this.lasterr = -1;
        this.flushed = false;
        this.nerrors_stackfull = false;
        this.nexceptions = 0;
    }

    public void resetLineColInfo() {
        if (this.nerrors > 0 && !this.nerrors_stackfull) {
            this.line[this.nerrors - 1] = 0;
            this.col[this.nerrors - 1] = 0;
        }
    }

    public void setErrorStream(OutputStream outputStream) {
        this.out = new OutputStreamWriter(outputStream);
    }

    public void setErrorStream(OutputStream outputStream, String string) throws IOException {
        this.out = new OutputStreamWriter(outputStream, string);
    }

    public void setErrorStream(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void showWarnings(boolean bl) {
        this.warning = bl;
    }

    public void setLocale(Locale locale) {
        this.messages = ResourceBundle.getBundle(eFilename, locale);
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public void setException(Exception exception) {
        this.lastExp = exception;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public int getFirstError() {
        return this.firsterr;
    }

    public int getNumMessages() {
        return this.nerrors;
    }

    public final int getNumFatalMessages() {
        return this.nfatals;
    }

    public final int getNumExceptions() {
        return this.nexceptions;
    }

    public String getMessage(int n2) {
        return this.mesg[n2];
    }

    public int getLineNumber(int n2) {
        return this.line[n2];
    }

    public int getColumnNumber(int n2) {
        return this.col[n2];
    }

    public String getSystemId(int n2) {
        return this.sysId[n2];
    }

    public String getPublicId(int n2) {
        return this.pubId[n2];
    }

    public Exception getException(int n2) {
        return this.exp[n2];
    }

    public int getMessageId(int n2) {
        return this.errid[n2];
    }

    public int getMessageType(int n2) {
        return this.types[n2];
    }

    public void error(int n2, int n3, String string) {
        if (this.mesg == null) {
            this.init();
        }
        if (this.nerrors == 100) {
            this.nerrors_stackfull = true;
            return;
        }
        if (n3 == 2) {
            if (!this.warning) {
                return;
            }
            if (this.lasterr == -1 && this.nerrors == 99) {
                return;
            }
        } else {
            if (this.firsterr == -1) {
                this.firsterr = this.nerrors;
            }
            this.lasterr = this.nerrors;
        }
        this.type[this.nerrors] = this.lastType;
        this.exp[this.nerrors] = this.lastExp;
        this.relatedData[this.nerrors] = this.lastData;
        if (this.locator != null) {
            this.line[this.nerrors] = this.locator.getLineNumber();
            this.col[this.nerrors] = this.locator.getColumnNumber();
            this.pubId[this.nerrors] = this.locator.getPublicId();
            this.sysId[this.nerrors] = this.locator.getSystemId();
        }
        this.mesg[this.nerrors] = string;
        this.errid[this.nerrors] = n2;
        this.types[this.nerrors] = n3;
        this.exp[this.nerrors] = this.lastExp;
        this.lastExp = null;
        ++this.nerrors;
        if (n3 == 0) {
            ++this.nfatals;
            ++this.nexceptions;
        } else if (n3 == 1) {
            ++this.nexceptions;
        }
    }

    public void error0(int n2, int n3) {
        this.error(n2, n3, this.getMessage0(n2));
    }

    public void error1(int n2, int n3, String string) {
        this.error(n2, n3, this.getMessage1(n2, string));
    }

    public void error2(int n2, int n3, String string, String string2) {
        this.error(n2, n3, this.getMessage2(n2, string, string2));
    }

    public void error3(int n2, int n3, String string, String string2, String string3) {
        this.error(n2, n3, this.getMessage3(n2, string, string2, string3));
    }

    public void error(int n2, int n3, String[] stringArray) {
        this.error(n2, n3, this.getMessage(n2, stringArray));
    }

    public void flushErrorStream() throws IOException {
        if (this.nerrors == 0 || this.flushed) {
            return;
        }
        this.flushed = true;
        if (this.out != null) {
            String string = XMLUtil.getProperty("line.separator");
            for (int i2 = 0; i2 < this.nerrors; ++i2) {
                this.out.write(string);
                this.out.write(this.formatErrorMesg(i2));
            }
            this.out.write(string);
            this.out.flush();
        }
    }

    public void printErrorListener() throws IOException {
        if (this.nerrors == 0) {
            return;
        }
        this.flushed = true;
        if (this.out != null) {
            String string = XMLUtil.getProperty("line.separator");
            for (int i2 = 0; i2 < this.nerrors; ++i2) {
                this.out.write(string);
                this.out.write(this.formatErrorMesg(i2));
            }
            this.out.write(string);
            this.out.flush();
        }
    }

    public String getMessage0(int n2) {
        this.alloc();
        String string = this.idToString(n2);
        return this.messages.getString(string);
    }

    public String getMessage1(int n2, String string) {
        this.alloc();
        String string2 = this.idToString(n2);
        String[] stringArray = new String[]{string};
        String string3 = MessageFormat.format(this.messages.getString(string2), stringArray);
        return string3;
    }

    public String getMessage2(int n2, String string, String string2) {
        this.alloc();
        String string3 = this.idToString(n2);
        String[] stringArray = new String[]{string, string2};
        String string4 = MessageFormat.format(this.messages.getString(string3), stringArray);
        return string4;
    }

    public String getMessage3(int n2, String string, String string2, String string3) {
        this.alloc();
        String string4 = this.idToString(n2);
        String[] stringArray = new String[]{string, string2, string3};
        String string5 = MessageFormat.format(this.messages.getString(string4), stringArray);
        return string5;
    }

    public String getMessage4(int n2, String string, String string2, String string3, String string4) {
        this.alloc();
        String string5 = this.idToString(n2);
        String[] stringArray = new String[]{string, string2, string3, string4};
        String string6 = MessageFormat.format(this.messages.getString(string5), stringArray);
        return string6;
    }

    public String getMessage5(int n2, String string, String string2, String string3, String string4, String string5) {
        this.alloc();
        String string6 = this.idToString(n2);
        String[] stringArray = new String[]{string, string2, string3, string4, string5};
        String string7 = MessageFormat.format(this.messages.getString(string6), stringArray);
        return string7;
    }

    public String getMessage(int n2, String[] stringArray) {
        this.alloc();
        String string = this.idToString(n2);
        String string2 = MessageFormat.format(this.messages.getString(string), stringArray);
        return string2;
    }

    void alloc() {
        if (this.messages == null) {
            this.messages = ResourceBundle.getBundle(eFilename);
        }
    }

    String typeToString(int n2) {
        switch (n2) {
            case 0: {
                return this.getMessage0(20000);
            }
            case 1: {
                return this.getMessage0(20001);
            }
            case 2: {
                return this.getMessage0(20002);
            }
        }
        return "";
    }

    String idToString(int n2) {
        int n3;
        this.errID[0] = 88;
        this.errID[1] = 77;
        this.errID[2] = 76;
        if (n2 < 1000) {
            if (n2 < 400 || n2 >= 500) {
                n2 += 20000;
            }
        } else if (n2 >= 1000 && n2 < 2000) {
            n2 += 21000;
        }
        if (n2 < 20000) {
            if (n2 >= 2000) {
                this.errID[1] = 83;
                this.errID[2] = 68;
            }
            for (int i2 = 2; i2 < 6; ++i2) {
                this.errID[9 - i2] = (char)(n2 % 10 + 48);
                n2 /= 10;
            }
            return new String(this.errID, 0, 8);
        }
        if (n2 == 22000) {
            n3 = 0;
        }
        for (n3 = 1; n3 < 6; ++n3) {
            this.errID[9 - n3] = (char)(n2 % 10 + 48);
            n2 /= 10;
        }
        return new String(this.errID);
    }

    public String formatErrorMesg(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sysId[n2] != null) {
            stringBuffer.append(this.sysId[n2]);
        }
        if (this.line[n2] != 0 && this.col[n2] != 0 && this.line[n2] != -1 && this.col[n2] != -1) {
            stringBuffer.append("<Line " + this.line[n2] + ", Column " + this.col[n2] + ">");
            stringBuffer.append(": ");
        } else if (this.sysId[n2] != null) {
            stringBuffer.append(": ");
        }
        stringBuffer.append(this.idToString(this.errid[n2]) + ": (" + this.typeToString(this.types[n2]) + ") " + this.mesg[n2]);
        return stringBuffer.toString();
    }

    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public static String getXPathErrorID(String string) {
        return (String)xpathfo_err_mesg_ids.get(string);
    }

    private void init() {
        this.line = new int[101];
        this.col = new int[101];
        this.types = new int[101];
        this.errid = new int[101];
        this.handle = new int[101];
        this.mesg = new String[101];
        this.sysId = new String[101];
        this.pubId = new String[101];
        this.exp = new Exception[101];
        this.type = new String[101];
        this.relatedData = new Object[101];
    }

    static {
        xpathfo_err_mesg_ids.put("FOAR0001", "23007");
        xpathfo_err_mesg_ids.put("FOAR0002", "23008");
        xpathfo_err_mesg_ids.put("FOCA0001", "23009");
        xpathfo_err_mesg_ids.put("FOCA0002", "23010");
        xpathfo_err_mesg_ids.put("FOCA0003", "23011");
        xpathfo_err_mesg_ids.put("FOCA0004", "23012");
        xpathfo_err_mesg_ids.put("FOCA0005", "23013");
        xpathfo_err_mesg_ids.put("FOCH0001", "23014");
        xpathfo_err_mesg_ids.put("FOCH0002", "23015");
        xpathfo_err_mesg_ids.put("FOCH0003", "23016");
        xpathfo_err_mesg_ids.put("FOCH0004", "23017");
        xpathfo_err_mesg_ids.put("FODC0001", "23018");
        xpathfo_err_mesg_ids.put("FODC0002", "23019");
        xpathfo_err_mesg_ids.put("FODC0003", "23020");
        xpathfo_err_mesg_ids.put("FODC0004", "23021");
        xpathfo_err_mesg_ids.put("FODT0001", "23022");
        xpathfo_err_mesg_ids.put("FODT0002", "23023");
        xpathfo_err_mesg_ids.put("FONC0001", "23024");
        xpathfo_err_mesg_ids.put("FONS0002", "23025");
        xpathfo_err_mesg_ids.put("FONS0003", "23026");
        xpathfo_err_mesg_ids.put("FONS0004", "23027");
        xpathfo_err_mesg_ids.put("FONS0005", "23028");
        xpathfo_err_mesg_ids.put("FORG0001", "23029");
        xpathfo_err_mesg_ids.put("FORG0002", "23030");
        xpathfo_err_mesg_ids.put("FORG0003", "23031");
        xpathfo_err_mesg_ids.put("FORG0004", "23032");
        xpathfo_err_mesg_ids.put("FORG0005", "23033");
        xpathfo_err_mesg_ids.put("FORG0006", "23034");
        xpathfo_err_mesg_ids.put("FORG0007", "23035");
        xpathfo_err_mesg_ids.put("FORG0008", "23036");
        xpathfo_err_mesg_ids.put("FORG0009", "23037");
        xpathfo_err_mesg_ids.put("FORX0001", "23038");
        xpathfo_err_mesg_ids.put("FORX0002", "23039");
        xpathfo_err_mesg_ids.put("FORX0003", "23040");
        xpathfo_err_mesg_ids.put("FORX0004", "23041");
        xpathfo_err_mesg_ids.put("FOTY0001", "23042");
        xpathfo_err_mesg_ids.put("FOTY0011", "23043");
        xpathfo_err_mesg_ids.put("FOTY0012", "23044");
        xpathfo_err_mesg_ids.put("FOTY0013", "23045");
        xpathfo_err_mesg_ids.put("FOTY0014", "23046");
        xpathfo_err_mesg_ids.put("FORT0001", "23047");
        xpathfo_err_mesg_ids.put("FOTY0002", "23048");
        xpathfo_err_mesg_ids.put("FOTY0021", "23049");
    }
}

