/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.util.FastVector;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;

class IntersectExceptExpr
extends XSLExprBase {
    private FastVector opList;
    private FastVector exprList = new FastVector();

    IntersectExceptExpr() throws XSLException {
        super.setExprType(0x2200000);
        this.opList = new FastVector();
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        int n2 = xSLParseString.peekToken();
        XSLExprBase xSLExprBase = PathExpr.parse(xSLParseString);
        if (xSLParseString.peekToken() == 103) {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(226, 0);
            }
            IntersectExceptExpr intersectExceptExpr = new IntersectExceptExpr();
            intersectExceptExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            intersectExceptExpr.exprList.addElement(xSLExprBase);
            int n3 = xSLParseString.getOperator();
            intersectExceptExpr.opList.addElement(new Integer(n3));
            if (!xSLExprBase.mayBeExprType(0x200000)) {
                throw new XPathException(1038);
            }
            while (xSLParseString.peekToken(103)) {
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(226, 0);
                }
                n2 = xSLParseString.peekToken();
                xSLExprBase = PathExpr.parse(xSLParseString);
                if (!xSLExprBase.mayBeExprType(0x200000)) {
                    throw new XPathException(1038);
                }
                intersectExceptExpr.exprList.addElement(xSLExprBase);
                int n4 = xSLParseString.getOperator();
                intersectExceptExpr.opList.addElement(new Integer(n4));
                if (intersectExceptExpr.priority < xSLExprBase.priority) {
                    intersectExceptExpr.priority = xSLExprBase.priority;
                }
                if (xPathCompileEvents == null) continue;
                xPathCompileEvents.reportEventsWithIntParam(226, 1, n4, 0);
            }
            xSLExprBase = intersectExceptExpr;
            if (xSLParseString.isCachingExpr() && !intersectExceptExpr.canCacheExpr()) {
                intersectExceptExpr.cacheSubExpr();
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsWithIntParam(226, 1, n3, 0);
            }
        }
        return xSLExprBase;
    }

    @Override
    void cacheSubExpr() throws XQException {
        int n2 = this.exprList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(i2);
            if (!xSLExprBase.canCacheExpr()) continue;
            this.exprList.setElementAt(xSLExprBase.createCachedExpr(), i2);
        }
    }

    @Override
    boolean canCacheExpr() {
        int n2 = this.exprList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(i2);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(0);
        StringBuffer stringBuffer = new StringBuffer(xSLExprBase.getNormalizedExpr());
        int n2 = this.exprList.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            xSLExprBase = (XSLExprBase)this.exprList.elementAt(i2);
            stringBuffer.append((Integer)this.opList.elementAt(i2 - 1));
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        if (this.flag >= 0) {
            return this.flag;
        }
        this.flag = 0;
        int n2 = this.exprList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(i2);
            this.flag |= xSLExprBase.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        int n2 = this.exprList.size();
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(0);
        xSLExprBase.evaluate(xPathRuntimeContext);
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
        if (!xSLExprBase.isExprType(0x200000) && !xPathSequence.isNodeSequence()) {
            throw new XPathException(1038);
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            xSLExprBase = (XSLExprBase)this.exprList.elementAt(i2);
            xSLExprBase.evaluate(xPathRuntimeContext);
            XPathSequence xPathSequence2 = (XPathSequence)xPathRuntimeContext.popExprValue();
            if (!xSLExprBase.isExprType(0x200000) && !xPathSequence2.isNodeSequence()) {
                throw new XPathException(1038);
            }
            if ((Integer)this.opList.elementAt(i2 - 1) == 206) {
                XPathSequence.intersectSequence(xPathSequence, xPathSequence2);
                continue;
            }
            XPathSequence.exceptSequence(xPathSequence, xPathSequence2);
        }
    }

    @Override
    public void streamingEvaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        if (this.exprList.size() == 1) {
            ((XSLExprBase)this.exprList.elementAt(0)).streamingEvaluate(xPathRuntimeContext);
        }
    }
}

