/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.xpath.JXPath;
import oracle.xml.xpath.XPathFunctionImpl;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;

public class JXPathFactory
extends XPathFactory {
    private boolean secure;
    private XPathVariableResolver varResolver;
    private XPathFunctionResolver funcResolver;
    private boolean createNode;
    private boolean enableException;
    private boolean version20 = false;
    private boolean binIdx = false;
    private FNFunctionLibrary fnLibrary = FNFunctionLibrary.getInstance();

    @Override
    public boolean isObjectModelSupported(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        return string.equals("http://java.sun.com/jaxp/xpath/dom");
    }

    @Override
    public void setFeature(String string, boolean bl) throws XPathFactoryConfigurationException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            this.secure = bl;
        } else if (string.equals("CREATE_NODE")) {
            this.createNode = bl;
        } else if (string.equals("ENABLE_EXCEPTION")) {
            this.enableException = bl;
        } else if (string.equals("XML_PATH_LANGUAGE_20")) {
            this.version20 = bl;
        } else if (string.equals("http://xmlns.oracle.com/xdk/xpath/binary_index")) {
            this.binIdx = bl;
        } else {
            throw new XPathFactoryConfigurationException(string);
        }
    }

    @Override
    public boolean getFeature(String string) throws XPathFactoryConfigurationException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return this.secure;
        }
        if (string.equals("CREATE_NODE")) {
            return this.createNode;
        }
        if (string.equals("ENABLE_EXCEPTION")) {
            return this.enableException;
        }
        if (string.equals("XML_PATH_LANGUAGE_20")) {
            return this.version20;
        }
        if (string.equals("http://xmlns.oracle.com/xdk/xpath/binary_index")) {
            return this.binIdx;
        }
        throw new XPathFactoryConfigurationException(string);
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            throw new NullPointerException();
        }
        this.varResolver = xPathVariableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            throw new NullPointerException();
        }
        this.funcResolver = xPathFunctionResolver;
    }

    @Override
    public XPath newXPath() {
        JXPath jXPath = new JXPath(this.varResolver, this.funcResolver, this.secure);
        jXPath.setCreateNode(this.createNode);
        jXPath.setEnableException(this.enableException);
        jXPath.setVersion20(this.version20);
        jXPath.setBinIdxSupport(this.binIdx);
        return jXPath;
    }

    public XPathFunction resolveFunction(QName qName, int n2) {
        OXMLFunction oXMLFunction;
        String string;
        XPathFunction xPathFunction = null;
        if (this.funcResolver != null) {
            xPathFunction = this.funcResolver.resolveFunction(qName, n2);
        }
        if (xPathFunction == null && ((string = qName.getNamespaceURI()) == null || string.equals("") || string.equals("http://www.w3.org/2005/xpath-functions")) && (oXMLFunction = this.fnLibrary.getFunction(qName.getLocalPart(), n2)) != null) {
            xPathFunction = new XPathFunctionImpl(oXMLFunction, n2);
        }
        return xPathFunction;
    }
}

