/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.BinaryNav;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLCompatible;
import oracle.xml.xpath.BinarySequence;
import oracle.xml.xpath.JXPathContext;
import oracle.xml.xpath.StreamNodeSequence;
import oracle.xml.xpath.XMLPathTable;
import oracle.xml.xpath.XPathAxis;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathContextItemExpr;
import oracle.xml.xpath.XPathError;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathFilterExpr;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XPathVarReference;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLNodeSetExpr;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

public class PathExpr
extends XSLExprBase {
    private XSLExprBase filter;
    private boolean root = false;
    private boolean matchroot = false;
    private FastVector stepVector;
    private FastVector expandedStepVector;
    private String[] anchorName;
    private int valid = -1;
    int anchorType = -1;
    private boolean relative = false;

    private static FastVector clone(FastVector fastVector) {
        int n2 = fastVector.size();
        FastVector fastVector2 = new FastVector(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            XPathStep xPathStep = (XPathStep)fastVector.elementAt(i2);
            fastVector2.addElement(xPathStep);
        }
        return fastVector2;
    }

    PathExpr clone(boolean bl) {
        PathExpr pathExpr = new PathExpr();
        pathExpr.filter = this.filter;
        pathExpr.root = this.root;
        pathExpr.matchroot = this.matchroot;
        if (bl) {
            pathExpr.stepVector = PathExpr.clone(this.stepVector);
            pathExpr.expandedStepVector = PathExpr.clone(this.expandedStepVector);
        }
        pathExpr.anchorName = this.anchorName;
        pathExpr.anchorType = this.anchorType;
        super.clone(pathExpr, bl);
        return pathExpr;
    }

    void setRelative(boolean bl) {
        this.relative = bl;
    }

    boolean useRelative() {
        return this.relative;
    }

    PathExpr() {
    }

    PathExpr(XSLParseString xSLParseString, XSLExprBase xSLExprBase) throws XSLException, XQException {
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        int n2 = xSLParseString.getXSLTVersion();
        ArrayList arrayList = null;
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(113, 0);
        }
        this.stepVector = new FastVector();
        this.anchorName = new String[2];
        int n3 = xSLParseString.peekToken();
        int n4 = 5;
        boolean bl = false;
        super.setExprType(0x2200000);
        this.filter = xSLExprBase;
        if (this.filter != null) {
            n4 = n3;
            xSLParseString.nextToken();
        } else if (n3 == 5) {
            this.root = true;
            this.matchroot = true;
            n4 = 5;
            xSLParseString.nextToken();
            this.anchorType = 1;
            bl = true;
        } else if (n3 == 6) {
            this.root = true;
            n4 = 6;
            xSLParseString.nextToken();
        }
        if (xPathCompileEvents != null) {
            if (this.root) {
                xPathCompileEvents.reportEventsNoParam(101, 0);
            } else {
                xPathCompileEvents.reportEventsNoParam(243, 0);
                xPathCompileEvents.reportEventsNoParam(117, 0);
            }
        }
        XSLExprBase xSLExprBase2 = null;
        if (n2 == 20 && !xSLParseString.isPattern()) {
            xSLExprBase2 = XPathFilterExpr.parse(xSLParseString);
        }
        if (xSLExprBase2 == null) {
            xSLExprBase2 = XPathStep.parseAxisStep(xSLParseString, n4);
        }
        if (xPathCompileEvents != null && xSLExprBase2 instanceof XPathStep) {
            arrayList = xPathCompileEvents.addXPathStep((XPathStep)xSLExprBase2);
        }
        if (xSLExprBase2 == null) {
            if (!bl) {
                throw new XPathException(1013, new String(xSLParseString.getExprString()));
            }
            if (xPathCompileEvents != null) {
                if (this.root) {
                    xPathCompileEvents.reportEventsNoParam(101, 1);
                } else {
                    xPathCompileEvents.reportEventsNoParam(243, 1);
                    xPathCompileEvents.reportEventsNoParam(117, 1);
                }
                xPathCompileEvents.reportEventsNoParam(113, 1);
            }
            return;
        }
        if (xSLParseString.isPattern() && xSLExprBase2 instanceof XPathStep) {
            XPathStep xPathStep = (XPathStep)xSLExprBase2;
            if (!this.matchroot) {
                xPathStep.firstStep = true;
            }
            if (xPathStep.nodeType == 9 && xPathStep.defaultAxis) {
                xPathStep.axisClass = XPathAxis.getInstance(11);
            }
        }
        if (xSLExprBase2 instanceof XPathStep || n4 == 5) {
            this.stepVector.addElement(xSLExprBase2);
        } else {
            this.stepVector.addElement(XPathStep.DESC_SELF);
            if (!(xSLExprBase2 instanceof XPathContextItemExpr) || xSLExprBase2.predicates != null) {
                this.stepVector.addElement(xSLExprBase2);
            }
        }
        this.priority = this.filter != null || this.root ? 0.5f : xSLExprBase2.priority;
        n3 = xSLParseString.peekToken();
        while (n3 == 5 || n3 == 6) {
            n4 = n3;
            xSLParseString.nextToken();
            xSLExprBase2 = null;
            if (n2 == 20 && !xSLParseString.isPattern()) {
                xSLExprBase2 = XPathFilterExpr.parse(xSLParseString);
            }
            if (xSLExprBase2 == null) {
                xSLExprBase2 = XPathStep.parseAxisStep(xSLParseString, n4);
            }
            if (xSLExprBase2 == null) {
                throw new XPathException(1013, new String(xSLParseString.getExprString()));
            }
            if (xPathCompileEvents != null && xSLExprBase2 instanceof XPathStep) {
                arrayList = xPathCompileEvents.addXPathStep((XPathStep)xSLExprBase2);
            }
            if (xSLExprBase2 instanceof XPathStep || n4 == 5) {
                this.stepVector.addElement(xSLExprBase2);
            } else {
                this.stepVector.addElement(XPathStep.DESC_SELF);
                if (!(xSLExprBase2 instanceof XPathContextItemExpr) || xSLExprBase2.predicates != null) {
                    this.stepVector.addElement(xSLExprBase2);
                }
            }
            this.priority = 0.5f;
            n3 = xSLParseString.peekToken();
        }
        if (xSLExprBase2 instanceof XPathStep) {
            this.anchorType = ((XPathStep)xSLExprBase2).getAnchorType();
            ((XPathStep)xSLExprBase2).getAnchorName(this.anchorName);
        }
        if (xPathCompileEvents != null) {
            if (this.root) {
                xPathCompileEvents.reportEventsNoParam(101, 1);
            } else {
                xPathCompileEvents.reportEventsNoParam(243, 1);
                xPathCompileEvents.reportEventsNoParam(117, 1);
            }
            xPathCompileEvents.reportEventsNoParam(113, 1);
            xPathCompileEvents.reportEventsWithObjectParam(403, 2, this, arrayList, null);
        }
        boolean bl2 = false;
        if (this.filter != null && !(this.filter instanceof XPathContextItemExpr)) {
            bl2 = true;
        }
        if (this.stepVector != null) {
            int n5 = this.stepVector.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                xSLExprBase2 = (XSLExprBase)this.stepVector.elementAt(i2);
                if (xSLExprBase2 instanceof XPathStep) {
                    XPathStep xPathStep = (XPathStep)xSLExprBase2;
                    int n6 = xPathStep.getAxisType();
                    if (n6 == 0 || n6 == 1 || n6 == 4 || n6 == 5 || xPathStep.prevSeparator == 6) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl2 || n6 != 3) continue;
                    xPathStep.needMerge = true;
                    continue;
                }
                if (!(xSLExprBase2 instanceof XPathFilterExpr)) continue;
                bl2 = true;
            }
        }
    }

    void setStepVector(FastVector fastVector) {
        this.stepVector = fastVector;
    }

    FastVector getStepVector() {
        return this.stepVector;
    }

    void setExpandedStepVector(FastVector fastVector) {
        this.expandedStepVector = fastVector;
    }

    FastVector getExpandedStepVector() {
        return this.expandedStepVector;
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        Object object;
        XPathCompileEvents xPathCompileEvents;
        XSLExprBase xSLExprBase = XPathFilterExpr.parse(xSLParseString);
        XSLExprBase xSLExprBase2 = null;
        Object object2 = null;
        XSLNodeSetExpr xSLNodeSetExpr = null;
        if (xSLExprBase != null) {
            if ((xSLExprBase.exprType & 0xA00000) <= 0) {
                xSLExprBase.setPriority(0.5f);
                return xSLExprBase;
            }
            int n2 = xSLParseString.peekToken();
            if (n2 != 5 && n2 != 6) {
                return xSLExprBase;
            }
        }
        if ((xPathCompileEvents = xSLParseString.getXPathCompileEvents()) != null) {
            xPathCompileEvents.reportEventsNoParam(113, 0);
        }
        object2 = new PathExpr(xSLParseString, xSLExprBase);
        ((XSLExprBase)object2).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        XSLStylesheet xSLStylesheet = xSLParseString.getStylesheet();
        XMLPathTable xMLPathTable = null;
        FastVector fastVector = null;
        if (xSLStylesheet != null) {
            xMLPathTable = xSLStylesheet.getXMLPathTable();
        } else if (xSLParseString.nsr != null && xSLParseString.nsr instanceof JXPathContext) {
            xMLPathTable = ((JXPathContext)xSLParseString.nsr).getXMLPathTable();
        }
        if (xMLPathTable != null) {
            fastVector = PathExpr.clone(((PathExpr)object2).stepVector);
            xSLExprBase2 = xMLPathTable.getReplacePath((PathExpr)object2);
            xSLExprBase2.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            if (xSLExprBase2 instanceof PathExpr) {
                object = (PathExpr)xSLExprBase2;
                if (fastVector.equals(((PathExpr)object).getStepVector())) {
                    ((PathExpr)object2).expandedStepVector = ((PathExpr)object2).stepVector;
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(113, 1);
                    }
                    return object2;
                }
                object2 = object;
            } else if (xSLExprBase2 instanceof XSLNodeSetExpr) {
                xSLNodeSetExpr = (XSLNodeSetExpr)xSLExprBase2;
                object2 = null;
            }
        } else {
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(113, 1);
            }
            return object2;
        }
        object = xSLParseString.getXSLNode();
        if (object == null) {
            if (object2 != null) {
                ((PathExpr)object2).expandedStepVector = ((PathExpr)object2).stepVector;
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(113, 1);
                }
                return object2;
            }
            if (xSLNodeSetExpr != null) {
                int n3 = xSLNodeSetExpr.getExprVector().size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    PathExpr pathExpr = (PathExpr)xSLNodeSetExpr.getExprVector().elementAt(i2);
                    pathExpr.expandedStepVector = pathExpr.stepVector;
                }
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithBooleanParam(121, 1, true, false);
                }
                return xSLNodeSetExpr;
            }
        } else {
            XSLExprBase xSLExprBase3 = ((XSLNode)object).getParentCtxExpr();
            if (object2 != null) {
                PathExpr pathExpr = super.convertAbs2Rel(xSLExprBase3);
                if (pathExpr.useRelative()) {
                    pathExpr.expandedStepVector = pathExpr.stepVector;
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsNoParam(113, 1);
                    }
                    return pathExpr;
                }
                ((PathExpr)object2).expandedStepVector = ((PathExpr)object2).stepVector;
                ((PathExpr)object2).setStepVector(fastVector);
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(113, 1);
                }
                return object2;
            }
            if (xSLNodeSetExpr != null) {
                FastVector fastVector2 = xSLNodeSetExpr.getExprVector();
                for (int i3 = 0; i3 < fastVector2.size(); ++i3) {
                    PathExpr pathExpr = (PathExpr)fastVector2.elementAt(i3);
                    PathExpr pathExpr2 = pathExpr.convertAbs2Rel(xSLExprBase3);
                    if (pathExpr2.useRelative()) {
                        pathExpr2.expandedStepVector = pathExpr2.stepVector;
                        fastVector2.setElementAt(pathExpr2, i3);
                        continue;
                    }
                    pathExpr.expandedStepVector = pathExpr.stepVector;
                    pathExpr.setStepVector(fastVector);
                }
                xSLNodeSetExpr.setExprVector(fastVector2);
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithBooleanParam(121, 1, true, false);
                }
                return xSLNodeSetExpr;
            }
        }
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(113, 1);
        }
        return object2;
    }

    @Override
    public boolean isStreamable() {
        if (this.filter != null && !(this.filter instanceof XPathContextItemExpr)) {
            return false;
        }
        int n2 = this.stepVector.size();
        boolean bl = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(this.stepVector.elementAt(i2) instanceof XPathStep)) {
                return false;
            }
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i2);
            int n3 = xPathStep.getAxisType();
            int n4 = 0;
            XPathPredicate xPathPredicate = xPathStep.predicates;
            if (xPathPredicate != null) {
                n4 = xPathPredicate.checkPosLastFN();
            }
            if (xPathStep.prevSeparator == 6) {
                if (bl || n4 > 0) {
                    return false;
                }
                bl = true;
            }
            if (n3 != 3 && n3 != 2 && n3 != 11) {
                return false;
            }
            if ((n4 & 2) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArrayList getStepList() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.stepVector.size());
        for (int i2 = 0; i2 < this.stepVector.size(); ++i2) {
            arrayList.add(this.stepVector.elementAt(i2));
        }
        return arrayList;
    }

    @Override
    public int getAnchorType() {
        return this.anchorType;
    }

    @Override
    public void getAnchorName(String[] stringArray) {
        stringArray[0] = this.anchorName[0];
        stringArray[1] = this.anchorName[1];
    }

    @Override
    public void setEvaluationHints(String string, Object object) {
        XSLExprBase xSLExprBase;
        int n2 = this.stepVector.size();
        if (n2 != 0 && (xSLExprBase = (XSLExprBase)this.stepVector.elementAt(n2 - 1)) instanceof XPathStep) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(n2 - 1);
            xPathStep.setEvaluationHints(string, object);
        }
    }

    @Override
    int checkPosLastFN() {
        if (this.flag >= 0) {
            return this.flag;
        }
        this.flag = 0;
        if (this.filter != null) {
            this.flag |= this.filter.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.filter != null && this.filter.canCacheExpr()) {
            this.filter = this.filter.createCachedExpr();
        }
    }

    @Override
    public boolean isRelIndependent() {
        if (this.filter != null && !this.filter.isRelIndependent()) {
            return false;
        }
        int n2 = this.stepVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.stepVector.elementAt(i2);
            if (xSLExprBase.isRelIndependent()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean canCacheExpr() {
        if (this.filter != null || !this.root) {
            return false;
        }
        int n2 = this.stepVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.stepVector.elementAt(i2);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportIndex() {
        if (this.filter != null && !this.filter.supportIndex()) {
            return false;
        }
        int n2 = this.stepVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.stepVector.elementAt(i2);
            if (xSLExprBase.supportIndex()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.filter != null) {
            stringBuffer.append(this.filter.getNormalizedExpr());
        }
        int n2 = this.stepVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.stepVector.elementAt(i2);
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        XPathAxis xPathAxis;
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        if (xPathRuntimeContext.getCtxForm() == 2) {
            this.evaluateBinary(xPathRuntimeContext);
            return;
        }
        OXMLSequence oXMLSequence = null;
        XMLNode xMLNode = xPathRuntimeContext.getContextNode();
        int n2 = xPathRuntimeContext.getContextPosition();
        if (this.filter != null) {
            this.filter.evaluate(xPathRuntimeContext);
        } else {
            oXMLSequence = xPathRuntimeContext.pushExprValue();
            if (this.root) {
                XPathSequence.addNode(oXMLSequence, xPathRuntimeContext.getSrcRoot(xMLNode));
            } else {
                XPathSequence.addNode(oXMLSequence, xMLNode);
            }
        }
        int n3 = this.stepVector.size();
        XSLExprBase xSLExprBase = null;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object;
            xSLExprBase = (XSLExprBase)this.stepVector.elementAt(i2);
            if (xSLExprBase instanceof XPathStep) {
                xSLExprBase.evaluate(xPathRuntimeContext);
            } else {
                object = xPathRuntimeContext.peekExprValue();
                int n4 = 1;
                boolean bl = true;
                boolean bl2 = false;
                while (((OXMLSequence)object).next()) {
                    XPathSequence xPathSequence;
                    bl2 = true;
                    XMLNode xMLNode2 = XPathSequence.nextNode((OXMLSequence)object);
                    xPathRuntimeContext.setContextNode(xMLNode2);
                    xPathRuntimeContext.setContextPosition(n4);
                    xSLExprBase.evaluate(xPathRuntimeContext);
                    if (n4 == 1) {
                        xPathSequence = (XPathSequence)xPathRuntimeContext.peekExprValue();
                        bl = xPathSequence.isNodeSequence();
                        if (!bl && i2 < n3 - 1) {
                            throw new XPathException(23055, "");
                        }
                    } else {
                        xPathSequence = (XPathSequence)xPathRuntimeContext.popExprValue();
                        XPathSequence xPathSequence2 = (XPathSequence)xPathRuntimeContext.peekExprValue();
                        if (xPathSequence.isNodeSequence()) {
                            if (!bl) {
                                throw new XPathException(23054, "");
                            }
                            XPathSequence.mergeSequence(xPathSequence2, xPathSequence);
                        } else {
                            if (i2 < n3 - 1) {
                                throw new XPathException(23055, "");
                            }
                            if (bl) {
                                throw new XPathException(23054, "");
                            }
                            while (xPathSequence.next()) {
                                xPathSequence2.appendItem(((XPathItem)xPathSequence.getItem()).copy());
                            }
                        }
                    }
                    ++n4;
                }
                if (bl2) {
                    ((OXMLSequence)object).reset();
                    XPathSequence.concatSequence((OXMLSequence)object, xPathRuntimeContext.popExprValue());
                }
            }
            oXMLSequence = xPathRuntimeContext.peekExprValue();
            if (!XMLCompatible.useBuggyBehavior(11935596) && xSLExprBase != null && xSLExprBase instanceof XPathStep && (object = ((XPathStep)xSLExprBase).axisClass) != null && !((XPathAxis)object).isForward()) {
                XPathSequence.makeDocOrder(oXMLSequence);
            }
            if (xPathRuntimeContext.getXPathContext() == null || !xPathRuntimeContext.getEnableException() || XPathSequence.getLength(xPathRuntimeContext.peekExprValue()) != 0) continue;
            xPathRuntimeContext.getXPathContext().setError(this.getError(i2));
        }
        if (XMLCompatible.useBuggyBehavior(11935596) && xSLExprBase != null && xSLExprBase instanceof XPathStep && (xPathAxis = ((XPathStep)xSLExprBase).axisClass) != null && !xPathAxis.isForward()) {
            XPathSequence.makeDocOrder(oXMLSequence);
        }
        xPathRuntimeContext.setContextNode(xMLNode);
        xPathRuntimeContext.setContextPosition(n2);
    }

    @Override
    public void streamingEvaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        int n2 = this.stepVector.size();
        XMLNode xMLNode = xPathRuntimeContext.getContextNode();
        if (this.root) {
            xMLNode = xPathRuntimeContext.getSrcRoot(xMLNode);
        }
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.pushExprValue();
        StreamNodeSequence streamNodeSequence = (StreamNodeSequence)xPathRuntimeContext.getStreamValue(this);
        StreamNodeSequence streamNodeSequence2 = null;
        boolean bl = true;
        if (streamNodeSequence != null) {
            bl = false;
            if (streamNodeSequence.isDone()) {
                streamNodeSequence.reset(xMLNode);
            } else {
                streamNodeSequence = null;
            }
        }
        if (streamNodeSequence == null) {
            streamNodeSequence2 = streamNodeSequence = new StreamNodeSequence(null, xPathRuntimeContext, null, xMLNode);
            for (int i2 = 0; i2 < n2; ++i2) {
                XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i2);
                if (xPathStep.getAxisType() == 11 && xPathStep.prevSeparator != 6 && xPathStep.predicates == null) continue;
                streamNodeSequence2 = streamNodeSequence = new StreamNodeSequence(xPathStep, xPathRuntimeContext, streamNodeSequence2, null);
            }
            if (bl) {
                xPathRuntimeContext.saveStreamValue(this, streamNodeSequence);
            }
        }
        xPathSequence.streamResult = streamNodeSequence;
        xPathSequence.started = true;
    }

    public void evaluateBinary(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        BinarySequence binarySequence;
        int n2 = this.stepVector.size();
        BinaryNav binaryNav = xPathRuntimeContext.getBinaryNav();
        long l2 = xPathRuntimeContext.getContextIndex();
        if (this.root) {
            binaryNav.document();
            l2 = binaryNav.getCurrentIndex();
        } else {
            binaryNav.seekToIndex(l2);
        }
        XPathSequence xPathSequence = (XPathSequence)xPathRuntimeContext.pushExprValue();
        BinarySequence binarySequence2 = binarySequence = new BinarySequence(null, xPathRuntimeContext, null, l2);
        for (int i2 = 0; i2 < n2; ++i2) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i2);
            if (xPathStep.getAxisType() == 11 && xPathStep.prevSeparator != 6 && xPathStep.predicates == null) continue;
            binarySequence2 = binarySequence = new BinarySequence(xPathStep, xPathRuntimeContext, binarySequence2, -2L);
        }
        xPathSequence.streamResult = binarySequence;
        xPathSequence.started = true;
    }

    @Override
    public void setPriority(float f2) throws XSLException {
        this.priority = f2;
    }

    @Override
    public XSLExprBase matchPattern(XMLNode xMLNode, float f2, XSLTContext xSLTContext) throws XSLException, XQException {
        OXMLSequence oXMLSequence = xSLTContext.getCurNodeList();
        OXMLSequence oXMLSequence2 = xSLTContext.getAltNodeList();
        XMLNode xMLNode2 = xMLNode;
        int n2 = this.stepVector.size();
        oXMLSequence.reset();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(i2);
            if (!(xPathStep instanceof XPathStep)) {
                return null;
            }
            oXMLSequence2.reset();
            if (xMLNode2 != null) {
                xMLNode2 = xPathStep.matchPattern(xSLTContext, xMLNode2, oXMLSequence2);
            } else if (oXMLSequence.getItemOccurrence() != 0) {
                xMLNode2 = xPathStep.matchPattern(xSLTContext, oXMLSequence, oXMLSequence2);
            } else {
                return null;
            }
            if (xMLNode2 != null) continue;
            OXMLSequence oXMLSequence3 = oXMLSequence;
            oXMLSequence = oXMLSequence2;
            oXMLSequence2 = oXMLSequence3;
        }
        if (this.matchroot) {
            XMLElement xMLElement = xSLTContext.getSrcRoot(xMLNode);
            if (xMLNode2 != null) {
                if (xMLNode2 == xMLElement) {
                    return this;
                }
                return null;
            }
            if (XPathSequence.contains(oXMLSequence, xMLElement)) {
                return this;
            }
        } else {
            if (this.filter != null) {
                if (xMLNode2 != null) {
                    XPathSequence.addNode(oXMLSequence, xMLNode2);
                }
                if (this.filter.matchNodeList(xMLNode, oXMLSequence, xSLTContext)) {
                    return this;
                }
                return null;
            }
            if (xMLNode2 != null || oXMLSequence.getItemOccurrence() != 0) {
                return this;
            }
        }
        return null;
    }

    @Override
    public int matchPattern(XSLExprBase xSLExprBase, float f2) throws XSLException {
        XPathStep xPathStep;
        int n2;
        if (!(xSLExprBase instanceof PathExpr)) {
            return 0;
        }
        PathExpr pathExpr = (PathExpr)xSLExprBase;
        int n3 = this.stepVector.size();
        int n4 = pathExpr.stepVector.size();
        int n5 = 1;
        if (this.matchroot && (n3 < n4 || n3 == n4 && !pathExpr.matchroot)) {
            return -1;
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            if (--n4 < 0) {
                n5 = 0;
                break;
            }
            xPathStep = (XPathStep)this.stepVector.elementAt(n2);
            XSLExprBase xSLExprBase2 = (XSLExprBase)pathExpr.stepVector.elementAt(n4);
            if (!(xSLExprBase2 instanceof XPathStep)) {
                return -1;
            }
            int n6 = xPathStep.matchStep((XPathStep)xSLExprBase2);
            if (n6 < 0) {
                return -1;
            }
            if (n6 != 0) continue;
            n5 = 0;
        }
        for (n2 = n4; n2 >= 0; --n2) {
            xPathStep = (XPathStep)pathExpr.stepVector.elementAt(n2);
            if (xPathStep == null || xPathStep.getAxisType() == 501 || xPathStep.getAxisType() == 503) continue;
            return 0;
        }
        if (this.filter != null) {
            return 0;
        }
        return n5;
    }

    private XPathError getError(int n2) {
        XPathStep xPathStep = (XPathStep)this.stepVector.elementAt(n2);
        XPathError xPathError = new XPathError();
        String string = "";
        if (n2 == 0) {
            string = "/" + xPathStep.name;
        } else {
            for (int i2 = 0; i2 <= n2; ++i2) {
                string = string + "/" + ((XPathStep)this.stepVector.elementAt((int)i2)).name;
                if (((XPathStep)this.stepVector.elementAt((int)i2)).predicates == null || ((XPathStep)this.stepVector.elementAt((int)i2)).predicates.getPositionTest() == 0) continue;
                string = string + "[" + ((XPathStep)this.stepVector.elementAt((int)i2)).predicates.getPositionTest() + "]";
            }
        }
        if (xPathStep.predicates != null) {
            xPathError.setPosition(xPathStep.predicates.getPositionTest());
        }
        xPathError.setXpath(string);
        xPathError.setMissingNode(new QName(xPathStep.nameSpace, xPathStep.name));
        if (n2 > 0) {
            xPathError.setParentNode(new QName(((XPathStep)this.stepVector.elementAt((int)(n2 - 1))).nameSpace, ((XPathStep)this.stepVector.elementAt((int)(n2 - 1))).name));
        }
        return xPathError;
    }

    private PathExpr convertAbs2Rel(XSLExprBase xSLExprBase) {
        FastVector fastVector;
        FastVector fastVector2 = this.getStepVector();
        if (fastVector2 != (fastVector = this.convertAbs2Rel(fastVector2, xSLExprBase))) {
            this.setStepVector(fastVector);
        }
        return this;
    }

    private FastVector convertAbs2Rel(FastVector fastVector, XSLExprBase xSLExprBase) {
        XSLExprBase xSLExprBase2 = xSLExprBase;
        this.setRelative(false);
        if (xSLExprBase2 != null && xSLExprBase2 instanceof XPathVarReference) {
            xSLExprBase2 = ((XPathVarReference)xSLExprBase2).getPathExpr();
        }
        if (xSLExprBase2 == null || !(xSLExprBase2 instanceof PathExpr)) {
            return fastVector;
        }
        PathExpr pathExpr = (PathExpr)xSLExprBase2;
        FastVector fastVector2 = pathExpr.getExpandedStepVector();
        if (fastVector2 == null || fastVector2.size() == 0) {
            this.relative = true;
            return fastVector;
        }
        return this.resolveAbs2Rel(fastVector, fastVector2);
    }

    private FastVector resolveAbs2Rel(FastVector fastVector, FastVector fastVector2) {
        int n2;
        this.setRelative(false);
        int n3 = fastVector2.size();
        int n4 = fastVector.size();
        if (n4 < n3) {
            return fastVector;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            XPathStep xPathStep = (XPathStep)fastVector.elementAt(n2);
            XPathStep xPathStep2 = (XPathStep)fastVector2.elementAt(n2);
            try {
                if (xPathStep.isSame(xPathStep2)) continue;
                return fastVector;
            }
            catch (NullPointerException nullPointerException) {
                return fastVector;
            }
        }
        FastVector fastVector3 = new FastVector(n4 - n3);
        boolean bl = false;
        for (n2 = n3; n2 < n4; ++n2) {
            fastVector3.addElement(fastVector.elementAt(n2));
        }
        this.setRelative(true);
        return fastVector3;
    }
}

