/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.PagedNodeList;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.util.XMLCompatible;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.BinarySequence;
import oracle.xml.xpath.StreamNodeSequence;
import oracle.xml.xpath.StreamingSequence;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathSequence
extends OXMLSequence
implements XSLExprConstants {
    private int length;
    private XPathItem firstItem;
    private XPathItem lastItem;
    final XPathRuntimeContext ctx;
    boolean started;
    private XPathItem iterItem;
    PagedNodeList pagedNodeList;
    StreamingSequence streamResult;
    public XMLElement lazyNode;
    private static final boolean T = true;
    private static final boolean F = false;
    private static final int OPBASE_GEN = 216;
    private static final int OPBASE_VAL = 210;
    private static final boolean[][] optable = new boolean[][]{{false, false, false, false, false, false}, {false, true, true, true, false, false}, {true, false, false, true, false, true}, {false, true, false, false, true, true}, {false, true, false, false, false, false}};
    public static final String BOOLEAN = "boolean";
    public static final String NODESET = "node-set";
    public static final String NUMBER = "number";
    public static final String STRING = "string";
    public static final String RESULTTREE = "result tree fragment";

    public XPathSequence(XPathRuntimeContext xPathRuntimeContext) {
        this.ctx = xPathRuntimeContext;
        this.lastItem = null;
        this.firstItem = null;
        this.iterItem = null;
        this.started = false;
        this.iterItem = null;
    }

    public XPathSequence() {
        this.ctx = null;
        this.lastItem = null;
        this.firstItem = null;
        this.iterItem = null;
        this.started = false;
        this.iterItem = null;
    }

    public String getStripStringVal(XSLTContext xSLTContext) throws XSLException {
        if (this.streamResult == null) {
            return this.getItemString();
        }
        XMLNode xMLNode = this.streamResult.getNode();
        if (xMLNode == null) {
            return this.getItemString();
        }
        XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
        if (xMLNode2 == null) {
            return this.getItemString();
        }
        boolean bl = xSLTContext.isStrippedWS(xMLNode2);
        String string = bl ? "" : this.getItemString();
        return string;
    }

    @Override
    public void reset() throws XQException {
        this.started = false;
        this.streamResult = null;
        if (this.length > 0) {
            this.ctx.freeItem(this.firstItem, this.lastItem);
        }
        this.lastItem = null;
        this.firstItem = null;
        this.iterItem = null;
        this.length = 0;
        this.lazyNode = null;
        this.pagedNodeList = null;
    }

    public XPathItem getFirstItem() {
        return this.firstItem;
    }

    XPathItem retainFirstItem() {
        if (this.firstItem != this.lastItem) {
            this.ctx.freeItem(this.firstItem.nextItem, this.lastItem);
            this.length = 1;
            this.lastItem = this.firstItem;
            this.lastItem.nextItem = null;
        }
        return this.firstItem;
    }

    void setLazyLoad() throws XQException {
        if (this.firstItem != null) {
            this.lazyNode = (XMLElement)this.firstItem.getNode();
        }
    }

    public void setPagedNodeList(PagedNodeList pagedNodeList) {
        this.pagedNodeList = pagedNodeList;
        if (pagedNodeList.next()) {
            XMLNode xMLNode = pagedNodeList.getNode();
            this.firstItem = this.ctx.allocItem();
            this.firstItem.setNode(xMLNode);
        }
    }

    @Override
    public boolean isOfType(OXMLSequenceType oXMLSequenceType) throws XQException {
        int n2 = oXMLSequenceType.getOccurence();
        if (this.length == 0) {
            return n2 == 0 || n2 == 2 || n2 == 4;
        }
        if (this.length == 1) {
            if (n2 == 0) {
                return false;
            }
            boolean bl = false;
            if (this.firstItem.isNode()) {
                bl = oXMLSequenceType.matchNode(this.firstItem.getNode());
                return bl;
            }
            OXMLSequenceType oXMLSequenceType2 = this.firstItem.getItemType();
            if (oXMLSequenceType2 != null && oXMLSequenceType != null) {
                bl = this.firstItem.matchesType(oXMLSequenceType);
                return bl;
            }
            return oXMLSequenceType2 == null && oXMLSequenceType == null;
        }
        if (n2 == 0 || n2 == 2 || n2 == 1) {
            return false;
        }
        XPathItem xPathItem = this.firstItem;
        OXMLSequenceType oXMLSequenceType3 = null;
        boolean bl = true;
        while (xPathItem != null && bl) {
            if (xPathItem.isNode() && !oXMLSequenceType.matchNode(xPathItem.getNode())) {
                return false;
            }
            oXMLSequenceType3 = xPathItem.getItemType();
            bl = oXMLSequenceType3.isOfTypeIgnoreOccurence(oXMLSequenceType);
            xPathItem = xPathItem.nextItem;
        }
        return bl;
    }

    boolean isNodeSequence() {
        if (this.isStreaming()) {
            return true;
        }
        XPathItem xPathItem = this.firstItem;
        while (xPathItem != null) {
            if (!xPathItem.isNode()) {
                return false;
            }
            xPathItem = xPathItem.nextItem;
        }
        return true;
    }

    public boolean hasTextNode() {
        if (this.streamResult != null) {
            if (this.streamResult instanceof BinarySequence) {
                return false;
            }
            XPathStep xPathStep = ((StreamNodeSequence)this.streamResult).step;
            if (xPathStep != null && !xPathStep.anyNode && xPathStep.nodeType != 3) {
                return false;
            }
        }
        return true;
    }

    public boolean isStreaming() {
        return this.streamResult != null || this.pagedNodeList != null || this.lazyNode != null;
    }

    @Override
    public boolean next() throws XQException {
        if (!this.started) {
            this.started = true;
            this.iterItem = this.firstItem;
        } else {
            if (this.lazyNode != null) {
                this.lazyNode = this.lazyNode.getNextSiblingByName();
                if (this.lazyNode != null) {
                    return true;
                }
                this.iterItem = null;
                return false;
            }
            if (this.streamResult != null) {
                StreamingSequence streamingSequence = this.streamResult;
                try {
                    return this.streamResult.next();
                }
                catch (XSLException xSLException) {
                    throw new XQException(xSLException);
                }
            }
            if (this.pagedNodeList != null) {
                if (this.pagedNodeList.next()) {
                    return true;
                }
                this.iterItem = null;
                return false;
            }
            if (this.iterItem == null) {
                return false;
            }
            this.iterItem = this.iterItem.nextItem;
        }
        return this.iterItem != null;
    }

    @Override
    public OXMLItem getItem() throws XQException {
        if (this.streamResult != null) {
            this.iterItem = this.ctx.allocItem();
            this.iterItem.setNode(this.streamResult.getNode());
        }
        return this.iterItem;
    }

    public String getItemString() throws XQException {
        if (this.streamResult != null) {
            return this.streamResult.getNode().getText();
        }
        return this.iterItem.getLexicalValue();
    }

    @Override
    public void appendItem(OXMLItem oXMLItem) throws XQException {
        XPathItem xPathItem = (XPathItem)oXMLItem;
        if (this.firstItem == null || this.lastItem == null) {
            this.firstItem = this.lastItem = xPathItem;
        } else {
            this.lastItem.nextItem = xPathItem;
            xPathItem.prevItem = this.lastItem;
            this.lastItem = xPathItem;
        }
        xPathItem.nextItem = null;
        ++this.length;
    }

    @Override
    public void atomizeInPlace() throws XQException {
        XPathItem xPathItem = this.firstItem;
        while (xPathItem != null) {
            xPathItem.atomize(null);
            xPathItem = xPathItem.nextItem;
        }
    }

    @Override
    public OXMLSequence atomize() throws XQException {
        XPathSequence xPathSequence = new XPathSequence(this.ctx);
        XPathItem xPathItem = this.firstItem;
        while (xPathItem != null) {
            XPathItem xPathItem2 = (XPathItem)xPathItem.atomizeItem();
            ((OXMLSequence)xPathSequence).appendItem(xPathItem2);
            xPathItem = xPathItem.nextItem;
        }
        return xPathSequence;
    }

    @Override
    public boolean getEffectiveBooleanValue() throws XQException {
        block14: {
            boolean bl;
            block16: {
                block18: {
                    block17: {
                        block15: {
                            if (this.streamResult != null) {
                                return this.next();
                            }
                            if (XMLParser.getIs1010Compatible()) break block14;
                            bl = true;
                            if (this.length != 0) break block15;
                            bl = false;
                            break block16;
                        }
                        if (!FNUtil.isNode(this.firstItem)) break block17;
                        bl = true;
                        break block16;
                    }
                    if (this.length != 1) break block18;
                    switch (this.firstItem.getPrimitiveType()) {
                        case 2: {
                            bl = this.firstItem.getBoolean();
                            break block16;
                        }
                        case 3: 
                        case 4: {
                            double d2 = this.firstItem.getDouble();
                            bl = Double.isNaN(d2) ? false : d2 != 0.0;
                            break block16;
                        }
                        case 5: 
                        case 22: {
                            bl = this.firstItem.withinRange() ? this.firstItem.getInt() != 0 : this.firstItem.getDecimal().doubleValue() != 0.0;
                            break block16;
                        }
                        case 0: 
                        case 1: {
                            bl = this.firstItem.getString().length() != 0;
                            break block16;
                        }
                        default: {
                            throw new XQException(new XPathException(23034));
                        }
                    }
                }
                throw new XQException(new XPathException(23034));
            }
            return bl;
        }
        if (this.length == 0) {
            return false;
        }
        if (this.length == 1) {
            if (this.isOfType(OXMLSequenceType.TBOOLEAN) && !this.firstItem.getBoolean()) {
                return false;
            }
            if ((this.isOfType(OXMLSequenceType.TSTRING) || this.isOfType(OXMLSequenceType.ANYATOMIC_ONE)) && this.firstItem.getString() != null && this.firstItem.getString().equals("")) {
                return false;
            }
            if (this.isOfType(OXMLSequenceType.TDECIMAL) && this.firstItem.getDecimal().intValue() == 0) {
                return false;
            }
            if (this.isOfType(OXMLSequenceType.TINTEGER) && this.firstItem.getInt() == 0) {
                return false;
            }
            if ((this.isOfType(OXMLSequenceType.TDOUBLE) || this.isOfType(OXMLSequenceType.TFLOAT)) && (Double.isNaN(this.firstItem.getDouble()) || this.firstItem.getDouble() == 0.0)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        XPathSequence xPathSequence = new XPathSequence(this.ctx);
        this.copyInto(xPathSequence);
        return xPathSequence;
    }

    public void copyInto(XPathSequence xPathSequence) {
        if (this.pagedNodeList != null) {
            this.pagedNodeList.start();
            xPathSequence.setPagedNodeList(this.pagedNodeList);
            return;
        }
        if (this.firstItem == null) {
            return;
        }
        XPathItem xPathItem = this.firstItem;
        while (xPathItem != null) {
            XPathItem xPathItem2 = this.ctx.allocItem();
            xPathItem2.copyItem(xPathItem);
            try {
                xPathSequence.appendItem(xPathItem2);
            }
            catch (XQException xQException) {
                // empty catch block
            }
            xPathItem = xPathItem.nextItem;
        }
    }

    boolean setObjectValue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof OXMLSequence) {
            OXMLSequence oXMLSequence = (OXMLSequence)object;
            while (oXMLSequence.next()) {
                XPathItem xPathItem = (XPathItem)oXMLSequence.getItem();
                XPathItem xPathItem2 = this.ctx.allocItem();
                ((OXMLItem)xPathItem2).copyItem(xPathItem);
                try {
                    this.appendItem(xPathItem2);
                }
                catch (XQException xQException) {}
            }
        } else if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            int n2 = nodeList.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                XMLNode xMLNode = (XMLNode)nodeList.item(i2);
                XPathItem xPathItem = this.ctx.allocItem();
                xPathItem.setNode(xMLNode);
                try {
                    this.appendItem(xPathItem);
                    continue;
                }
                catch (XQException xQException) {
                    // empty catch block
                }
            }
        } else if (object instanceof Node) {
            XPathItem xPathItem = this.ctx.allocItem();
            xPathItem.setNode((XMLNode)object);
            try {
                this.appendItem(xPathItem);
            }
            catch (XQException xQException) {}
        } else if (object instanceof String) {
            XPathItem xPathItem = this.ctx.allocItem();
            xPathItem.setString(OXMLSequenceType.TSTRING, (String)object);
            try {
                this.appendItem(xPathItem);
            }
            catch (XQException xQException) {}
        } else if (object instanceof Double) {
            XPathItem xPathItem = this.ctx.allocItem();
            xPathItem.setDouble(OXMLSequenceType.TDOUBLE, (Double)object);
            try {
                this.appendItem(xPathItem);
            }
            catch (XQException xQException) {}
        } else if (object instanceof Boolean) {
            XPathItem xPathItem = this.ctx.allocItem();
            xPathItem.setBoolean(OXMLSequenceType.TBOOLEAN, (Boolean)object);
            try {
                this.appendItem(xPathItem);
            }
            catch (XQException xQException) {}
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int getItemOccurrence() throws XQException {
        if (this.length == 0) {
            return 0;
        }
        if (this.length == 1) {
            return 1;
        }
        return 2;
    }

    @Override
    public ArrayList<OXMLItem> toArrayList() {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException();
        }
        ArrayList<OXMLItem> arrayList = new ArrayList<OXMLItem>(this.length);
        XPathItem xPathItem = this.firstItem;
        while (xPathItem != null) {
            arrayList.add(xPathItem);
            xPathItem = xPathItem.nextItem;
        }
        return arrayList;
    }

    static void restart(OXMLSequence oXMLSequence) {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        xPathSequence.started = false;
        xPathSequence.iterItem = null;
    }

    public static int getLength(OXMLSequence oXMLSequence) {
        XMLElement xMLElement = ((XPathSequence)oXMLSequence).lazyNode;
        if (xMLElement != null) {
            int n2 = 0;
            while (xMLElement != null) {
                xMLElement = xMLElement.getNextSiblingByName();
                ++n2;
            }
            return n2;
        }
        if (((XPathSequence)oXMLSequence).pagedNodeList != null) {
            return ((XPathSequence)oXMLSequence).pagedNodeList.getLength();
        }
        return ((XPathSequence)oXMLSequence).length;
    }

    public static void addNode(OXMLSequence oXMLSequence, XMLNode xMLNode) throws XQException {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
        xPathItem.setNode(xMLNode);
        oXMLSequence.appendItem(xPathItem);
    }

    public static XMLNode nextNode(OXMLSequence oXMLSequence) throws XQException {
        XMLElement xMLElement = ((XPathSequence)oXMLSequence).lazyNode;
        if (xMLElement != null) {
            return xMLElement;
        }
        if (((XPathSequence)oXMLSequence).pagedNodeList != null) {
            return ((XPathSequence)oXMLSequence).pagedNodeList.getNode();
        }
        if (((XPathSequence)oXMLSequence).streamResult != null) {
            return ((XPathSequence)oXMLSequence).streamResult.getNode();
        }
        XPathItem xPathItem = (XPathItem)oXMLSequence.getItem();
        XPathItem.nodeCheck(xPathItem);
        XMLNode xMLNode = xPathItem.getNode();
        return xMLNode;
    }

    public static void concatSequence(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        if (xPathSequence2.firstItem == null) {
            return;
        }
        if (xPathSequence.firstItem == null) {
            xPathSequence.firstItem = xPathSequence2.firstItem;
            xPathSequence.lastItem = xPathSequence2.lastItem;
        } else {
            xPathSequence.lastItem.nextItem = xPathSequence2.firstItem;
            xPathSequence2.firstItem.prevItem = xPathSequence.lastItem;
            xPathSequence.lastItem = xPathSequence2.lastItem;
        }
        xPathSequence.length += xPathSequence2.length;
        xPathSequence2.firstItem = null;
        xPathSequence2.lastItem = null;
        xPathSequence2.length = 0;
    }

    public static void mergeNodeSequence(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        if (xPathSequence2.firstItem == null) {
            return;
        }
        XPathRuntimeContext xPathRuntimeContext = xPathSequence.ctx;
        if (xPathSequence.firstItem == null) {
            xPathSequence.firstItem = xPathSequence2.firstItem;
            xPathSequence.lastItem = xPathSequence2.lastItem;
        } else if (xPathRuntimeContext.compareDocOrder(xPathSequence2.firstItem.getNode(), xPathSequence.lastItem.getNode()) >= 0) {
            xPathSequence.lastItem.nextItem = xPathSequence2.firstItem;
            xPathSequence2.firstItem.prevItem = xPathSequence.lastItem;
            xPathSequence.lastItem = xPathSequence2.lastItem;
        } else if (xPathRuntimeContext.compareDocOrder(xPathSequence.firstItem.getNode(), xPathSequence2.lastItem.getNode()) >= 0) {
            xPathSequence2.lastItem.nextItem = xPathSequence.firstItem;
            xPathSequence.firstItem.prevItem = xPathSequence2.lastItem;
            xPathSequence.firstItem = xPathSequence2.firstItem;
        } else {
            XPathSequence.mergeSequence(oXMLSequence, oXMLSequence2);
            return;
        }
        xPathSequence.length += xPathSequence2.length;
        xPathSequence2.firstItem = null;
        xPathSequence2.lastItem = null;
        xPathSequence2.length = 0;
    }

    static void mergeSequence(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        if (xPathSequence2.firstItem == null) {
            return;
        }
        if (xPathSequence.firstItem == null) {
            xPathSequence.firstItem = xPathSequence2.firstItem;
            xPathSequence.lastItem = xPathSequence2.lastItem;
            xPathSequence.length = xPathSequence2.length;
        } else {
            XPathItem xPathItem = xPathSequence2.firstItem;
            XPathItem xPathItem2 = xPathSequence.firstItem;
            int n2 = xPathSequence2.length;
            XPathRuntimeContext xPathRuntimeContext = ((XPathSequence)oXMLSequence).ctx;
            while (xPathItem != null) {
                XMLNode xMLNode;
                XMLNode xMLNode2 = xPathItem.getNode();
                int n3 = xPathRuntimeContext.compareDocOrder(xMLNode2, xMLNode = xPathItem2.getNode());
                if (n3 < 0) {
                    XPathItem xPathItem3 = xPathItem.nextItem;
                    xPathItem.nextItem = xPathItem2;
                    xPathItem.prevItem = xPathItem2.prevItem;
                    xPathItem2.prevItem = xPathItem;
                    if (xPathItem.prevItem != null) {
                        xPathItem.prevItem.nextItem = xPathItem;
                    }
                    xPathItem = xPathItem3;
                    ++xPathSequence.length;
                    --n2;
                    continue;
                }
                if (n3 == 0 && xPathItem.getNode().getDocument() == xPathItem2.getNode().getDocument()) {
                    xPathSequence.ctx.freeItem(xPathItem);
                    xPathItem = xPathItem.nextItem;
                    --n2;
                }
                if (xPathItem2.nextItem == null && xPathItem != null) {
                    xPathItem2.nextItem = xPathItem;
                    xPathItem.prevItem = xPathItem2;
                    xPathSequence.length += n2;
                    break;
                }
                xPathItem2 = xPathItem2.nextItem;
            }
            if (xPathSequence.firstItem.prevItem != null) {
                xPathSequence.firstItem = xPathSequence2.firstItem;
            }
            if (xPathSequence.lastItem.nextItem != null) {
                xPathSequence.lastItem = xPathSequence2.lastItem;
            }
        }
        xPathSequence2.firstItem = null;
        xPathSequence2.lastItem = null;
        xPathSequence2.length = 0;
    }

    static void makeDocOrder(OXMLSequence oXMLSequence) {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        if (xPathSequence.firstItem == null || xPathSequence.firstItem == xPathSequence.lastItem) {
            return;
        }
        if (xPathSequence.ctx.compareDocOrder(xPathSequence.firstItem.getNode(), xPathSequence.lastItem.getNode()) > 0) {
            XPathItem xPathItem;
            XPathItem xPathItem2 = xPathSequence.firstItem;
            while (xPathItem2 != null) {
                xPathItem = xPathItem2.nextItem;
                xPathItem2.nextItem = xPathItem2.prevItem;
                xPathItem2.prevItem = xPathItem;
                xPathItem2 = xPathItem;
            }
            xPathItem = xPathSequence.firstItem;
            xPathSequence.firstItem = xPathSequence.lastItem;
            xPathSequence.lastItem = xPathItem;
        }
    }

    static void mergeOrderedList(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, boolean bl) {
        if (bl) {
            XPathSequence.mergeSequence(oXMLSequence, oXMLSequence2);
            return;
        }
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        if (xPathSequence2.firstItem == null) {
            return;
        }
        if (xPathSequence.firstItem == null) {
            xPathSequence.firstItem = xPathSequence2.firstItem;
            xPathSequence.lastItem = xPathSequence2.lastItem;
            xPathSequence.length = xPathSequence2.length;
        } else {
            XPathItem xPathItem = xPathSequence2.firstItem;
            XPathItem xPathItem2 = xPathSequence.firstItem;
            int n2 = xPathSequence2.length;
            while (xPathItem != null) {
                int n3 = xPathSequence.ctx.compareDocOrder(xPathItem.getNode(), xPathItem2.getNode());
                if (n3 > 0) {
                    XPathItem xPathItem3 = xPathItem.nextItem;
                    xPathItem.nextItem = xPathItem2;
                    xPathItem.prevItem = xPathItem2.prevItem;
                    xPathItem2.prevItem = xPathItem;
                    if (xPathItem.prevItem != null) {
                        xPathItem.prevItem.nextItem = xPathItem;
                    }
                    xPathItem = xPathItem3;
                    ++xPathSequence.length;
                    --n2;
                    continue;
                }
                if (n3 == 0) {
                    xPathSequence.ctx.freeItem(xPathItem);
                    xPathItem = xPathItem.nextItem;
                    --n2;
                }
                if (xPathItem2.nextItem == null && xPathItem != null) {
                    xPathItem2.nextItem = xPathItem;
                    xPathItem.prevItem = xPathItem2;
                    xPathSequence.length += n2;
                    break;
                }
                xPathItem2 = xPathItem2.nextItem;
            }
            if (xPathSequence.firstItem.prevItem != null) {
                xPathSequence.firstItem = xPathSequence2.firstItem;
            }
            if (xPathSequence.lastItem.nextItem != null) {
                xPathSequence.lastItem = xPathSequence2.lastItem;
            }
        }
        xPathSequence2.firstItem = null;
        xPathSequence2.lastItem = null;
        xPathSequence2.length = 0;
    }

    static void intersectSequence(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        while (xPathItem != null) {
            XPathItem xPathItem2 = ((XPathSequence)oXMLSequence2).firstItem;
            while (xPathItem2 != null && !xPathItem.getNode().isSameNode(xPathItem2.getNode())) {
                xPathItem2 = xPathItem2.nextItem;
            }
            if (xPathItem2 == null) {
                ((XPathSequence)oXMLSequence).removeItem(xPathItem);
            }
            xPathItem = xPathItem.nextItem;
        }
    }

    static void exceptSequence(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        while (xPathItem != null) {
            XPathItem xPathItem2 = ((XPathSequence)oXMLSequence2).firstItem;
            while (xPathItem2 != null && !xPathItem.getNode().isSameNode(xPathItem2.getNode())) {
                xPathItem2 = xPathItem2.nextItem;
            }
            if (xPathItem2 != null) {
                ((XPathSequence)oXMLSequence).removeItem(xPathItem);
            }
            xPathItem = xPathItem.nextItem;
        }
    }

    public static void setBooleanValue(OXMLSequence oXMLSequence, boolean bl) throws XQException {
        oXMLSequence.reset();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
        xPathItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
        oXMLSequence.appendItem(xPathItem);
    }

    public static void setNumberValue(OXMLSequence oXMLSequence, double d2) throws XQException {
        oXMLSequence.reset();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
        xPathItem.setDouble(OXMLSequenceType.TDOUBLE, d2);
        oXMLSequence.appendItem(xPathItem);
    }

    public static void setStringValue(OXMLSequence oXMLSequence, String string) throws XQException {
        oXMLSequence.reset();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
        xPathItem.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence.appendItem(xPathItem);
    }

    public static void setExtensionValue(OXMLSequence oXMLSequence, Object object) throws XQException {
        if (object instanceof NodeList) {
            int n2 = ((NodeList)object).getLength();
            oXMLSequence.reset();
            for (int i2 = 0; i2 < n2; ++i2) {
                XMLNode xMLNode = (XMLNode)((NodeList)object).item(i2);
                XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
                xPathItem.setNode(xMLNode);
                oXMLSequence.appendItem(xPathItem);
            }
        } else {
            oXMLSequence.reset();
            XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
            xPathItem.setExternalObject(object);
            oXMLSequence.appendItem(xPathItem);
        }
    }

    public static void setDocumentFragmentValue(OXMLSequence oXMLSequence, XMLDocumentFragment xMLDocumentFragment) throws XQException {
        oXMLSequence.reset();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
        xPathItem.setDocumentFragmentValue(xMLDocumentFragment);
        oXMLSequence.appendItem(xPathItem);
    }

    public static void setNodeValue(OXMLSequence oXMLSequence, XMLNode xMLNode) throws XQException {
        oXMLSequence.reset();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).ctx.allocItem();
        xPathItem.setNode(xMLNode);
        oXMLSequence.appendItem(xPathItem);
    }

    public static boolean getBooleanValue(OXMLSequence oXMLSequence) throws XQException {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        if (xPathItem == null) {
            return false;
        }
        return XPathItem.getBooleanValue(xPathItem);
    }

    public static String getStringValue(OXMLSequence oXMLSequence) throws XQException {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        if (xPathItem == null) {
            return "";
        }
        return ((OXMLItem)xPathItem).getLexicalValue();
    }

    public static double getNumberValue(OXMLSequence oXMLSequence) throws XQException {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathItem xPathItem = xPathSequence.firstItem;
        if (xPathItem == null) {
            return Double.NaN;
        }
        return XPathItem.getNumberValue(xPathItem);
    }

    static Object getExtensionValue(OXMLSequence oXMLSequence) throws XQException {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        if (xPathItem == null) {
            throw new XQException(new XPathException(1900));
        }
        return ((OXMLItem)xPathItem).getExternalObject();
    }

    boolean getBooleanValue() throws XQException {
        if (this.streamResult != null) {
            return this.next();
        }
        if (this.next()) {
            OXMLItem oXMLItem = this.getItem();
            return XPathItem.getBooleanValue(oXMLItem);
        }
        return false;
    }

    String getStringValue() throws XQException {
        if (this.next()) {
            OXMLItem oXMLItem = this.getItem();
            return XPathItem.getStringValue(oXMLItem);
        }
        return null;
    }

    double getNumberValue() throws XQException {
        if (this.next()) {
            OXMLItem oXMLItem = this.getItem();
            return XPathItem.getNumberValue(oXMLItem);
        }
        return Double.NaN;
    }

    Object getExtensionValue() throws XQException {
        if (this.next()) {
            OXMLItem oXMLItem = this.getItem();
            return oXMLItem.getExternalObject();
        }
        throw new XQException(new XPathException(1900));
    }

    Object getObjectValue() throws XQException {
        Object object = null;
        OXMLItem oXMLItem = null;
        XMLNodeList xMLNodeList = null;
        while (this.next()) {
            oXMLItem = this.getItem();
            if (oXMLItem.isNode()) {
                if (object == null) {
                    object = oXMLItem.getNode();
                    continue;
                }
                if (xMLNodeList == null) {
                    xMLNodeList = new XMLNodeList();
                    xMLNodeList.addNode((Node)object);
                    xMLNodeList.addNode(oXMLItem.getNode());
                    object = xMLNodeList;
                    continue;
                }
                xMLNodeList.addNode(oXMLItem.getNode());
                continue;
            }
            int n2 = oXMLItem.getPrimitiveType();
            if (n2 == 2) {
                object = new Boolean(oXMLItem.getBoolean());
            }
            if (n2 == 3 || n2 == 4) {
                object = new Double(oXMLItem.getDouble());
            } else if (n2 == 5 || n2 == 22) {
                object = oXMLItem.withinRange() ? new Double(oXMLItem.getInt()) : new Double(oXMLItem.getDecimal().doubleValue());
            } else if (n2 == 1 || n2 == 17 || n2 == 18 || n2 == 19) {
                object = oXMLItem.getString();
            }
            if (!this.next()) break;
            throw new XQException("FOTY0001");
        }
        if (object != null) {
            return object;
        }
        return new XMLNodeList();
    }

    public static XMLDocumentFragment getResultTreeValue(OXMLSequence oXMLSequence) {
        XMLNode xMLNode;
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        if (xPathItem != null && (xMLNode = xPathItem.getNode()) instanceof XMLDocumentFragment) {
            return (XMLDocumentFragment)xMLNode;
        }
        return null;
    }

    public static NodeList getNodeList(OXMLSequence oXMLSequence) {
        XMLNodeList xMLNodeList = new XMLNodeList();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        while (xPathItem != null) {
            XPathItem.nodeCheck(xPathItem);
            XMLNode xMLNode = xPathItem.getNode();
            xMLNodeList.addNode(xMLNode);
            xPathItem = xPathItem.nextItem;
        }
        return xMLNodeList;
    }

    public static XMLNode[] getNodeArray(OXMLSequence oXMLSequence) {
        XMLNode[] xMLNodeArray = new XMLNode[XPathSequence.getLength(oXMLSequence)];
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        int n2 = 0;
        while (xPathItem != null) {
            XPathItem.nodeCheck(xPathItem);
            XMLNode xMLNode = xPathItem.getNode();
            xMLNodeArray[n2++] = xMLNode;
            xPathItem = xPathItem.nextItem;
        }
        return xMLNodeArray;
    }

    NodeList getNodeList() {
        XMLNodeList xMLNodeList = new XMLNodeList();
        while (this.next()) {
            xMLNodeList.addNode(XPathSequence.nextNode(this));
        }
        return xMLNodeList;
    }

    static void getParentList(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XSLException, XQException {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        while (xPathItem != null) {
            XPathItem.nodeCheck(xPathItem);
            XMLNode xMLNode = xPathItem.getNode();
            xMLNode = xMLNode instanceof XMLAttr ? (XMLNode)((Object)((XMLAttr)xMLNode).getOwnerElement()) : (XMLNode)xMLNode.getParentNode();
            if (xMLNode != null) {
                XPathItem xPathItem2 = ((XPathSequence)oXMLSequence).ctx.allocItem();
                xPathItem2.setNode(xMLNode);
                oXMLSequence2.appendItem(xPathItem2);
            }
            xPathItem = xPathItem.nextItem;
        }
    }

    public static void compareValue(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2) throws XQException {
        String string;
        int n3 = oXMLSequence.getItemOccurrence();
        int n4 = oXMLSequence2.getItemOccurrence();
        if (n3 == 0 || n4 == 0) {
            oXMLSequence.reset();
            return;
        }
        if (n3 != 1 || n4 != 1) {
            throw new XQException(new XPathException(1900));
        }
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        boolean bl = false;
        xPathSequence.atomizeInPlace();
        xPathSequence2.atomizeInPlace();
        XPathItem xPathItem = xPathSequence.firstItem;
        XPathItem xPathItem2 = xPathSequence2.firstItem;
        if (xPathItem.matchesType(OXMLSequenceType.TUNTYPED)) {
            string = XPathItem.getStringValue(xPathItem);
            xPathItem.setString(OXMLSequenceType.TSTRING, string);
        }
        if (xPathItem2.matchesType(OXMLSequenceType.TUNTYPED)) {
            string = XPathItem.getStringValue(xPathItem2);
            xPathItem2.setString(OXMLSequenceType.TSTRING, string);
        }
        bl = optable[xPathItem.compareValue(xPathItem2) + 2][n2 - 210];
        XPathSequence.setBooleanValue(oXMLSequence, bl);
    }

    public static void _compareGeneral(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2, boolean bl) throws XQException {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        boolean bl2 = false;
        if (bl) {
            if (oXMLSequence.isOfType(OXMLSequenceType.NODE_ONE) && oXMLSequence2.isOfType(OXMLSequenceType.TBOOLEAN)) {
                XPathItem xPathItem = xPathSequence2.firstItem;
                boolean bl3 = xPathSequence.length > 0;
                xPathItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl3);
                XPathItem xPathItem2 = xPathSequence2.firstItem;
                XPathItem.getBooleanValue(xPathItem2);
                if (optable[xPathItem.compareVal(xPathItem2, 2) + 2][n2 - 216]) {
                    bl2 = true;
                }
                XPathSequence.setBooleanValue(oXMLSequence, bl2);
                return;
            }
            if (oXMLSequence.isOfType(OXMLSequenceType.TBOOLEAN) && oXMLSequence2.isOfType(OXMLSequenceType.NODE_ONE)) {
                XPathItem xPathItem = xPathSequence2.firstItem;
                boolean bl4 = xPathSequence.length > 0;
                xPathItem.setBoolean(OXMLSequenceType.TBOOLEAN, bl4);
                XPathItem xPathItem3 = xPathSequence2.firstItem;
                XPathItem.getBooleanValue(xPathItem3);
                if (optable[xPathItem3.compareVal(xPathItem, 2) + 2][n2 - 216]) {
                    bl2 = true;
                }
                XPathSequence.setBooleanValue(oXMLSequence, bl2);
                return;
            }
        }
        xPathSequence.atomizeInPlace();
        xPathSequence2.atomizeInPlace();
        XPathItem xPathItem = xPathSequence.firstItem;
        while (xPathItem != null) {
            XPathItem xPathItem4 = xPathSequence2.firstItem;
            while (xPathItem4 != null) {
                if (xPathItem.matchesType(OXMLSequenceType.TUNTYPED) && xPathItem4.matchesType(OXMLSequenceType.TUNTYPED)) {
                    xPathItem.setString(OXMLSequenceType.TSTRING, xPathItem.getLexicalValue());
                    xPathItem4.setString(OXMLSequenceType.TSTRING, xPathItem4.getLexicalValue());
                } else if (xPathItem.matchesType(OXMLSequenceType.TUNTYPED)) {
                    if (xPathItem4.matchesType(OXMLSequenceType.NUMERIC_ONE)) {
                        xPathItem.convert(OXMLSequenceType.TDOUBLE);
                    } else {
                        xPathItem.convert(xPathItem4.getItemType());
                    }
                } else if (xPathItem4.matchesType(OXMLSequenceType.TUNTYPED)) {
                    if (xPathItem.matchesType(OXMLSequenceType.NUMERIC_ONE)) {
                        xPathItem4.convert(OXMLSequenceType.TDOUBLE);
                    } else {
                        xPathItem4.convert(xPathItem.getItemType());
                    }
                }
                if (bl && (xPathItem.matchesType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE) || xPathItem4.matchesType(OXMLSequenceType.NUMERIC_ZERO_OR_ONE))) {
                    xPathItem.convert(OXMLSequenceType.TDOUBLE);
                    xPathItem4.convert(OXMLSequenceType.TDOUBLE);
                }
                if (optable[xPathItem.compareValue(xPathItem4) + 2][n2 - 216]) {
                    bl2 = true;
                    break;
                }
                xPathItem4 = xPathItem4.nextItem;
            }
            xPathItem = xPathItem.nextItem;
        }
        XPathSequence.setBooleanValue(oXMLSequence, bl2);
    }

    public static void compareGeneral(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2, boolean bl) throws XQException {
        XPathItem xPathItem;
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence2;
        boolean bl2 = false;
        if (bl) {
            XPathSequence.compareGeneral10(xPathSequence, xPathSequence2, n2);
        }
        XPathItem xPathItem2 = xPathSequence.firstItem;
        while (xPathItem2 != null) {
            int n3 = xPathItem2.getPrimitiveType();
            if (n3 == 90) {
                xPathItem2.atomize(null);
                n3 = xPathItem2.getPrimitiveType();
            }
            xPathItem = xPathSequence2.firstItem;
            while (xPathItem != null) {
                int n4 = xPathItem.getPrimitiveType();
                if (n4 == 90) {
                    xPathItem.atomize(null);
                    n4 = xPathItem.getPrimitiveType();
                }
                if (n3 == 0) {
                    if (n4 == 0) {
                        xPathItem2.setString(OXMLSequenceType.TSTRING, xPathItem2.getLexicalValue());
                        xPathItem.setString(OXMLSequenceType.TSTRING, xPathItem.getLexicalValue());
                    } else if (n4 == 22 || n4 == 3) {
                        xPathItem2.convert(OXMLSequenceType.TDOUBLE);
                    } else {
                        xPathItem2.convert(xPathItem.getItemType());
                    }
                } else if (n4 == 0) {
                    if (n3 == 22 || n3 == 3) {
                        xPathItem.convert(OXMLSequenceType.TDOUBLE);
                    } else {
                        xPathItem.convert(xPathItem2.getItemType());
                    }
                }
                if (bl) {
                    if (n3 == 4 || n3 == 22 || n3 == 3) {
                        xPathItem.convert(OXMLSequenceType.TDOUBLE);
                    } else if (n4 == 4 || n4 == 22 || n4 == 3) {
                        xPathItem2.convert(OXMLSequenceType.TDOUBLE);
                    } else if (XPathSequence.isNonEqualRelationalOperator(n2) && !XMLCompatible.useBuggyBehavior(9294329)) {
                        xPathItem2.convert(OXMLSequenceType.TDOUBLE);
                        xPathItem.convert(OXMLSequenceType.TDOUBLE);
                    }
                }
                if (optable[xPathItem2.compareValue(xPathItem) + 2][n2 - 216]) {
                    XPathSequence.setBooleanValue(oXMLSequence, true);
                    return;
                }
                xPathItem = xPathItem.nextItem;
            }
            xPathItem2 = xPathItem2.nextItem;
        }
        if (xPathSequence.length == 0) {
            if (bl && oXMLSequence2.isOfType(OXMLSequenceType.TBOOLEAN)) {
                xPathItem2 = new XPathItem();
                xPathItem2.setBoolean(OXMLSequenceType.TBOOLEAN, false);
                xPathItem = xPathSequence2.firstItem;
                bl2 = optable[xPathItem2.compareValue(xPathItem) + 2][n2 - 216];
            }
        } else if (xPathSequence2.length == 0 && bl && oXMLSequence.isOfType(OXMLSequenceType.TBOOLEAN)) {
            xPathItem = new XPathItem();
            xPathItem.setBoolean(OXMLSequenceType.TBOOLEAN, false);
            xPathItem2 = xPathSequence.firstItem;
            bl2 = optable[xPathItem2.compareValue(xPathItem) + 2][n2 - 216];
        }
        XPathSequence.setBooleanValue(oXMLSequence, bl2);
    }

    private static boolean isEqualRelationalOperator(int n2) {
        return n2 == 210 || n2 == 211 || n2 == 216 || n2 == 217;
    }

    private static boolean isNonEqualRelationalOperator(int n2) {
        return n2 == 212 || n2 == 213 || n2 == 214 || n2 == 215 || n2 == 218 || n2 == 219 || n2 == 220 || n2 == 221;
    }

    private static void compareGeneral10(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2) throws XQException {
        XPathSequence xPathSequence;
        XPathSequence xPathSequence2 = (XPathSequence)oXMLSequence;
        XPathSequence xPathSequence3 = (XPathSequence)oXMLSequence2;
        if (!xPathSequence2.next()) {
            XPathSequence.restart(xPathSequence2);
            return;
        }
        if (!xPathSequence3.next()) {
            XPathSequence.restart(xPathSequence3);
            return;
        }
        XPathItem xPathItem = (XPathItem)xPathSequence2.getItem();
        XPathItem xPathItem2 = (XPathItem)xPathSequence3.getItem();
        int n3 = xPathItem.getPrimitiveType();
        int n4 = xPathItem2.getPrimitiveType();
        if (!xPathSequence2.next() && n3 == 2) {
            XPathSequence xPathSequence4 = xPathSequence2;
            xPathSequence = xPathSequence3;
        } else if (!xPathSequence3.next() && n4 == 2) {
            XPathSequence xPathSequence5 = xPathSequence3;
            xPathSequence = xPathSequence2;
        } else {
            XPathSequence.restart(xPathSequence2);
            XPathSequence.restart(xPathSequence3);
            return;
        }
        XPathSequence.restart(xPathSequence2);
        XPathSequence.restart(xPathSequence3);
        boolean bl = XPathSequence.getBooleanValue(xPathSequence);
        XPathSequence.setBooleanValue(xPathSequence, bl);
    }

    public static void compareNodeAndOrder(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2) throws XQException {
        if (!oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_ONE) || !oXMLSequence2.isOfType(OXMLSequenceType.NODE_ZERO_OR_ONE)) {
            throw new XQException(new XPathException(1900));
        }
        if (oXMLSequence.getItemOccurrence() == 0 || oXMLSequence2.getItemOccurrence() == 0) {
            oXMLSequence.reset();
            return;
        }
        OXMLItem oXMLItem = ((XPathSequence)oXMLSequence).ctx.createItem();
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        XPathItem xPathItem2 = ((XPathSequence)oXMLSequence2).firstItem;
        xPathItem.compareNodes(xPathItem2, n2, oXMLItem);
        oXMLSequence.reset();
        oXMLSequence.appendItem(oXMLItem);
    }

    private static int compareBoolean(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        if (!bl && bl2) {
            return -1;
        }
        return 1;
    }

    public static void arithmetic(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2) throws XQException {
        double d2 = XPathSequence.getNumberValue(oXMLSequence);
        double d3 = XPathSequence.getNumberValue(oXMLSequence2);
        double d4 = XPathSequence.arithmetic(d2, d3, n2);
        XPathSequence.setNumberValue(oXMLSequence, d4);
    }

    public static double arithmetic(double d2, double d3, int n2) throws XQException {
        switch (n2) {
            case 201: {
                return d2 - d3;
            }
            case 200: {
                return d2 + d3;
            }
            case 202: {
                return d2 * d3;
            }
            case 203: {
                return d2 / d3;
            }
            case 204: {
                Double d4 = new Double(d2);
                Double d5 = new Double(d3);
                int n3 = d4.intValue();
                int n4 = d5.intValue();
                if (n4 == 0) {
                    return d2 / d3;
                }
                return (n3 - n3 % n4) / n4;
            }
            case 205: {
                return d2 % d3;
            }
        }
        return 0.0;
    }

    public static void arithmetic20(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, int n2) throws XSLException, XQException {
        oXMLSequence.atomizeInPlace();
        oXMLSequence2.atomizeInPlace();
        if (oXMLSequence.getItemOccurrence() == 0 || oXMLSequence2.getItemOccurrence() == 0) {
            oXMLSequence.reset();
            return;
        }
        if (oXMLSequence.getItemOccurrence() == 2 || oXMLSequence2.getItemOccurrence() == 2) {
            throw new XPathException(23006);
        }
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        XPathItem xPathItem2 = ((XPathSequence)oXMLSequence2).firstItem;
        if (oXMLSequence.isOfType(OXMLSequenceType.TUNTYPED)) {
            if (n2 == 204) {
                xPathItem.convert(OXMLSequenceType.TINTEGER);
            } else {
                xPathItem.convert(OXMLSequenceType.TDOUBLE);
            }
        }
        if (oXMLSequence2.isOfType(OXMLSequenceType.TUNTYPED)) {
            if (n2 == 204) {
                xPathItem2.convert(OXMLSequenceType.TINTEGER);
            } else {
                xPathItem2.convert(OXMLSequenceType.TDOUBLE);
            }
        }
        OXMLItem oXMLItem = ((XPathSequence)oXMLSequence).ctx.createItem();
        xPathItem.arithmetic(xPathItem2, n2, oXMLItem);
        oXMLSequence.reset();
        oXMLSequence.appendItem(oXMLItem);
    }

    public static String getTypeString(OXMLSequence oXMLSequence) throws XQException {
        if (oXMLSequence.isOfType(OXMLSequenceType.NODE_ONE) && ((XPathSequence)oXMLSequence).firstItem.getNode() instanceof XMLDocumentFragment) {
            return RESULTTREE;
        }
        if (oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_MORE)) {
            return NODESET;
        }
        if (oXMLSequence.isOfType(OXMLSequenceType.TSTRING)) {
            return STRING;
        }
        if (oXMLSequence.isOfType(OXMLSequenceType.TBOOLEAN)) {
            return BOOLEAN;
        }
        if (oXMLSequence.isOfType(OXMLSequenceType.TDOUBLE)) {
            return NUMBER;
        }
        if (XPathSequence.getExtensionValue(oXMLSequence) != null) {
            return XPathSequence.getExtensionValue(oXMLSequence).getClass().getName();
        }
        return null;
    }

    public static boolean checkType(OXMLSequence oXMLSequence, Class clazz) throws XPathException {
        String string = clazz.getName();
        try {
            if (((XPathSequence)oXMLSequence).length == 1 && ((XPathSequence)oXMLSequence).firstItem.getExternalObject() != null) {
                if (clazz.isAssignableFrom(((XPathSequence)oXMLSequence).firstItem.getExternalObject().getClass())) {
                    return true;
                }
            } else {
                if (clazz.isAssignableFrom(Class.forName("java.lang.String")) || clazz.isAssignableFrom(Class.forName("java.lang.Float")) || clazz.isAssignableFrom(Class.forName("java.lang.Double")) || clazz.isAssignableFrom(Class.forName("java.lang.Integer")) || clazz.isAssignableFrom(Class.forName("java.lang.Boolean")) || string.equals("int") || string.equals("float") || string.equals("double") || string.equals(BOOLEAN)) {
                    return true;
                }
                if (oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_MORE) && (((XPathSequence)oXMLSequence).firstItem.getNode() instanceof XMLDocumentFragment ? clazz.isAssignableFrom(Class.forName("oracle.xml.parser.v2.XMLDocumentFragment")) : clazz.isAssignableFrom(Class.forName("oracle.xml.parser.v2.XMLNodeList")))) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        return false;
    }

    static Object convertType(OXMLSequence oXMLSequence, Class clazz) throws XPathException {
        String string = clazz.getName();
        try {
            if (string.equals("java.lang.String")) {
                return XPathSequence.getStringValue(oXMLSequence);
            }
            if (string.equals("java.lang.Float") || string.equals("float")) {
                return new Float(XPathSequence.getNumberValue(oXMLSequence));
            }
            if (string.equals("java.lang.Double") || string.equals("double")) {
                return new Double(XPathSequence.getNumberValue(oXMLSequence));
            }
            if (string.equals("java.lang.Integer") || string.equals("int")) {
                return new Integer((int)XPathSequence.getNumberValue(oXMLSequence));
            }
            if (string.equals("java.lang.Boolean") || string.equals(BOOLEAN)) {
                return new Boolean(XPathSequence.getBooleanValue(oXMLSequence));
            }
            if (string.equals("java.lang.Object")) {
                if (oXMLSequence == null) {
                    return XPathSequence.getExtensionValue(oXMLSequence);
                }
                if (XPathSequence.getLength(oXMLSequence) == 0) {
                    return new XMLNodeList();
                }
                if (oXMLSequence.isOfType(OXMLSequenceType.TSTRING)) {
                    return XPathSequence.getStringValue(oXMLSequence);
                }
                if (oXMLSequence.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_MORE)) {
                    return new Double(XPathSequence.getNumberValue(oXMLSequence));
                }
                if (oXMLSequence.isOfType(OXMLSequenceType.TBOOLEAN)) {
                    return new Boolean(XPathSequence.getBooleanValue(oXMLSequence));
                }
                if (oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_MORE)) {
                    if (((XPathSequence)oXMLSequence).firstItem.getNode() instanceof XMLDocumentFragment) {
                        return ((XPathSequence)oXMLSequence).firstItem.getNode();
                    }
                    return XPathSequence.getNodeList(oXMLSequence);
                }
                if (oXMLSequence.isOfType(OXMLSequenceType.TBOOLEAN)) {
                    return XPathSequence.getExtensionValue(oXMLSequence);
                }
            }
            if (oXMLSequence.isOfType(OXMLSequenceType.NODE_ZERO_OR_MORE)) {
                if (((XPathSequence)oXMLSequence).firstItem.getNode() instanceof XMLDocumentFragment) {
                    return ((XPathSequence)oXMLSequence).firstItem.getNode();
                }
                return XPathSequence.getNodeList(oXMLSequence);
            }
            return XPathSequence.getExtensionValue(oXMLSequence);
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    public static void mergeNode(OXMLSequence oXMLSequence, XMLNode xMLNode) throws XQException {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        XPathItem xPathItem = xPathSequence.firstItem;
        while (xPathItem != null) {
            int n2 = xPathSequence.ctx.compareDocOrder(xPathItem.getNode(), xMLNode);
            if (n2 < 0) {
                xPathItem = xPathItem.nextItem;
                continue;
            }
            if (n2 != 0) break;
            return;
        }
        XPathItem xPathItem2 = xPathSequence.ctx.allocItem();
        xPathItem2.setNode(xMLNode);
        if (xPathItem == null) {
            oXMLSequence.appendItem(xPathItem2);
            return;
        }
        xPathItem2.nextItem = xPathItem;
        xPathItem2.prevItem = xPathItem.prevItem;
        if (xPathItem.prevItem != null) {
            xPathItem.prevItem.nextItem = xPathItem2;
        } else {
            xPathSequence.firstItem = xPathItem2;
        }
        xPathItem.prevItem = xPathItem2;
        ++xPathSequence.length;
    }

    public static String normalizeString(String string) throws XQException {
        int n2;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        char[] cArray2 = new char[n3];
        int n4 = 0;
        for (n2 = 0; n2 < n3 && Character.isWhitespace(cArray[n2]); ++n2) {
        }
        while (true) {
            if (n2 < n3 && !Character.isWhitespace(cArray[n2])) {
                cArray2[n4++] = cArray[n2++];
                continue;
            }
            while (n2 < n3 && Character.isWhitespace(cArray[n2])) {
                ++n2;
            }
            if (n2 == n3) break;
            cArray2[n4++] = 32;
        }
        return new String(cArray2, 0, n4);
    }

    public static String translateString(String string, String string2, String string3) throws XQException {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        char[] cArray2 = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = string2.indexOf(string.charAt(i2));
            if (n4 != -1) {
                if (n4 > string3.length() - 1) continue;
                cArray2[n3++] = string3.charAt(n4);
                continue;
            }
            cArray2[n3++] = cArray[i2];
        }
        return new String(cArray2, 0, n3);
    }

    static void tokenize(String string, FastVector fastVector) throws XQException {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (true) {
            if (n3 < n2 && Character.isWhitespace(cArray[n3])) {
                ++n3;
                continue;
            }
            if (n3 == n2) break;
            int n4 = n3;
            while (n3 < n2 && !Character.isWhitespace(cArray[n3])) {
                ++n3;
            }
            String string2 = new String(cArray, n4, n3 - n4);
            fastVector.addElement(string2);
        }
    }

    public static NSNameImpl resolveQname(String string, NSResolver nSResolver, XMLError xMLError) {
        String string2 = XMLUtil.getPrefix(string);
        String string3 = "";
        try {
            XMLUtil.validateQualifiedName(string);
        }
        catch (Exception exception) {
            return null;
        }
        if (string2 != "") {
            string3 = nSResolver.resolveNamespacePrefix(string2);
        }
        if (string3 == null) {
            xMLError.error1(22240, 1, string);
        }
        return new NSNameImpl(string2, XMLUtil.getLocalName(string), string3);
    }

    static boolean contains(OXMLSequence oXMLSequence, XMLNode xMLNode) throws XQException {
        XPathItem xPathItem = ((XPathSequence)oXMLSequence).firstItem;
        while (xPathItem != null) {
            XPathItem.nodeCheck(xPathItem);
            XMLNode xMLNode2 = xPathItem.getNode();
            if (xMLNode.isSameNode(xMLNode2)) {
                return true;
            }
            xPathItem = xPathItem.nextItem;
        }
        return false;
    }

    public void removeItem(XPathItem xPathItem) {
        --this.length;
        if (this.firstItem == this.lastItem) {
            this.lastItem = null;
            this.firstItem = null;
        } else if (xPathItem == this.firstItem) {
            this.firstItem = this.firstItem.nextItem;
            this.firstItem.prevItem = null;
        } else if (xPathItem == this.lastItem) {
            this.lastItem = this.lastItem.prevItem;
            this.lastItem.nextItem = null;
        } else {
            xPathItem.prevItem.nextItem = xPathItem.nextItem;
            xPathItem.nextItem.prevItem = xPathItem.prevItem;
        }
        this.ctx.freeItem(xPathItem);
    }

    static void print(OXMLSequence oXMLSequence, String string) {
        XPathSequence xPathSequence = (XPathSequence)oXMLSequence;
        System.err.print(string + " NL [" + xPathSequence.length + "] ");
        XPathItem xPathItem = xPathSequence.firstItem;
        while (xPathItem != null) {
            if (xPathItem.getNode() != null) {
                System.err.print(xPathItem.getNode().getNodeName() + " ");
            } else {
                System.err.print("null ");
            }
            xPathItem = xPathItem.nextItem;
        }
        System.err.println();
    }
}

