/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.GregorianCalendar;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class FNDateTimeSubtract
extends OXMLFunction {
    boolean isYearMonth;

    FNDateTimeSubtract(boolean bl) {
        this.isYearMonth = bl;
    }

    @Override
    public String getFunctionName() {
        if (this.isYearMonth) {
            return "subtract-dateTimes-yielding-yearMonthDuration";
        }
        return "subtract-dateTimes-yielding-dayTimeDuration";
    }

    @Override
    public int getNumberArgs() {
        return 2;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        if (this.isYearMonth) {
            return OXMLSequenceType.getConstantType(2, 20);
        }
        return OXMLSequenceType.getConstantType(2, 21);
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0 || n2 == 1) {
            return OXMLSequenceType.getConstantType(2, 7);
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        OXMLItem oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequence2);
        if (oXMLItem != null && oXMLItem2 != null) {
            GregorianCalendar gregorianCalendar = oXMLItem.getCalendar();
            long l2 = gregorianCalendar.getTimeInMillis();
            gregorianCalendar = oXMLItem2.getCalendar();
            long l3 = l2 - gregorianCalendar.getTimeInMillis();
            OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
            GregorianCalendar gregorianCalendar2 = (GregorianCalendar)gregorianCalendar.clone();
            long l4 = l3 / 86400000L;
            long l5 = l3 - l4 * 86400000L;
            long l6 = l5 / 60000L;
            gregorianCalendar2.add(5, (int)l4);
            gregorianCalendar2.add(12, (int)l6);
            gregorianCalendar2.add(14, (int)(l5 %= 60000L));
            gregorianCalendar2.getTime();
            if (this.isYearMonth) {
                int n2 = (gregorianCalendar2.get(1) - gregorianCalendar.get(1)) * 12 + gregorianCalendar2.get(2) - gregorianCalendar.get(2);
                oXMLItem3.setDuration(this.getReturnType(), n2, 0.0);
            } else {
                oXMLItem3.setDuration(this.getReturnType(), 0, (double)l3 / 1000.0);
            }
            oXMLSequence3.appendItem(oXMLItem3);
        }
        return oXMLSequence3;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length == 2) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        throw new XQException("FORT0001");
    }
}

