/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.HashMap;
import java.util.HashSet;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraCollator;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import oracle.xml.util.XMLUtil;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLNamespace;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class FNUtil {
    static HashMap XDTTYPE = new HashMap(3);
    public static final OXMLSequenceType TNSTRING = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "normalizedString"), 1);
    public static final OXMLSequenceType TTOKEN = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "token"), 1);
    public static final OXMLSequenceType TLANGUAGE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "language"), 1);
    public static final OXMLSequenceType TNMTOKEN = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NMTOKEN"), 1);
    public static final OXMLSequenceType TNAME = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "Name"), 1);
    public static final OXMLSequenceType TNCNAME = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NCName"), 1);
    public static final OXMLSequenceType TID = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ID"), 1);
    public static final OXMLSequenceType TIDREF = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "IDREF"), 1);
    public static final OXMLSequenceType TENTITY = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ENTITY"), 1);
    public static final OXMLSequenceType TNPINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger"), 1);
    public static final OXMLSequenceType TNINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "negativeInteger"), 1);
    public static final OXMLSequenceType TLONG = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "long"), 1);
    public static final OXMLSequenceType TINT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "int"), 1);
    public static final OXMLSequenceType TSHORT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "short"), 1);
    public static final OXMLSequenceType TBYTE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "byte"), 1);
    public static final OXMLSequenceType TNNINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger"), 1);
    public static final OXMLSequenceType TULONG = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedLong"), 1);
    public static final OXMLSequenceType TUINT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedInt"), 1);
    public static final OXMLSequenceType TUSHORT = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedShort"), 1);
    public static final OXMLSequenceType TUBYTE = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "unsignedByte"), 1);
    public static final OXMLSequenceType TPINTEGER = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), 1);
    public static final OXMLSequenceType TIDREFS = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "IDREFS"), 1);
    public static final OXMLSequenceType TENTITIES = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "ENTITIES"), 1);
    public static final OXMLSequenceType TNMTOKENS = OXMLSequenceType.createValueType(new QxName("http://www.w3.org/2001/XMLSchema", "NMTOKENS"), 1);
    static HashMap XSDTYPE = new HashMap(43);
    public static final String CODEPOINT_COLLA = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private static char[] HEX_CHAR;

    public static void main(String[] stringArray) {
        boolean bl = TPINTEGER.isOfType(OXMLSequenceType.TINTEGER);
        boolean bl2 = TLANGUAGE.isOfType(OXMLSequenceType.TSTRING);
        boolean bl3 = TUINT.isOfType(TSHORT);
        System.out.println(bl + " " + bl2 + " " + bl3);
    }

    static OXMLItem getSingleItem(OXMLSequence oXMLSequence) throws XQException {
        if (!oXMLSequence.next()) {
            throw new XQException("XPTY0004");
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException("XPTY0004");
        }
        return oXMLItem;
    }

    static OXMLItem getEmptyOrSingleItem(OXMLSequence oXMLSequence) throws XQException {
        if (!oXMLSequence.next()) {
            return null;
        }
        OXMLItem oXMLItem = oXMLSequence.getItem();
        if (oXMLSequence.next()) {
            throw new XQException("XPTY0004");
        }
        return oXMLItem;
    }

    public static Node getFirstElement(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            return node2;
        }
        return null;
    }

    public static Node getOnlyElementChild(Node node) {
        boolean bl = false;
        Node node2 = null;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            if (node3.getNodeType() != 1) continue;
            if (!bl) {
                bl = true;
                node2 = node3;
                continue;
            }
            return null;
        }
        return node2;
    }

    private static XMLNode getNextElementOrTextSibling(XMLNode xMLNode) {
        for (Node node = xMLNode.getNextSibling(); node != null; node = node.getNextSibling()) {
            switch (FNUtil.getNodeType(node)) {
                case 1: 
                case 3: 
                case 4: {
                    return (XMLNode)node;
                }
            }
        }
        return null;
    }

    private static XMLNode getFirstElementOrTextChild(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (FNUtil.getNodeType(node2)) {
                case 1: 
                case 3: 
                case 4: {
                    return (XMLNode)node2;
                }
            }
        }
        return null;
    }

    public static void checkCollation(String string) throws XQException {
        if (!string.equals(CODEPOINT_COLLA) && OraBoot.getInstance().getLinguisticFileName(string) == null) {
            throw new XQException("FOCH0002");
        }
    }

    public static OXMLCollator getCollator(String string, String string2) throws XQException {
        if (string == null || string.equals(CODEPOINT_COLLA)) {
            return OXMLCollator.newInstance(OraCollator.getInstance((String)"BINARY", (String)"AL32UTF8"));
        }
        try {
            return OXMLCollator.newInstance(OraCollator.getInstance((String)string, (String)(string2 == null ? "AL32UTF8" : string2)));
        }
        catch (Throwable throwable) {
            throw new XQException("FOCH0002");
        }
    }

    static OXMLCollator getSubstringCollator(String string, String string2) throws XQException {
        return FNUtil.getCollator(string, string2);
    }

    private static void checkSubstringCollation(OXMLFunctionContext oXMLFunctionContext, String string) throws XQException {
        if (string == null) {
            return;
        }
        if (string != null) {
            if (string.equals(CODEPOINT_COLLA)) {
                return;
            }
            if (string.compareToIgnoreCase("BINARY") == 0) {
                String string2 = oXMLFunctionContext.getDBCharSet();
                if (string2 == null) {
                    return;
                }
                if (string2.equals("AL32UTF8") || string2.equals("US7ASCII") || string2.equals("WE8ISO8859P1")) {
                    return;
                }
            }
        }
        throw new XQException("FOCH0004");
    }

    public static int getUNFMode(String string) throws XQException {
        if (string != null) {
            String string2 = string.trim().toUpperCase();
            if (string2.equals("NFC")) {
                return 1;
            }
            if (string2.equals("NFD")) {
                return 0;
            }
            if (string2.equals("NFKC")) {
                return 3;
            }
            if (string2.equals("NFKD")) {
                return 2;
            }
            if (string2.equals("NONE")) {
                return 65536;
            }
            if (string2.equals("FULLY-NORMALIZED")) {
                return 65537;
            }
        }
        throw new XQException("FOCH0003");
    }

    private static QxName getQName(Node node) {
        String string = node.getNodeName();
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        QxName qxName = null;
        qxName = n2 > 0 ? new QxName(node.getNamespaceURI(), string.substring(n2 + 1)) : new QxName("", string);
        return qxName;
    }

    public static QxName getNodeQName(XMLNode xMLNode) {
        QxName qxName = null;
        switch (xMLNode.getNodeType()) {
            case 1: 
            case 2: 
            case 7: {
                qxName = xMLNode.getQName();
                break;
            }
            default: {
                if (!(xMLNode instanceof XSLNamespace)) break;
                String string = xMLNode.getNodeName();
                qxName = string.equals("xmlns") ? new QxName("", "") : (string.startsWith("xmlns:") ? new QxName("", string.substring(6)) : new QxName("", string));
            }
        }
        return qxName;
    }

    private static String getLocalPart(Node node) {
        String string = node.getNodeName();
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(58);
        String string2 = n2 > 0 ? string.substring(n2 + 1) : string;
        return string2;
    }

    static String getNodeName(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                string = "";
                break;
            }
            case 7: {
                string = ((ProcessingInstruction)node).getTarget();
                break;
            }
            default: {
                string = node.getNodeName();
            }
        }
        return string;
    }

    static String getLocalName(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "";
                break;
            }
            case 7: {
                string = ((ProcessingInstruction)node).getTarget();
                break;
            }
            default: {
                string = FNUtil.getLocalPart(node);
            }
        }
        return string;
    }

    static String recGetAttribute(Node node, String string, String string2) {
        String string3 = null;
        if (node.getNodeType() == 1 && (string3 = ((Element)node).getAttributeNS(string, string2)) != null && string3.length() != 0) {
            return string3;
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            string3 = FNUtil.recGetAttribute(node2, string, string2);
        }
        return string3;
    }

    static Node getRoot(Node node) {
        Node node2 = node;
        Node node3 = FNUtil.getParentNode(node);
        if (node3 != null) {
            node2 = FNUtil.getRoot(node3);
        }
        return node2;
    }

    private static Node getParentNode(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    public static boolean isNode(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() == 90;
    }

    public static boolean isUntypedAtomic(OXMLItem oXMLItem) {
        return oXMLItem.getPrimitiveType() == 0;
    }

    private static boolean recEqualNode(XMLNode xMLNode, XMLNode xMLNode2) {
        int n2;
        int n3 = FNUtil.getNodeType(xMLNode);
        if (n3 != (n2 = FNUtil.getNodeType(xMLNode2))) {
            return false;
        }
        QxName qxName = xMLNode.getQName();
        QxName qxName2 = xMLNode2.getQName();
        if (qxName != null && qxName2 != null && !qxName.equals(qxName2)) {
            return false;
        }
        switch (n3) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 99: {
                return xMLNode.getNodeValue().equals(xMLNode2.getNodeValue());
            }
            case 1: {
                NamedNodeMap namedNodeMap = xMLNode.getAttributes();
                NamedNodeMap namedNodeMap2 = xMLNode2.getAttributes();
                Object object = null;
                Node node = null;
                int n4 = -1;
                if (namedNodeMap != null) {
                    object = namedNodeMap;
                    node = (Element)((Object)xMLNode2);
                    n4 = namedNodeMap2 == null ? 0 : namedNodeMap2.getLength();
                } else if (namedNodeMap2 != null) {
                    object = namedNodeMap2;
                    node = (Element)((Object)xMLNode);
                    n4 = 0;
                }
                if (object != null) {
                    String string;
                    Object object2;
                    int n5;
                    int n6 = object.getLength();
                    int n7 = 0;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Attr attr = (Attr)object.item(n5);
                        object2 = attr.getNodeName();
                        if (((String)object2).equals("xmlns") || ((String)object2).startsWith("xmlns:")) continue;
                        ++n7;
                        string = node.getAttribute((String)object2);
                        if (string != null && string.equals(attr.getNodeValue())) continue;
                        return false;
                    }
                    n5 = 0;
                    if (n4 != 0) {
                        for (int i2 = 0; i2 < n6; ++i2) {
                            object2 = (Attr)namedNodeMap2.item(i2);
                            string = object2.getNodeName();
                            if (string.equals("xmlns") || string.startsWith("xmlns:")) continue;
                            ++n5;
                        }
                    }
                    if (n7 != n5) {
                        return false;
                    }
                }
            }
            case 9: {
                int n4;
                Node node;
                Object object;
                boolean bl = xMLNode.hasChildNodes();
                boolean bl2 = xMLNode2.hasChildNodes();
                if (bl && bl2) {
                    object = FNUtil.getFirstElementOrTextChild(xMLNode);
                    node = FNUtil.getFirstElementOrTextChild(xMLNode2);
                    n4 = 0;
                    do {
                        if (!FNUtil.recEqualNode((XMLNode)object, (XMLNode)node)) {
                            return false;
                        }
                        object = FNUtil.getNextElementOrTextSibling((XMLNode)object);
                        node = FNUtil.getNextElementOrTextSibling((XMLNode)node);
                    } while (object != null && node != null);
                    if (object == null && node == null) break;
                    return false;
                }
                if (!bl && !bl2) break;
                return false;
            }
        }
        return true;
    }

    static boolean isEqualNode(XMLNode xMLNode, XMLNode xMLNode2) {
        return FNUtil.recEqualNode(xMLNode, xMLNode2);
    }

    static int getNodeType(Node node) {
        int n2 = -1;
        switch (node.getNodeType()) {
            case 11: {
                n2 = 9;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 2: {
                String string = node.getNodeName();
                if (string.startsWith("xmlns:") || string.equals("xmlns")) {
                    n2 = 99;
                    break;
                }
                n2 = 2;
                break;
            }
            default: {
                n2 = node.getNodeType();
            }
        }
        return n2;
    }

    static String getNodeKind(Node node) {
        String string = null;
        switch (node.getNodeType()) {
            case 1: {
                string = "element";
                break;
            }
            case 8: {
                string = "comment";
                break;
            }
            case 7: {
                string = "processing-instruction";
                break;
            }
            case 9: 
            case 11: {
                string = "document";
                break;
            }
            case 3: 
            case 4: {
                string = "text";
                break;
            }
            case 2: {
                String string2 = node.getNodeName();
                string = string2.startsWith("xmlns:") || string2.equals("xmlns") ? "namespace" : "attribute";
            }
        }
        return string;
    }

    static String getNamespaceURI(String string, Element element) {
        String string2;
        String string3;
        int n2 = string == null ? 0 : string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 6);
        stringBuffer.append("xmlns");
        if (n2 != 0) {
            stringBuffer.append(':').append(string);
        }
        if ((string3 = element.getAttribute(string2 = stringBuffer.toString())) != null && string3.length() != 0) {
            return string3;
        }
        for (Node node = element.getParentNode(); node != null; node = node.getParentNode()) {
            String string4;
            if (node.getNodeType() != 1 || (string4 = ((Element)node).getAttribute(string2)) == null || string4.length() == 0) continue;
            return string4;
        }
        return null;
    }

    static void getPrefixes(Node node, HashSet hashSet) {
        NamedNodeMap namedNodeMap;
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            FNUtil.getPrefixes(node.getParentNode(), hashSet);
            return;
        }
        Element element = (Element)node;
        String string = element.getPrefix();
        String string2 = element.getNamespaceURI();
        if (string2 != null && !string2.equals("")) {
            hashSet.add(string == null ? "" : string);
        }
        int n2 = (namedNodeMap = element.getAttributes()) == null ? 0 : namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            String string3 = attr.getNodeName();
            if (string3.equals("xmlns")) {
                hashSet.add("");
                continue;
            }
            if (!string3.startsWith("xmlns:")) continue;
            hashSet.add(string3.substring(6));
        }
        FNUtil.getPrefixes(node.getParentNode(), hashSet);
    }

    public static int compareNodeOrder(XMLNode xMLNode, XMLNode xMLNode2) {
        short s2 = xMLNode.compareDocumentPosition(xMLNode2);
        int n2 = 1;
        n2 = (s2 & 2) == 2 || (s2 & 8) == 8 ? 1 : ((s2 & 4) == 4 || (s2 & 0x10) == 16 ? -1 : 0);
        return n2;
    }

    static boolean isWhitespace(char c2) {
        switch (c2) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static byte[] decodeHex(String string) {
        char[] cArray = string.toCharArray();
        if ((cArray.length & 1) != 0) {
            throw new XQException("FORG0001");
        }
        byte[] byArray = new byte[cArray.length / 2];
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; i2 += 2) {
            int n3 = Character.digit(cArray[i2], 16) << 4;
            byArray[n2++] = (byte)((n3 |= Character.digit(cArray[i2 + 1], 16)) & 0xFF);
        }
        return byArray;
    }

    public static String encodeHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            cArray[n2++] = HEX_CHAR[(byArray[i2] & 0xF0) >>> 4];
            cArray[n2++] = HEX_CHAR[byArray[i2] & 0xF];
        }
        return new String(cArray);
    }

    public static String escape(String string, int n2) {
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (n2 == 18 && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '-' || c2 == '_' || c2 == '.' || c2 == '~')) {
                stringBuffer.append(c2);
                continue;
            }
            if (n2 == 20 && c2 >= ' ' && c2 <= '~') {
                stringBuffer.append(c2);
                continue;
            }
            if (n2 == 21 && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 == '-' || c2 == '_' || c2 == '.' || c2 == '!' || c2 == '~' || c2 == '*' || c2 == '\'' || c2 == '(' || c2 == ')' || c2 == '%' || c2 == '#' || c2 == ';' || c2 == '/' || c2 == '?' || c2 == ':' || c2 == '@' || c2 == '&' || c2 == '=' || c2 == '+' || c2 == '$' || c2 == ',' || c2 == '[' || c2 == ']')) {
                stringBuffer.append(c2);
                continue;
            }
            try {
                byte[] byArray = null;
                if ((c2 & 0xFC00) == 55296 && i2 + 1 < n3) {
                    byArray = new String(new char[]{c2, string.charAt(i2 + 1)}).getBytes("UTF-8");
                    ++i2;
                } else {
                    byArray = string.substring(i2, i2 + 1).getBytes("UTF-8");
                }
                for (int i3 = 0; i3 < byArray.length; ++i3) {
                    int n4 = byArray[i3] & 0xFF;
                    stringBuffer.append('%');
                    stringBuffer.append(HEX_CHAR[n4 >> 4 & 0xF]);
                    stringBuffer.append(HEX_CHAR[n4 & 0xF]);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public static String encodeBase64(byte[] byArray) {
        String string = XMLUtil.printBase64Binary(byArray);
        return string;
    }

    public static byte[] decodeBase64(String string) {
        byte[] byArray = XMLUtil.parseBase64Binary(string);
        return byArray;
    }

    public static boolean validateNCName(String string) {
        boolean bl = true;
        if (string.indexOf(58) != -1) {
            bl = false;
        }
        try {
            XMLUtil.validateName(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean validateSurrogateSequence(String string) {
        boolean bl = true;
        int n2 = string.length();
        char c2 = '\u0000';
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (Character.isHighSurrogate(c2)) {
                bl2 = true;
                continue;
            }
            if (Character.isLowSurrogate(c2) && bl2) {
                bl2 = false;
                continue;
            }
            if (Character.isLowSurrogate(c2)) {
                bl = false;
                break;
            }
            if (!bl2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    static {
        XSDTYPE.put("string", OXMLSequenceType.TSTRING);
        XSDTYPE.put("boolean", OXMLSequenceType.TBOOLEAN);
        XSDTYPE.put("decimal", OXMLSequenceType.TDECIMAL);
        XSDTYPE.put("float", OXMLSequenceType.TFLOAT);
        XSDTYPE.put("double", OXMLSequenceType.TDOUBLE);
        XSDTYPE.put("QName", OXMLSequenceType.TQNAME);
        XSDTYPE.put("duration", OXMLSequenceType.TDURATION);
        XSDTYPE.put("dateTime", OXMLSequenceType.TDATETIME);
        XSDTYPE.put("time", OXMLSequenceType.TTIME);
        XSDTYPE.put("date", OXMLSequenceType.TDATE);
        XSDTYPE.put("gYearMonth", OXMLSequenceType.TGYEARMONTH);
        XSDTYPE.put("gYear", OXMLSequenceType.TGYEAR);
        XSDTYPE.put("gMonthDay", OXMLSequenceType.TGMONTHDAY);
        XSDTYPE.put("gDay", OXMLSequenceType.TGDAY);
        XSDTYPE.put("gMonth", OXMLSequenceType.TGMONTH);
        XSDTYPE.put("hexBinary", OXMLSequenceType.THEXBINARY);
        XSDTYPE.put("base64Binary", OXMLSequenceType.TBASE64BINARY);
        XSDTYPE.put("anyURI", OXMLSequenceType.TANYURI);
        XSDTYPE.put("NOTATION", OXMLSequenceType.TNOTATION);
        XSDTYPE.put("normalizedString", TNSTRING);
        XSDTYPE.put("token", TTOKEN);
        XSDTYPE.put("language", TLANGUAGE);
        XSDTYPE.put("NMTOKEN", TNMTOKEN);
        XSDTYPE.put("Name", TNAME);
        XSDTYPE.put("NCName", TNCNAME);
        XSDTYPE.put("ID", TID);
        XSDTYPE.put("IDREF", TIDREF);
        XSDTYPE.put("ENTITY", TENTITY);
        XSDTYPE.put("integer", OXMLSequenceType.TINTEGER);
        XSDTYPE.put("nonPositiveInteger", TNPINTEGER);
        XSDTYPE.put("negativeInteger", TNINTEGER);
        XSDTYPE.put("long", TLONG);
        XSDTYPE.put("int", TINT);
        XSDTYPE.put("short", TSHORT);
        XSDTYPE.put("byte", TBYTE);
        XSDTYPE.put("nonNegativeInteger", TNNINTEGER);
        XSDTYPE.put("unsignedLong", TULONG);
        XSDTYPE.put("unsignedInt", TUINT);
        XSDTYPE.put("unsignedShort", TUSHORT);
        XSDTYPE.put("unsignedByte", TUBYTE);
        XSDTYPE.put("positiveInteger", TPINTEGER);
        XSDTYPE.put("yearMonthDuration", OXMLSequenceType.TYMDURATION);
        XSDTYPE.put("dayTimeDuration", OXMLSequenceType.TDTDURATION);
        XSDTYPE.put("untypedAtomic", OXMLSequenceType.TUNTYPED);
        HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

