/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.sql.Connection;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.xpath.XPathConvertAsExpr;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;
import org.xml.sax.SAXException;

public class XSLDocumentBuilder
extends DocumentBuilder {
    XMLElement result = null;
    boolean disableOutEsc = false;
    boolean inVariableCtx = false;
    XPathSequence sequence = null;
    XPathConvertAsExpr convertor = null;
    XSLTContext context = null;
    private boolean isTransformer = false;
    private boolean converted = true;
    private boolean seenRoot = false;

    public XSLDocumentBuilder() {
        this.docf = this.doc = new XMLDocument();
        this.doc.setNodeFlag(0x100000);
        this.doc.setDocOrdered(true);
        this.result = (XMLDocumentFragment)this.doc.createDocumentFragment();
        this.setFragmentRoot(this.result);
    }

    public XSLDocumentBuilder(Connection connection) {
        this.docf = this.doc = new XMLDocument(connection, null);
        this.result = (XMLDocumentFragment)this.doc.createDocumentFragment();
        this.setFragmentRoot(this.result);
    }

    public XSLDocumentBuilder(XMLElement xMLElement) {
        this.result = xMLElement;
        this.setFragmentRoot(this.result);
        this.docf = this.doc = xMLElement.getDocument();
    }

    @Override
    public void reset() {
        XMLDocument xMLDocument = this.doc;
        super.reset();
        this.docf = this.doc = xMLDocument;
        this.result = (XMLDocumentFragment)this.doc.createDocumentFragment();
        this.disableOutEsc = false;
        this.inVariableCtx = false;
        this.setFragmentRoot(this.result);
        this.context = null;
        this.sequence = null;
        this.convertor = null;
        this.converted = true;
    }

    void setSequenceConstructor(XSLTContext xSLTContext, XPathConvertAsExpr xPathConvertAsExpr) {
        this.sequence = (XPathSequence)xSLTContext.createSequence();
        this.convertor = xPathConvertAsExpr;
        if (this.convertor != null) {
            this.converted = false;
        }
        this.context = xSLTContext;
    }

    boolean isSequenceConstructor() {
        return this.sequence != null;
    }

    protected void setIsTransformer(boolean bl) {
        this.isTransformer = bl;
    }

    public OXMLSequence getResultSequence() throws XSLException, XQException {
        if (this.sequence == null) {
            return null;
        }
        this.flushSequence();
        if (!this.converted) {
            this.convertor.convert(this.sequence);
            this.converted = true;
        }
        return this.sequence;
    }

    public XMLDocumentFragment getResultFragment() {
        if (this.result instanceof XMLDocumentFragment) {
            return (XMLDocumentFragment)this.result;
        }
        return null;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.isTransformer) {
            super.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.isTransformer) {
            super.endDocument();
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.disableOutEsc && this.inVariableCtx) {
            XMLText xMLText = (XMLText)this.docf.createTextNode(cArray, n2, n3);
            this.addChild(xMLText);
            xMLText.setProperty("oracle.xml.disable-output-escaping", Boolean.TRUE);
        } else {
            super.characters(cArray, n2, n3);
        }
    }

    void sequence(OXMLSequence oXMLSequence) throws XSLException {
        this.flushSequence();
        while (oXMLSequence.next()) {
            this.sequence.appendItem(((XPathItem)oXMLSequence.getItem()).copy());
        }
    }

    @Override
    public void comment(String string) throws SAXException {
        super.comment(string);
    }

    void attribute(String string, String string2, String string3) throws XSLException {
        XMLAttr xMLAttr = (XMLAttr)this.docf.createAttributeNS(string, string2);
        xMLAttr.setValue(string3);
        XPathItem xPathItem = this.context.allocItem();
        xPathItem.setNode(xMLAttr);
        this.sequence.appendItem(xPathItem);
    }

    void document() throws XSLException {
        if (this.sequence == null) {
            return;
        }
        this.flushSequence();
        this.seenRoot = true;
        this.result = (XMLDocumentFragment)this.doc.createDocumentFragment();
        this.setFragmentRoot(this.result);
    }

    void setDisableOutEsc(boolean bl) {
        this.disableOutEsc = bl;
    }

    void setVariableContext(boolean bl) {
        this.inVariableCtx = bl;
    }

    private void flushSequence() {
        if (this.seenRoot) {
            XPathItem xPathItem = this.context.allocItem();
            xPathItem.setNode(this.result);
            this.sequence.appendItem(xPathItem);
            this.result = (XMLDocumentFragment)this.doc.createDocumentFragment();
            this.setFragmentRoot(this.result);
            this.seenRoot = false;
        } else {
            for (XMLNode xMLNode = (XMLNode)this.result.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
                XPathItem xPathItem = this.context.allocItem();
                xPathItem.setNode(xMLNode);
                this.sequence.appendItem(xPathItem);
                XMLNode xMLNode2 = xMLNode;
                this.result.removeChild(xMLNode2);
            }
        }
    }
}

