/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.tables.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.formatter.CustomNodeFormatter;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.formatter.TranslatingSpanRender;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.MarkdownTable;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class TableNodeFormatter
implements NodeFormatter {
    private final TableFormatOptions options;
    private final boolean isIntellijDummyIdentifier;
    private final String intellijDummyIdentifier;
    private final boolean parserTrimCellWhiteSpace;
    private MarkdownTable myTable;

    public TableNodeFormatter(DataHolder options) {
        this.options = new TableFormatOptions(options);
        this.isIntellijDummyIdentifier = (Boolean)Parser.INTELLIJ_DUMMY_IDENTIFIER.getFrom(options);
        this.intellijDummyIdentifier = this.isIntellijDummyIdentifier ? "\u001f" : "";
        this.parserTrimCellWhiteSpace = (Boolean)TablesExtension.TRIM_CELL_WHITESPACE.getFrom(options);
    }

    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        return new HashSet(Arrays.asList(new NodeFormattingHandler(TableBlock.class, (CustomNodeFormatter)new CustomNodeFormatter<TableBlock>(){

            public void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableHead.class, (CustomNodeFormatter)new CustomNodeFormatter<TableHead>(){

            public void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableSeparator.class, (CustomNodeFormatter)new CustomNodeFormatter<TableSeparator>(){

            public void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableBody.class, (CustomNodeFormatter)new CustomNodeFormatter<TableBody>(){

            public void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableRow.class, (CustomNodeFormatter)new CustomNodeFormatter<TableRow>(){

            public void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableCell.class, (CustomNodeFormatter)new CustomNodeFormatter<TableCell>(){

            public void render(TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(TableCaption.class, (CustomNodeFormatter)new CustomNodeFormatter<TableCaption>(){

            public void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        }), new NodeFormattingHandler(Text.class, (CustomNodeFormatter)new CustomNodeFormatter<Text>(){

            public void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
                TableNodeFormatter.this.render(node, context, markdown);
            }
        })));
    }

    private void render(TableBlock node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable = new MarkdownTable(this.options);
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: 
            case TRANSLATED_SPANS: 
            case TRANSLATED: {
                markdown.blankLine();
                context.renderChildren((Node)node);
                markdown.tailBlankLine();
                break;
            }
            default: {
                Map offsets;
                context.renderChildren((Node)node);
                if (this.options.tableManipulator != TableManipulator.NULL) {
                    this.myTable.normalize();
                    this.options.tableManipulator.apply(this.myTable, (Node)node);
                }
                if (this.myTable.getMaxColumns() <= 0) break;
                markdown.blankLine();
                this.myTable.appendTable((LineFormattingAppendable)markdown);
                markdown.tailBlankLine();
                if (!this.options.dumpIntellijOffsets || (offsets = this.myTable.getTrackedOffsets()).size() <= 0) break;
                ((MarkdownWriter)markdown.append((CharSequence)"\nTracked Offsets")).line();
                String sep = "  ";
                int i = 0;
                for (Map.Entry offset : offsets.entrySet()) {
                    ((MarkdownWriter)markdown.append((CharSequence)sep)).append((CharSequence)String.format(Locale.US, "%d:[%d,%d] was:[%d,%d]", ++i, offset.getValue(), (Integer)offset.getValue() + 1, offset.getKey(), (Integer)offset.getKey() + 1));
                    sep = " ";
                }
                markdown.append((CharSequence)"\n");
            }
        }
        this.myTable = null;
    }

    private void render(TableHead node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(true);
        context.renderChildren((Node)node);
    }

    private void render(TableSeparator node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(true);
        context.renderChildren((Node)node);
    }

    private void render(TableBody node, NodeFormatterContext context, MarkdownWriter markdown) {
        this.myTable.setSeparator(false);
        this.myTable.setHeader(false);
        context.renderChildren((Node)node);
    }

    private void render(TableRow node, NodeFormatterContext context, MarkdownWriter markdown) {
        context.renderChildren((Node)node);
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            if (!this.myTable.isSeparator()) {
                this.myTable.nextRow();
            }
        } else {
            markdown.line();
        }
    }

    private void render(TableCaption node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            this.myTable.setCaptionWithMarkers((CharSequence)node.getOpeningMarker(), (CharSequence)node.getText(), (CharSequence)node.getClosingMarker());
        } else {
            String dummyCaption = node.hasChildren() ? "dummy" : "";
            String formattedCaption = MarkdownTable.formattedCaption((BasedSequence)BasedSequenceImpl.of((CharSequence)dummyCaption), (TableFormatOptions)this.options);
            if (formattedCaption != null) {
                ((MarkdownWriter)markdown.line()).append((CharSequence)node.getOpeningMarker());
                context.renderChildren((Node)node);
                ((MarkdownWriter)markdown.append((CharSequence)node.getClosingMarker())).line();
            }
        }
    }

    private void render(final TableCell node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (context.getRenderPurpose() == RenderPurpose.FORMAT) {
            BasedSequence text = node.getText();
            if (this.options.trimCellWhitespace) {
                text = text.isBlank() && !text.isEmpty() ? (BasedSequence)text.subSequence(0, 1) : (BasedSequence)text.trim();
            }
            this.myTable.addCell(new com.vladsch.flexmark.util.format.TableCell((CharSequence)node.getOpeningMarker(), (CharSequence)text, (CharSequence)node.getClosingMarker(), 1, node.getSpan(), node.getAlignment() == null ? CellAlignment.NONE : node.getAlignment().cellAlignment()));
        } else {
            if (node.getPrevious() == null) {
                if (this.options.leadTrailPipes && node.getOpeningMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append((CharSequence)node.getOpeningMarker());
                }
            } else {
                markdown.append((CharSequence)node.getOpeningMarker());
            }
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!node.getText().startsWith((CharSequence)" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            final String[] childText = new String[]{""};
            context.translatingSpan(new TranslatingSpanRender(){

                public void render(NodeFormatterContext context, MarkdownWriter writer) {
                    context.renderChildren((Node)node);
                    childText[0] = writer.toString(-1);
                }
            });
            if (!this.myTable.isSeparator() && this.options.spaceAroundPipes && (!childText[0].endsWith(" ") || this.parserTrimCellWhiteSpace)) {
                markdown.append(' ');
            }
            if (node.getNext() == null) {
                if (this.options.leadTrailPipes && node.getClosingMarker().isEmpty()) {
                    markdown.append('|');
                } else {
                    markdown.append((CharSequence)node.getClosingMarker());
                }
            } else {
                markdown.append((CharSequence)node.getClosingMarker());
            }
        }
    }

    private void render(Text node, NodeFormatterContext context, MarkdownWriter markdown) {
        if (this.myTable != null && this.myTable.isSeparator()) {
            Node parent = node.getAncestorOfType(new Class[]{Paragraph.class});
            if (parent instanceof Paragraph && ((Paragraph)parent).hasTableSeparator()) {
                ((MarkdownWriter)((MarkdownWriter)((MarkdownWriter)markdown.pushPrefix()).addPrefix((CharSequence)" ")).append((CharSequence)node.getChars())).popPrefix();
            } else {
                markdown.append((CharSequence)node.getChars());
            }
        } else {
            markdown.append((CharSequence)node.getChars());
        }
    }

    public static class Factory
    implements NodeFormatterFactory {
        public NodeFormatter create(DataHolder options) {
            return new TableNodeFormatter(options);
        }
    }
}

