/*
 * Decompiled with CFR 0.152.
 */
package com.wuwenze.poi.util;

import com.wuwenze.poi.config.Options;
import com.wuwenze.poi.exception.ExcelKitRuntimeException;
import com.wuwenze.poi.util.ValidatorUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class POIUtil {
    private static final int mDefaultRowAccessWindowSize = 100;

    private static SXSSFWorkbook newSXSSFWorkbook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static SXSSFWorkbook newSXSSFWorkbook() {
        return POIUtil.newSXSSFWorkbook(100);
    }

    public static SXSSFSheet newSXSSFSheet(SXSSFWorkbook wb, String sheetName) {
        return wb.createSheet(sheetName);
    }

    public static SXSSFRow newSXSSFRow(SXSSFSheet sheet, int index) {
        return sheet.createRow(index);
    }

    public static SXSSFCell newSXSSFCell(SXSSFRow row, int index) {
        return row.createCell(index);
    }

    public static void setColumnWidth(SXSSFSheet sheet, int index, Short width, String value) {
        boolean widthNotHaveConfig;
        boolean bl = widthNotHaveConfig = null == width || width == -1;
        if (widthNotHaveConfig && !ValidatorUtil.isEmpty(value)) {
            sheet.setColumnWidth(index, (int)((short)(value.length() * 2048)));
        } else {
            width = widthNotHaveConfig ? (short)200 : (short)width;
            sheet.setColumnWidth(index, (int)((short)((double)width.shortValue() * 35.7)));
        }
    }

    public static void setColumnCellRange(SXSSFSheet sheet, Options options, int firstRow, int endRow, int firstCell, int endCell) {
        String[] datasource;
        if (null != options && null != (datasource = options.get()) && datasource.length > 0) {
            if (datasource.length > 100) {
                throw new ExcelKitRuntimeException("Options item too much.");
            }
            DataValidationHelper validationHelper = sheet.getDataValidationHelper();
            DataValidationConstraint explicitListConstraint = validationHelper.createExplicitListConstraint(datasource);
            CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCell, endCell);
            DataValidation validation = validationHelper.createValidation(explicitListConstraint, regions);
            validation.setSuppressDropDownArrow(true);
            validation.createErrorBox("\u63d0\u793a", "\u8bf7\u4ece\u4e0b\u62c9\u5217\u8868\u9009\u53d6");
            validation.setShowErrorBox(true);
            sheet.addValidationData(validation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(SXSSFWorkbook wb, OutputStream out) {
        try {
            if (null != out) {
                wb.write(out);
                out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void download(SXSSFWorkbook wb, HttpServletResponse response, String filename) {
        try {
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-disposition", String.format("attachment; filename=%s", filename));
            POIUtil.write(wb, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Object convertByExp(Object propertyValue, String converterExp) throws Exception {
        String[] convertSource;
        for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return propertyValue;
    }

    public static int countNullCell(String ref, String ref2) {
        String xfd = ref.replaceAll("\\d+", "");
        String xfd_1 = ref2.replaceAll("\\d+", "");
        xfd = POIUtil.fillChar(xfd, 3, '@', true);
        xfd_1 = POIUtil.fillChar(xfd_1, 3, '@', true);
        char[] letter = xfd.toCharArray();
        char[] letter_1 = xfd_1.toCharArray();
        int res = (letter[0] - letter_1[0]) * 26 * 26 + (letter[1] - letter_1[1]) * 26 + (letter[2] - letter_1[2]);
        return res - 1;
    }

    private static String fillChar(String str, int len, char let, boolean isPre) {
        block4: {
            int len_1 = str.length();
            if (len_1 >= len) break block4;
            if (isPre) {
                for (int i = 0; i < len - len_1; ++i) {
                    str = let + str;
                }
            } else {
                for (int i = 0; i < len - len_1; ++i) {
                    str = str + let;
                }
            }
        }
        return str;
    }

    public static void checkExcelFile(File file) {
        String filename;
        String string = filename = null != file ? file.getAbsolutePath() : null;
        if (null == filename || !file.exists()) {
            throw new ExcelKitRuntimeException("Excel file[" + filename + "] does not exist.");
        }
        if (!filename.endsWith(".xlsx")) {
            throw new ExcelKitRuntimeException("[" + filename + "]Only .xlsx formatted files are supported.");
        }
    }

    private POIUtil() {
    }
}

