/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.handler.impl;

import com.xxl.job.core.handler.IJobHandler;
import java.lang.reflect.Method;

public class MethodJobHandler
extends IJobHandler {
    private final Object target;
    private final Method method;
    private Method initMethod;
    private Method destroyMethod;

    public MethodJobHandler(Object target, Method method, Method initMethod, Method destroyMethod) {
        this.target = target;
        this.method = method;
        this.initMethod = initMethod;
        this.destroyMethod = destroyMethod;
    }

    @Override
    public void execute() throws Exception {
        Class<?>[] paramTypes = this.method.getParameterTypes();
        if (paramTypes.length > 0) {
            this.method.invoke(this.target, new Object[paramTypes.length]);
        } else {
            this.method.invoke(this.target, new Object[0]);
        }
    }

    @Override
    public void init() throws Exception {
        if (this.initMethod != null) {
            this.initMethod.invoke(this.target, new Object[0]);
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.destroyMethod != null) {
            this.destroyMethod.invoke(this.target, new Object[0]);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.target.getClass() + "#" + this.method.getName() + "]";
    }
}

