/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.ColorPickerConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.ColorPickerTextFieldCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.ColorPickerTextFieldJavaScriptReference;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestHandler;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;

public class ColorPickerTextField
extends TextField<String> {
    private static final long serialVersionUID = 1L;
    private boolean wasEnhanced = false;
    private final ColorPickerConfig config;

    public ColorPickerTextField(String id) {
        this(id, null, new ColorPickerConfig());
    }

    public ColorPickerTextField(String id, IModel<String> model) {
        this(id, model, new ColorPickerConfig());
    }

    public ColorPickerTextField(String id, IModel<String> model, ColorPickerConfig config) {
        super(id, model, String.class);
        this.config = config;
        this.setOutputMarkupId(true);
    }

    protected void onConfigure() {
        super.onConfigure();
        List behaviors = this.getBehaviors(ColorChangeAjaxBehavior.class);
        if (this.config.isAjaxUpdate()) {
            if (behaviors.isEmpty()) {
                this.add(new Behavior[]{new ColorChangeAjaxBehavior(){

                    @Override
                    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                        super.updateAjaxAttributes(attributes);
                        ColorPickerTextField.this.updateAjaxAttributes(attributes);
                    }

                    @Override
                    protected void onChange(AjaxRequestTarget target, String color) {
                        ColorPickerTextField.this.onChange(target, color);
                    }
                }});
            }
        } else {
            for (ColorChangeAjaxBehavior colorChangeAjaxBehavior : behaviors) {
                this.remove(new Behavior[]{colorChangeAjaxBehavior});
            }
        }
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected void onChange(AjaxRequestTarget target, String color) {
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)ColorPickerTextFieldCssReference.instance()));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ColorPickerTextFieldJavaScriptReference.instance()));
        if (this.isEnabledInHierarchy()) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.config)));
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"bootstrap-colorpicker"});
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxRequestHandler) {
            AjaxRequestHandler target = (AjaxRequestHandler)event.getPayload();
            target.addListener(new AjaxRequestTarget.IListener(){

                public void onBeforeRespond(Map<String, Component> map, AjaxRequestTarget target) {
                }

                public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget.IJavaScriptResponse response) {
                    if (ColorPickerTextField.this.isEnabledInHierarchy() && !ColorPickerTextField.this.wasEnhanced) {
                        response.addJavaScript(ColorPickerTextField.this.createScript(ColorPickerTextField.this.config));
                        ColorPickerTextField.this.wasEnhanced = true;
                    } else if (!ColorPickerTextField.this.isEnabledInHierarchy()) {
                        ColorPickerTextField.this.wasEnhanced = false;
                    }
                }
            });
        }
    }

    protected String createScript(ColorPickerConfig config) {
        JQuery script = JQuery.$((Component)this);
        if (config.isComponent()) {
            script.closest((CharSequence)".colorpicker-component");
        }
        script.chain((CharSequence)"colorpicker", (Config)config, new Config[0]);
        if (config.isAjaxUpdate()) {
            List behaviors = this.getBehaviors(ColorChangeAjaxBehavior.class);
            ColorChangeAjaxBehavior colorChangeAjaxBehavior = (ColorChangeAjaxBehavior)((Object)behaviors.get(0));
            String toColor = config.getFormat().to();
            CharSequence attrs = colorChangeAjaxBehavior.getAttrs();
            script.on((CharSequence)"changeColor", new JQuery.JavaScriptInlineFunction(String.format("var color = evt.color.%s; new Wicket.Ajax.Call().ajax(%s)", toColor, attrs)));
        }
        return script.get();
    }

    private static abstract class ColorChangeAjaxBehavior
    extends AbstractDefaultAjaxBehavior {
        private ColorChangeAjaxBehavior() {
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.getDynamicExtraParameters().add("return [{name: 'color', value: color}]");
        }

        private CharSequence getAttrs() {
            return this.renderAjaxAttributes(this.getComponent());
        }

        protected void respond(AjaxRequestTarget target) {
            IRequestParameters requestParameters = this.getComponent().getRequest().getRequestParameters();
            StringValue color = requestParameters.getParameterValue("color");
            this.onChange(target, color.toString());
        }

        protected abstract void onChange(AjaxRequestTarget var1, String var2);
    }
}

