/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IO {
    private static Logger logger = LoggerFactory.getLogger(IO.class);

    private IO() {
    }

    public static Optional<String> readString(Path path, Charset charset) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Optional.of(new String(Files.readAllBytes(path), charset));
            }
            catch (IOException e) {
                logger.error("could not read " + path, (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

