/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.TearDown;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="State", generator="Immutables")
public final class ImmutableState<T>
implements State<T> {
    private final T value;
    private final TearDown<T> onTearDown;

    private ImmutableState(T value, TearDown<T> onTearDown) {
        this.value = value;
        this.onTearDown = onTearDown;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public Optional<TearDown<T>> onTearDown() {
        return Optional.ofNullable(this.onTearDown);
    }

    public final ImmutableState<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableState<T>(newValue, this.onTearDown);
    }

    public final ImmutableState<T> withOnTearDown(TearDown<T> value) {
        TearDown<T> newValue = Objects.requireNonNull(value, "onTearDown");
        if (this.onTearDown == newValue) {
            return this;
        }
        return new ImmutableState<T>(this.value, newValue);
    }

    public final ImmutableState<T> withOnTearDown(Optional<? extends TearDown<T>> optional) {
        TearDown value = optional.orElse(null);
        if (this.onTearDown == value) {
            return this;
        }
        return new ImmutableState<T>(this.value, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableState && this.equalTo(0, (ImmutableState)another);
    }

    private boolean equalTo(int synthetic, ImmutableState<?> another) {
        return this.value.equals(another.value) && Objects.equals(this.onTearDown, another.onTearDown);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.onTearDown);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("State{");
        builder.append("value=").append(this.value);
        if (this.onTearDown != null) {
            builder.append(", ");
            builder.append("onTearDown=").append(this.onTearDown);
        }
        return builder.append("}").toString();
    }

    public static <T> ImmutableState<T> copyOf(State<T> instance) {
        if (instance instanceof ImmutableState) {
            return (ImmutableState)instance;
        }
        return ImmutableState.builder().from(instance).build();
    }

    public static <T> Builder<T> builder(T value) {
        return new Builder(value);
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="State", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private T value;
        private TearDown<T> onTearDown;

        private Builder(T value) {
            this.value(value);
        }

        private Builder() {
        }

        public final Builder<T> from(State<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            Optional<TearDown<T>> onTearDownOptional = instance.onTearDown();
            if (onTearDownOptional.isPresent()) {
                this.onTearDown(onTearDownOptional);
            }
            return this;
        }

        final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> onTearDown(TearDown<T> onTearDown) {
            this.onTearDown = Objects.requireNonNull(onTearDown, "onTearDown");
            return this;
        }

        public final Builder<T> onTearDown(Optional<? extends TearDown<T>> onTearDown) {
            this.onTearDown = onTearDown.orElse(null);
            return this;
        }

        public ImmutableState<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableState(this.value, this.onTearDown);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build State, some of required attributes are not set " + attributes;
        }
    }
}

