/*
 * Decompiled with CFR 0.152.
 */
package zio.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.Cause;
import zio.ZIO;
import zio.ZIO$;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Handler;
import zio.http.Handler$;
import zio.http.Header;
import zio.http.Header$ContentType$;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.Http;
import zio.http.Http$FromHttpZIO$;
import zio.http.Http$FromOptionalHandlerZIO$;
import zio.http.MediaType;
import zio.http.MediaType$;
import zio.http.Request;
import zio.http.Response;
import zio.http.Response$;
import zio.http.Status;
import zio.http.internal.HeaderModifier;
import zio.stream.ZStream;
import zio.stream.ZStream$;

public final class Http$ {
    public static Http$ MODULE$;
    private final Http<Object, Nothing$, Object, Nothing$> empty;
    private volatile int bitmap$init$0;

    static {
        new Http$();
    }

    public <In> BoxedUnit collect() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit collectExit() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit collectHandler() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit collectHttp() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit collectZIO() {
        return BoxedUnit.UNIT;
    }

    public Http<Object, Nothing$, Object, Nothing$> empty() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/Http.scala: 543");
        }
        return this.empty;
    }

    public Http<Object, Throwable, Object, Response> fromFile(Function0<File> file, Object trace) {
        return this.fromFileZIO((ZIO<Object, Throwable, File>)ZIO$.MODULE$.succeed(file, trace), trace);
    }

    public Http<Object, Throwable, Object, Response> fromFileZIO(ZIO<Object, Throwable, File> getFile, Object trace) {
        return Http$FromOptionalHandlerZIO$.MODULE$.apply$extension(this.fromOptionalHandlerZIO(), (Function1 & Serializable & scala.Serializable)x$34 -> getFile.mapError((Function1 & Serializable & scala.Serializable)x$35 -> new Some(x$35), CanFail$.MODULE$.canFail(), trace).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            if (file.isFile() && !file.canRead()) {
                return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Handler$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new AccessDeniedException(file.getAbsolutePath())), trace);
            }
            return ZIO$.MODULE$.attempt((Function0 & Serializable & scala.Serializable)() -> {
                if (file.isFile()) {
                    Headers length = Headers$.MODULE$.apply((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{new Header.ContentLength(file.length())}));
                    Body x$2 = Body$.MODULE$.fromFile((File)file, Body$.MODULE$.fromFile$default$2());
                    Status x$3 = Response$.MODULE$.apply$default$1();
                    Response response = Response$.MODULE$.apply(x$3, length, x$2);
                    String pathName = ((Object)file.toPath()).toString();
                    return new Some(Handler$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> (Response)MODULE$.determineMediaType(pathName).fold((Function0 & Serializable & scala.Serializable)() -> response, (Function1 & Serializable & scala.Serializable)mediaType -> (Response)response.withHeader(new Header.ContentType((MediaType)mediaType, Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3())))));
                }
                return None$.MODULE$;
            }, trace).mapError((Function1 & Serializable & scala.Serializable)x$36 -> new Some(x$36), CanFail$.MODULE$.canFail(), trace).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 instanceof Some) {
                    Handler value = (Handler)((Some)x0$1).value();
                    return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> value, trace);
                }
                if (None$.MODULE$.equals(x0$1)) {
                    return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, trace);
                }
                throw new MatchError(x0$1);
            }, trace);
        }, trace).catchAll((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 instanceof Some) {
                Throwable throwable = (Throwable)((Some)x0$2).value();
                return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Handler$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> throwable), trace);
            }
            if (None$.MODULE$.equals(x0$2)) {
                return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, trace);
            }
            throw new MatchError(x0$2);
        }, CanFail$.MODULE$.canFail(), trace), trace);
    }

    public <R, Err, In, Out> Http<R, Err, In, Out> fromHandler(Handler<R, Err, In, Out> handler) {
        return new Http.Static<R, Err, In, Out>(handler, (Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>)None$.MODULE$);
    }

    public <In> BoxedUnit fromHandlerZIO() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromHttp() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromHttpZIO() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromOptionalHandler() {
        return BoxedUnit.UNIT;
    }

    public <In> BoxedUnit fromOptionalHandlerZIO() {
        return BoxedUnit.UNIT;
    }

    public Http<Object, Throwable, Object, Response> fromPath(String head, Seq<String> tail, Object trace) {
        return this.fromFile((Function0<File>)(Function0 & Serializable & scala.Serializable)() -> Paths.get(head, (String[])tail.toArray(ClassTag$.MODULE$.apply(String.class))).toFile(), trace);
    }

    public Http<Object, Throwable, Object, Response> fromResource(String path, Object trace) {
        return Http$FromHttpZIO$.MODULE$.apply$extension(this.fromHttpZIO(), (Function1 & Serializable & scala.Serializable)x$37 -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader().getResource(path), trace).map((Function1 & Serializable & scala.Serializable)resource -> {
            if (resource == null) {
                return MODULE$.empty();
            }
            return MODULE$.fromResourceWithURL((URL)resource, trace);
        }, trace).catchAll((Function1 & Serializable & scala.Serializable)throwable -> ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Handler$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> throwable).toHttp(trace), trace), CanFail$.MODULE$.canFail(), trace));
    }

    public Http<Object, Throwable, Object, URL> getResource(String path, Object trace) {
        return Http$FromOptionalHandlerZIO$.MODULE$.apply$extension(this.fromOptionalHandlerZIO(), (Function1 & Serializable & scala.Serializable)x$38 -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader().getResource(path), trace).mapError((Function1 & Serializable & scala.Serializable)x$39 -> new Some(x$39), CanFail$.MODULE$.canFail(), trace).flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            if (resource == null) {
                return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, trace);
            }
            return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Handler$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> resource), trace);
        }, trace).catchAll((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 instanceof Some) {
                Throwable throwable = (Throwable)((Some)x0$1).value();
                return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Handler$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> throwable), trace);
            }
            if (None$.MODULE$.equals(x0$1)) {
                return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, trace);
            }
            throw new MatchError(x0$1);
        }, CanFail$.MODULE$.canFail(), trace), trace);
    }

    public Http<Object, Throwable, Object, File> getResourceAsFile(String path, Object trace) {
        return this.getResource(path, trace).map((Function1 & Serializable & scala.Serializable)url -> new File(url.getPath()), trace);
    }

    public <R, Err> Http<R, Err, Request, Response> HttpRouteSyntax(Http<R, Err, Request, Response> self) {
        return self;
    }

    public <R, Err, In> Http<R, Err, In, Response> ResponseOutputSyntax(Http<R, Err, In, Response> self) {
        return self;
    }

    private Option<MediaType> determineMediaType(String filePath) {
        int n = filePath.lastIndexOf(".");
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        String ext = filePath.substring(n + 1);
        return MediaType$.MODULE$.forFileExtension(ext);
    }

    public Http<Object, Throwable, Object, Response> fromResourceWithURL(URL url, Object trace) {
        String string = url.getProtocol();
        if ("file".equals(string)) {
            return this.fromFile((Function0<File>)(Function0 & Serializable & scala.Serializable)() -> new File(url.getPath()), trace);
        }
        if ("jar".equals(string)) {
            String path = new URI(url.getPath()).getPath();
            int bangIndex = path.indexOf(33);
            String filePath = path.substring(0, bangIndex);
            String resourcePath = path.substring(bangIndex + 2);
            Option<MediaType> mediaType = this.determineMediaType(resourcePath);
            ZIO openZip = ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable & scala.Serializable)() -> new ZipFile(filePath), trace);
            Function1 & Serializable & scala.Serializable closeZip = (Function1 & Serializable & scala.Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> jar.close(), trace).ignoreLogged(trace);
            ZIO appZIO = ZIO.Acquire$.MODULE$.apply$extension(ZIO$.MODULE$.acquireReleaseWith((Function0 & Serializable & scala.Serializable)() -> openZip), (Function1)closeZip).apply((Function1 & Serializable & scala.Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)jar.getEntry(resourcePath)), trace).collect((Function0 & Serializable & scala.Serializable)() -> Http$.fileNotFound$1(resourcePath), (PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Option<ZipEntry>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (x1 instanceof Some) {
                        return (B1)((ZipEntry)((Some)x1).value());
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Option<ZipEntry> x1) {
                    return x1 instanceof Some;
                }
            }, trace).flatMap((Function1 & Serializable & scala.Serializable)entry -> ZIO$.MODULE$.when((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> entry.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> Http$.isDirectory$1(resourcePath), trace), trace).map((Function1 & Serializable & scala.Serializable)x$55 -> {
                long contentLength = entry.getSize();
                ZStream inZStream = ZStream$.MODULE$.acquireReleaseWith((Function0 & Serializable & scala.Serializable)() -> openZip, closeZip, trace).mapZIO((Function1 & Serializable & scala.Serializable)jar -> ZIO$.MODULE$.attemptBlocking((Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)jar.getEntry(resourcePath)), jar), trace), trace).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        ZipEntry entry = (ZipEntry)x0$1._1();
                        ZipFile jar = (ZipFile)x0$1._2();
                        return ZStream$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> jar.getInputStream(entry), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ZStream$.MODULE$.fromInputStream$default$2(), trace);
                    }
                    throw new MatchError(null);
                }, trace);
                Body x$1 = Body$.MODULE$.fromStream((ZStream<Object, Throwable, Object>)inZStream);
                Status x$2 = Response$.MODULE$.apply$default$1();
                Headers x$3 = Response$.MODULE$.apply$default$2();
                Response response = Response$.MODULE$.apply(x$2, x$3, x$1);
                return new Tuple4(x$55, (Object)BoxesRunTime.boxToLong((long)contentLength), (Object)inZStream, (Object)response);
            }, trace).map((Function1 & Serializable & scala.Serializable)x$56 -> {
                if (x$56 != null) {
                    long contentLength = BoxesRunTime.unboxToLong((Object)x$56._2());
                    Response response = (Response)x$56._4();
                    return (Response)mediaType.fold((Function0 & Serializable & scala.Serializable)() -> response, (Function1 & Serializable & scala.Serializable)t -> (Response)((HeaderModifier)response.withHeader(new Header.ContentType((MediaType)t, Header$ContentType$.MODULE$.apply$default$2(), Header$ContentType$.MODULE$.apply$default$3()))).withHeader(new Header.ContentLength(contentLength)));
                }
                throw new MatchError(null);
            }, trace), trace), trace);
            return Http$FromOptionalHandlerZIO$.MODULE$.apply$extension(this.fromOptionalHandlerZIO(), (Function1 & Serializable & scala.Serializable)x$57 -> appZIO.map((Function1 & Serializable & scala.Serializable)response -> Handler$.MODULE$.response((Function0<Response>)(Function0 & Serializable & scala.Serializable)() -> response), trace).catchAll((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 instanceof FileNotFoundException) {
                    return ZIO$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$, trace);
                }
                if (x0$2 != null) {
                    return ZIO$.MODULE$.succeed((Function0 & Serializable & scala.Serializable)() -> Handler$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> x0$2), trace);
                }
                throw new MatchError(null);
            }, CanFail$.MODULE$.canFail(), trace), trace);
        }
        return Handler$.MODULE$.fail((Function0 & Serializable & scala.Serializable)() -> new IllegalArgumentException(new StringBuilder(22).append("Unsupported protocol: ").append(string).toString())).toHttp(trace);
    }

    private static final FileNotFoundException fileNotFound$1(String resourcePath$1) {
        return new FileNotFoundException(new StringBuilder(19).append("Resource ").append(resourcePath$1).append(" not found").toString());
    }

    private static final IllegalArgumentException isDirectory$1(String resourcePath$1) {
        return new IllegalArgumentException(new StringBuilder(24).append("Resource ").append(resourcePath$1).append(" is a directory").toString());
    }

    private Http$() {
        MODULE$ = this;
        this.empty = new Http.Empty((Option<Function1<Cause<Nothing$>, ZIO<Object, Nothing$, BoxedUnit>>>)None$.MODULE$);
        this.bitmap$init$0 |= 4;
    }
}

