/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;
import zio.Chunk;
import zio.Chunk$;
import zio.Promise;
import zio.Queue;
import zio.Unsafe;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.http.ChannelEvent;
import zio.http.ChannelEvent$;
import zio.http.ChannelEvent$UserEvent$HandshakeComplete$;
import zio.http.ChannelEvent$UserEvent$HandshakeTimeout$;
import zio.http.WebSocketFrame;
import zio.http.WebSocketFrame$Binary$;
import zio.http.WebSocketFrame$Continuation$;
import zio.http.WebSocketFrame$Ping$;
import zio.http.WebSocketFrame$Pong$;
import zio.http.WebSocketFrame$Text$;
import zio.http.netty.NettyRuntime;
import zio.http.netty.NettyRuntime$;
import zio.http.netty.client.ChannelState;
import zio.http.netty.client.ChannelState$Invalid$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!\u0002\t\u0012\u0005U9\u0002\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t;\u0002\u0011\t\u0011)A\u0006=\")A\r\u0001C\u0001K\"9A\u000e\u0001b\u0001\n\u0017i\u0007BB9\u0001A\u0003%a\u000eC\u0003s\u0001\u0011%1\u000fC\u0005\u0002\u0010\u0001\t\n\u0011\"\u0003\u0002\u0012!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002V\u0001!I!a\u0016\u0003']+'mU8dW\u0016$\u0018\t\u001d9IC:$G.\u001a:\u000b\u0005I\u0019\u0012!\u00028fiRL(B\u0001\u000b\u0016\u0003\u0011AG\u000f\u001e9\u000b\u0003Y\t1A_5p'\t\u0001\u0001\u0004E\u0002\u001a?\u0005j\u0011A\u0007\u0006\u00037q\tqa\u00195b]:,GN\u0003\u0002\u0013;)\ta$\u0001\u0002j_&\u0011\u0001E\u0007\u0002\u001c'&l\u0007\u000f\\3DQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0011\u0005\tRS\"A\u0012\u000b\u0005\u0011*\u0013AC<fEN|7m[3uq*\u0011AC\n\u0006\u0003O!\nQaY8eK\u000eT!!\u000b\u000f\u0002\u000f!\fg\u000e\u001a7fe&\u00111f\t\u0002\u000f/\u0016\u00147k\\2lKR4%/Y7f\u0003\u0015QX\t_3d\u0007\u0001\u0001\"a\f\u0019\u000e\u0003EI!!M\t\u0003\u00199+G\u000f^=Sk:$\u0018.\\3\u0002\u000bE,X-^3\u0011\u0007Q*t'D\u0001\u0016\u0013\t1TCA\u0003Rk\u0016,X\r\u0005\u00029\u0005:\u0011\u0011\b\u0011\b\u0003u}r!a\u000f \u000e\u0003qR!!P\u0017\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t\t5#A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%!F,fEN{7m[3u\u0007\"\fgN\\3m\u000bZ,g\u000e\u001e\u0006\u0003\u0003N\t!b\u001c8D_6\u0004H.\u001a;f!\r9%\nT\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1q\n\u001d;j_:\u0004B\u0001N'P/&\u0011a*\u0006\u0002\b!J|W.[:f!\t\u0001FK\u0004\u0002R':\u00111HU\u0005\u0002\u0013&\u0011\u0011\tS\u0005\u0003+Z\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005\u0005C\u0005C\u0001-\\\u001b\u0005I&B\u0001.\u0012\u0003\u0019\u0019G.[3oi&\u0011A,\u0017\u0002\r\u0007\"\fgN\\3m'R\fG/Z\u0001\u0006iJ\f7-\u001a\t\u0003?\u0006t!A\u000f1\n\u0005\u0005+\u0012B\u00012d\u0005\u0015!&/Y2f\u0015\t\tU#\u0001\u0004=S:LGO\u0010\u000b\u0005M&T7\u000e\u0006\u0002hQB\u0011q\u0006\u0001\u0005\u0006;\u0016\u0001\u001dA\u0018\u0005\u0006Y\u0015\u0001\rA\f\u0005\u0006e\u0015\u0001\ra\r\u0005\u0006\u000b\u0016\u0001\rAR\u0001\fk:\u001c\u0018MZ3DY\u0006\u001c8/F\u0001o!\t!t.\u0003\u0002q+\t1QK\\:bM\u0016\fA\"\u001e8tC\u001a,7\t\\1tg\u0002\n\u0001\u0002Z5ta\u0006$8\r\u001b\u000b\u0006i^d\u0018Q\u0001\t\u0003\u000fVL!A\u001e%\u0003\tUs\u0017\u000e\u001e\u0005\u0006q\"\u0001\r!_\u0001\u0004GRD\bCA\r{\u0013\tY(DA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000buD\u0001\u0019\u0001@\u0002\u000b\u00154XM\u001c;\u0011\t}\f\t!I\u0007\u0002'%\u0019\u00111A\n\u0003\u0019\rC\u0017M\u001c8fY\u00163XM\u001c;\t\u0013\u0005\u001d\u0001\u0002%AA\u0002\u0005%\u0011!B2m_N,\u0007cA$\u0002\f%\u0019\u0011Q\u0002%\u0003\u000f\t{w\u000e\\3b]\u0006\u0011B-[:qCR\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019B\u000b\u0003\u0002\n\u0005U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0002*\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019\rD\u0017M\u001c8fYJ+\u0017\r\u001a\u0019\u0015\u000bQ\fY#!\f\t\u000baT\u0001\u0019A=\t\r\u0005=\"\u00021\u0001\"\u0003\ri7oZ\u0001\u0012G\"\fgN\\3m%\u0016<\u0017n\u001d;fe\u0016$Gc\u0001;\u00026!)\u0001p\u0003a\u0001s\u0006\u00192\r[1o]\u0016dWK\u001c:fO&\u001cH/\u001a:fIR\u0019A/a\u000f\t\u000bad\u0001\u0019A=\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$R\u0001^A!\u0003\u0007BQ\u0001_\u0007A\u0002eDa!!\u0012\u000e\u0001\u0004y\u0015!B2bkN,\u0017AE;tKJ,e/\u001a8u)JLwmZ3sK\u0012$R\u0001^A&\u0003\u001bBQ\u0001\u001f\bA\u0002eDq!a\f\u000f\u0001\u0004\ty\u0005E\u0002H\u0003#J1!a\u0015I\u0005\u0019\te.\u001f*fM\u0006qaM]1nK\u001a\u0013x.\u001c(fiRLH\u0003BA-\u0003;\u00022a`A.\u0013\tY3\u0003\u0003\u0004\u0002`=\u0001\r!I\u0001\u0007U\u001a\u0013\u0018-\\3")
public final class WebSocketAppHandler
extends SimpleChannelInboundHandler<io.netty.handler.codec.http.websocketx.WebSocketFrame> {
    private final NettyRuntime zExec;
    private final Queue<ChannelEvent<WebSocketFrame>> queue;
    private final Option<Promise<Throwable, ChannelState>> onComplete;
    private final Object trace;
    private final Unsafe unsafeClass;
    private volatile boolean bitmap$init$0;

    private Unsafe unsafeClass() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/zio-http/zio-http/zio-http/src/main/scala/zio/http/netty/WebSocketAppHandler.scala: 42");
        }
        return this.unsafeClass;
    }

    private void dispatch(ChannelHandlerContext ctx, ChannelEvent<io.netty.handler.codec.http.websocketx.WebSocketFrame> event, boolean close) {
        this.zExec.runUninterruptible(ctx, NettyRuntime$.MODULE$.noopEnsuring(), (ZIO<Object, Throwable, Object>)this.queue.offer(event.map((Function1 & Serializable & scala.Serializable)jFrame -> this.frameFromNetty((io.netty.handler.codec.http.websocketx.WebSocketFrame)jFrame)), this.trace).$times$greater((Function0 & Serializable & scala.Serializable)() -> {
            Option<Promise<Throwable, ChannelState>> option = $this.onComplete;
            if (option instanceof Some) {
                Promise promise = (Promise)((Some)option).value();
                if (close) {
                    return promise.succeed((Object)ChannelState$Invalid$.MODULE$, $this.trace);
                }
            }
            return ZIO$.MODULE$.unit();
        }, this.trace), this.unsafeClass(), this.trace);
    }

    private boolean dispatch$default$3() {
        return false;
    }

    public void channelRead0(ChannelHandlerContext ctx, io.netty.handler.codec.http.websocketx.WebSocketFrame msg) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.read(msg), this.dispatch$default$3());
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.registered(), this.dispatch$default$3());
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.unregistered(), true);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dispatch(ctx, ChannelEvent$.MODULE$.exceptionCaught(cause), this.dispatch$default$3());
        Option<Promise<Throwable, ChannelState>> option = this.onComplete;
        if (option instanceof Some) {
            ((Promise)((Some)option).value()).fail((Object)cause, this.trace);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof WebSocketServerProtocolHandler.HandshakeComplete ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE.equals(msg)) {
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeComplete$.MODULE$), this.dispatch$default$3());
            return;
        }
        if (WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg) ? true : WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_TIMEOUT.equals(msg)) {
            this.dispatch(ctx, ChannelEvent$.MODULE$.userEventTriggered(ChannelEvent$UserEvent$HandshakeTimeout$.MODULE$), this.dispatch$default$3());
            return;
        }
        super.userEventTriggered(ctx, msg);
    }

    private WebSocketFrame frameFromNetty(io.netty.handler.codec.http.websocketx.WebSocketFrame jFrame) {
        if (jFrame instanceof PingWebSocketFrame) {
            return WebSocketFrame$Ping$.MODULE$;
        }
        if (jFrame instanceof PongWebSocketFrame) {
            return WebSocketFrame$Pong$.MODULE$;
        }
        if (jFrame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)jFrame;
            return WebSocketFrame$Binary$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)binaryWebSocketFrame.content())), binaryWebSocketFrame.isFinalFragment());
        }
        if (jFrame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)jFrame;
            return WebSocketFrame$Text$.MODULE$.apply(textWebSocketFrame.text(), textWebSocketFrame.isFinalFragment());
        }
        if (jFrame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)jFrame;
            return new WebSocketFrame.Close(closeWebSocketFrame.statusCode(), (Option<String>)Option$.MODULE$.apply((Object)closeWebSocketFrame.reasonText()));
        }
        if (jFrame instanceof ContinuationWebSocketFrame) {
            ContinuationWebSocketFrame continuationWebSocketFrame = (ContinuationWebSocketFrame)jFrame;
            return WebSocketFrame$Continuation$.MODULE$.apply((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)ByteBufUtil.getBytes((ByteBuf)continuationWebSocketFrame.content())), continuationWebSocketFrame.isFinalFragment());
        }
        return null;
    }

    public WebSocketAppHandler(NettyRuntime zExec, Queue<ChannelEvent<WebSocketFrame>> queue, Option<Promise<Throwable, ChannelState>> onComplete, Object trace) {
        this.zExec = zExec;
        this.queue = queue;
        this.onComplete = onComplete;
        this.trace = trace;
        this.unsafeClass = Unsafe$.MODULE$.unsafe();
        this.bitmap$init$0 = true;
    }
}

