/*
 * Decompiled with CFR 0.152.
 */
package zio.http.netty.socket;

import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import scala.MatchError;
import scala.Predef$;
import zio.http.SocketDecoder;
import zio.http.WebSocketConfig;
import zio.http.WebSocketConfig$CloseStatus$AbnormalClosure$;
import zio.http.WebSocketConfig$CloseStatus$BadGateway$;
import zio.http.WebSocketConfig$CloseStatus$Empty$;
import zio.http.WebSocketConfig$CloseStatus$EndpointUnavailable$;
import zio.http.WebSocketConfig$CloseStatus$InternalServerError$;
import zio.http.WebSocketConfig$CloseStatus$InvalidMessageType$;
import zio.http.WebSocketConfig$CloseStatus$InvalidPayloadData$;
import zio.http.WebSocketConfig$CloseStatus$MandatoryExtension$;
import zio.http.WebSocketConfig$CloseStatus$MessageTooBig$;
import zio.http.WebSocketConfig$CloseStatus$NormalClosure$;
import zio.http.WebSocketConfig$CloseStatus$PolicyViolation$;
import zio.http.WebSocketConfig$CloseStatus$ProtocolError$;
import zio.http.WebSocketConfig$CloseStatus$ServiceRestart$;
import zio.http.WebSocketConfig$CloseStatus$TlsHandshakeFailed$;
import zio.http.WebSocketConfig$CloseStatus$TryAgainLater$;

public final class NettySocketProtocol$ {
    public static NettySocketProtocol$ MODULE$;

    static {
        new NettySocketProtocol$();
    }

    public WebSocketClientProtocolConfig.Builder clientBuilder(WebSocketConfig webSocketConfig) {
        return WebSocketClientProtocolConfig.newBuilder().subprotocol((String)webSocketConfig.subprotocols().orNull(Predef$.MODULE$.$conforms())).handshakeTimeoutMillis(webSocketConfig.handshakeTimeoutMillis()).forceCloseTimeoutMillis(webSocketConfig.forceCloseTimeoutMillis()).handleCloseFrames(webSocketConfig.handleCloseFrames()).sendCloseFrame(this.closeStatusToNetty(webSocketConfig.sendCloseFrame())).dropPongFrames(webSocketConfig.dropPongFrames());
    }

    public WebSocketServerProtocolConfig.Builder serverBuilder(WebSocketConfig webSocketConfig) {
        return WebSocketServerProtocolConfig.newBuilder().checkStartsWith(true).websocketPath("").subprotocols((String)webSocketConfig.subprotocols().orNull(Predef$.MODULE$.$conforms())).handshakeTimeoutMillis(webSocketConfig.handshakeTimeoutMillis()).forceCloseTimeoutMillis(webSocketConfig.forceCloseTimeoutMillis()).handleCloseFrames(webSocketConfig.handleCloseFrames()).sendCloseFrame(this.closeStatusToNetty(webSocketConfig.sendCloseFrame())).dropPongFrames(webSocketConfig.dropPongFrames()).decoderConfig(this.socketDecoderToNetty(webSocketConfig.decoderConfig()));
    }

    private WebSocketCloseStatus closeStatusToNetty(WebSocketConfig.CloseStatus closeStatus) {
        if (WebSocketConfig$CloseStatus$NormalClosure$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.NORMAL_CLOSURE;
        }
        if (WebSocketConfig$CloseStatus$EndpointUnavailable$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.ENDPOINT_UNAVAILABLE;
        }
        if (WebSocketConfig$CloseStatus$ProtocolError$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.PROTOCOL_ERROR;
        }
        if (WebSocketConfig$CloseStatus$InvalidMessageType$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.INVALID_MESSAGE_TYPE;
        }
        if (WebSocketConfig$CloseStatus$InvalidPayloadData$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.INVALID_PAYLOAD_DATA;
        }
        if (WebSocketConfig$CloseStatus$PolicyViolation$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.POLICY_VIOLATION;
        }
        if (WebSocketConfig$CloseStatus$MessageTooBig$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.MESSAGE_TOO_BIG;
        }
        if (WebSocketConfig$CloseStatus$MandatoryExtension$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.MANDATORY_EXTENSION;
        }
        if (WebSocketConfig$CloseStatus$InternalServerError$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.INTERNAL_SERVER_ERROR;
        }
        if (WebSocketConfig$CloseStatus$ServiceRestart$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.SERVICE_RESTART;
        }
        if (WebSocketConfig$CloseStatus$TryAgainLater$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.TRY_AGAIN_LATER;
        }
        if (WebSocketConfig$CloseStatus$BadGateway$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.BAD_GATEWAY;
        }
        if (WebSocketConfig$CloseStatus$Empty$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.EMPTY;
        }
        if (WebSocketConfig$CloseStatus$AbnormalClosure$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.ABNORMAL_CLOSURE;
        }
        if (WebSocketConfig$CloseStatus$TlsHandshakeFailed$.MODULE$.equals(closeStatus)) {
            return WebSocketCloseStatus.TLS_HANDSHAKE_FAILED;
        }
        if (closeStatus instanceof WebSocketConfig.CloseStatus.Custom) {
            WebSocketConfig.CloseStatus.Custom custom = (WebSocketConfig.CloseStatus.Custom)closeStatus;
            int code = custom.code();
            String message = custom.reason();
            return new WebSocketCloseStatus(code, message);
        }
        throw new MatchError((Object)closeStatus);
    }

    private WebSocketDecoderConfig socketDecoderToNetty(SocketDecoder socketDecoder) {
        return WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(socketDecoder.maxFramePayloadLength()).expectMaskedFrames(socketDecoder.expectMaskedFrames()).allowMaskMismatch(socketDecoder.allowMaskMismatch()).allowExtensions(socketDecoder.allowExtensions()).closeOnProtocolViolation(socketDecoder.closeOnProtocolViolation()).withUTF8Validator(socketDecoder.withUTF8Validator()).build();
    }

    private NettySocketProtocol$() {
        MODULE$ = this;
    }
}

